/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandlerSlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SlotValueMap;
import org.jspecify.annotations.Nullable;

public abstract class InventoryHandler
extends ItemStacksResourceHandler
implements ITrackedContentsItemResourceHandler,
IndexModifier<ItemResource> {
    protected final IStorageWrapper storageWrapper;
    private final ContainerContents.InventoryData inventoryData;
    private final Runnable saveHandler;
    private final List<IntConsumer> onContentsChangedListeners = new ArrayList<IntConsumer>();
    private boolean persistent = true;
    private ISlotTracker slotTracker = new ISlotTracker.Noop();
    private int baseSlotLimit;
    private double maxStackSizeMultiplier;
    private boolean isInitializing;
    private final StackUpgradeConfig stackUpgradeConfig;
    private final InventoryPartitioner inventoryPartitioner;
    private Consumer<Set<Item>> filterItemsChangeListener = s -> {};
    private final SlotValueMap<Item> filterItemSlots = new SlotValueMap();
    private BooleanSupplier shouldInsertIntoEmpty = () -> true;
    private boolean voidUpgradeInfoInitialized = false;
    private boolean hasVoidUpgrade = false;
    private final SlotTrackerJournal slotTrackerJournal = new SlotTrackerJournal();

    protected InventoryHandler(int numberOfInventorySlots, IStorageWrapper storageWrapper, ContainerContents containerContents, Runnable saveHandler, int baseSlotLimit, StackUpgradeConfig stackUpgradeConfig) {
        super(numberOfInventorySlots);
        this.stackUpgradeConfig = stackUpgradeConfig;
        this.isInitializing = true;
        this.storageWrapper = storageWrapper;
        this.inventoryData = containerContents.inventory();
        this.saveHandler = saveHandler;
        this.setBaseSlotLimit(baseSlotLimit);
        this.loadStacksFromData();
        this.inventoryPartitioner = new InventoryPartitioner(containerContents.partitioner(), this, () -> storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
        this.getSlotTracker().refreshSlotIndexesFrom(this);
        this.isInitializing = false;
    }

    protected final void directSet(int index, ItemResource resource, int amount) {
        if (amount == 0) {
            super.set(index, (Resource)ItemResource.EMPTY, 0);
            return;
        }
        super.set(index, (Resource)resource, amount);
    }

    public void set(int index, ItemResource resource, int amount) {
        this.inventoryPartitioner.getPartBySlot(index).set(index, resource, amount, (IndexModifier<ItemResource>)((IndexModifier)this::directSet));
    }

    public ISlotTracker getSlotTracker() {
        this.initSlotTracker();
        return this.slotTracker;
    }

    protected void onContentsChanged(int index, ItemStack previousContents) {
        super.onContentsChanged(index, (Object)previousContents);
        ItemStack current = this.getInternalStack(index);
        this.getSlotTracker().removeAndSetSlotIndexes(this, index, current);
        if (this.persistent && this.updateSlotStack(index)) {
            this.saveInventory();
            this.triggerOnChangeListeners(index);
        }
    }

    private void runOnAfterInsert(int index, TransactionContext tx) {
        this.storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IInsertResponseUpgrade.class).forEach(u -> u.onAfterInsert(this, index, tx));
    }

    public void triggerOnChangeListeners(int slot) {
        for (IntConsumer onContentsChangedListener : this.onContentsChangedListeners) {
            onContentsChangedListener.accept(slot);
        }
    }

    private boolean updateSlotStack(int slot) {
        ItemStack slotStack = this.getInternalStack(slot);
        if (!(this.inventoryData.stacks().size() <= slot || ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)this.inventoryData.stacks().get(slot)), (ItemStack)slotStack) && ((ItemStack)this.inventoryData.stacks().get(slot)).getCount() == slotStack.getCount())) {
            this.inventoryData.stacks().set(slot, (Object)slotStack.copy());
            return true;
        }
        return false;
    }

    private void loadStacksFromData() {
        this.slotTracker.clear();
        if (this.inventoryData.stacks().size() < this.stacks.size()) {
            this.inventoryData.resize(this.stacks.size());
        }
        for (int slot = 0; slot < this.stacks.size() && slot < this.inventoryData.stacks().size(); ++slot) {
            ItemStack stack = (ItemStack)this.inventoryData.stacks().get(slot);
            this.stacks.set(slot, (Object)stack.copy());
        }
        this.slotTracker.refreshSlotIndexesFrom(this);
    }

    public int getBaseSlotLimit() {
        return this.baseSlotLimit;
    }

    @Override
    public int getInternalSlotLimit(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getSlotLimit(slot);
    }

    protected int getCapacityNoInit(int index, ItemResource resource) {
        return this.inventoryPartitioner.getPartBySlot(index).getCapacity(index, resource);
    }

    protected int getCapacity(int index, ItemResource resource) {
        return this.inventoryPartitioner.getPartBySlot(index).getCapacity(index, resource);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        Objects.checkIndex(index, this.size());
        return this.getCapacity(index, resource);
    }

    public int getBaseCapacity(ItemResource resource) {
        int maxStackSize;
        if (!this.stackUpgradeConfig.canStackItem(resource.getItem())) {
            return resource.getMaxStackSize();
        }
        int n = maxStackSize = resource.isEmpty() ? this.getBaseSlotLimit() : resource.getMaxStackSize();
        if (this.baseSlotLimit < 64) {
            return (int)Math.max(1.0, (double)maxStackSize * (double)this.baseSlotLimit / 64.0);
        }
        int limit = MathHelper.intMaxCappedMultiply(maxStackSize, this.baseSlotLimit / 64);
        int remainder = this.baseSlotLimit % 64;
        if (remainder > 0) {
            limit = MathHelper.intMaxCappedAddition(limit, remainder * maxStackSize / 64);
        }
        return limit;
    }

    public Item getFilterItem(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).getFilterItem(slot);
    }

    public boolean isFilterItem(Item item) {
        return this.inventoryPartitioner.isFilterItem(item);
    }

    public void setBaseSlotLimit(int baseSlotLimit) {
        this.voidUpgradeInfoInitialized = false;
        this.baseSlotLimit = baseSlotLimit;
        this.maxStackSizeMultiplier = (float)baseSlotLimit / 64.0f;
        if (this.inventoryPartitioner != null) {
            this.inventoryPartitioner.onSlotLimitChange();
        }
        if (!this.isInitializing) {
            this.slotTracker.refreshSlotIndexesFrom(this);
        }
    }

    public int extract(ItemResource resource, int amount, TransactionContext transaction) {
        int extracted;
        int slot;
        ISlotTracker tracker = this.getSlotTracker();
        ItemStackKey stackKey = ItemStackKey.of(resource);
        int originalSize = tracker.getFullSlots(stackKey).size();
        int i = 0;
        for (extracted = 0; extracted < amount && i++ < originalSize; extracted += this.extract(slot, resource, amount - extracted, transaction)) {
            slot = tracker.getFullSlots(stackKey).iterator().next();
        }
        if (extracted >= amount) {
            return extracted;
        }
        originalSize = tracker.getPartialSlots(stackKey).size();
        i = 0;
        while (extracted < amount && i++ < originalSize) {
            slot = tracker.getPartialSlots(stackKey).iterator().next();
            extracted += this.extract(slot, resource, amount - extracted, transaction);
        }
        return extracted;
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        int result = this.inventoryPartitioner.getPartBySlot(index).extract(index, resource, amount, transaction, (x$0, x$1, x$2, x$3) -> super.extract(x$0, x$1, x$2, x$3));
        if (result > 0) {
            this.slotTrackerJournal.updateSnapshots(transaction);
            this.getSlotTracker().removeAndSetSlotIndexes(this, index, this.getStackInSlot(index));
        }
        return result;
    }

    public ItemResource getResource(int index) {
        return this.inventoryPartitioner.getPartBySlot(index).getResource(index, x$0 -> (ItemResource)super.getResource(x$0));
    }

    public long getAmountAsLong(int index) {
        return this.inventoryPartitioner.getPartBySlot(index).getAmountAsLong(index, x$0 -> super.getAmountAsLong(x$0));
    }

    public ItemStack getInternalStack(int slot) {
        return (ItemStack)this.stacks.get(slot);
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        this.inventoryPartitioner.getPartBySlot(slot).setStackInSlot(slot, stack, this::setStackInSlotInternal);
    }

    public void setStackInSlotInternal(int slot, ItemStack stack) {
        ItemStack previousContents = (ItemStack)this.stacks.get(slot);
        this.stacks.set(slot, (Object)stack);
        this.getSlotTracker().removeAndSetSlotIndexes(this, slot, stack);
        this.onContentsChanged(slot, previousContents);
    }

    public int insert(ItemResource resource, int amount, TransactionContext tx) {
        int slot;
        int slot2;
        int i;
        ISlotTracker tracker = this.getSlotTracker();
        MemorySettingsCategory mem = this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        Item item = resource.getItem();
        ItemStackKey key = ItemStackKey.of(resource);
        int moved = 0;
        if ((moved += this.handleOverflow(resource, amount)) >= amount) {
            return moved;
        }
        if (!tracker.getPartialSlots(key).isEmpty()) {
            int sizeBefore = tracker.getPartialSlots(key).size();
            i = 0;
            while (moved < amount && i++ < sizeBefore && (slot2 = tracker.getPartialSlots(key).iterator().next().intValue()) != -1) {
                moved += this.insert(slot2, resource, amount - moved, tx);
            }
        }
        if (moved >= amount) {
            return moved;
        }
        Iterator<Object> sizeBefore = mem.getFilterItemSlots().getOrDefault(item, Collections.emptySet()).iterator();
        while (sizeBefore.hasNext()) {
            slot = (Integer)sizeBefore.next();
            if (moved >= amount) break;
            if (!tracker.getEmptySlots().contains(slot)) continue;
            moved += this.insert(slot, resource, amount - moved, tx);
        }
        if (moved >= amount) {
            return moved;
        }
        sizeBefore = mem.getFilterStackSlots().getOrDefault(key.hashCode(), Collections.emptySet()).iterator();
        while (sizeBefore.hasNext()) {
            slot = (Integer)sizeBefore.next();
            if (moved >= amount) break;
            if (!tracker.getEmptySlots().contains(slot)) continue;
            moved += this.insert(slot, resource, amount - moved, tx);
        }
        if (moved >= amount) {
            return moved;
        }
        sizeBefore = this.filterItemSlots.getSlots(item).iterator();
        while (sizeBefore.hasNext()) {
            slot = (Integer)sizeBefore.next();
            if (moved >= amount) break;
            if (!tracker.getEmptySlots().contains(slot)) continue;
            moved += this.insert(slot, resource, amount - moved, tx);
        }
        if (moved >= amount) {
            return moved;
        }
        if (this.shouldInsertIntoEmpty.getAsBoolean()) {
            int sizeBefore2 = tracker.getEmptySlots().size();
            i = 0;
            while (moved < amount && i++ < sizeBefore2 && (slot2 = this.pickNextPlaceableEmptySlot(tracker.getEmptySlots(), mem, resource)) != -1) {
                moved += this.insert(slot2, resource, amount - moved, tx);
            }
        }
        return moved;
    }

    private int pickNextPlaceableEmptySlot(Set<Integer> slots, MemorySettingsCategory mem, ItemResource resource) {
        for (int slot : slots) {
            if (mem.isSlotSelected(slot) && !mem.matchesFilter(slot, resource) || this.filterItemSlots.containsSlot(slot) && !this.filterItemSlots.getSlots(resource.getItem()).contains(slot)) continue;
            return slot;
        }
        return -1;
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext tx) {
        int inserted = this.runOnBeforeInsert(index, resource, amount, this.storageWrapper);
        if (inserted >= amount) {
            return amount;
        }
        int result = this.inventoryPartitioner.getPartBySlot(index).insert(index, resource, amount - (inserted += this.handleOverflow(resource, amount)), tx, (x$0, x$1, x$2, x$3) -> super.insert(x$0, x$1, x$2, x$3));
        if (result > 0) {
            this.slotTrackerJournal.updateSnapshots(tx);
            this.getSlotTracker().removeAndSetSlotIndexes(this, index, this.getStackInSlot(index));
        }
        inserted += result;
        this.runOnAfterInsert(index, tx);
        return inserted += this.handleOverflow(resource, amount);
    }

    public ItemStack insertItemOnlyToSlot(int slot, ItemStack stack) {
        this.initSlotTracker();
        ItemResource resource = this.getResource(slot);
        if (resource.matches(stack)) {
            return this.triggerOverflowUpgrades(this.insertItem(slot, stack));
        }
        return this.insertItem(slot, stack);
    }

    private void initSlotTracker() {
        if (!(this.slotTracker instanceof InventoryHandlerSlotTracker)) {
            this.slotTracker = new InventoryHandlerSlotTracker(this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), this.filterItemSlots);
            this.slotTracker.refreshSlotIndexesFrom(this);
            this.slotTracker.setShouldInsertIntoEmpty(this.shouldInsertIntoEmpty);
        }
    }

    private ItemStack insertItem(int slot, ItemStack stack) {
        int inserted;
        ItemResource resource = ItemResource.of((ItemStack)stack);
        int amount = stack.getCount();
        try (Transaction tx = Transaction.openRoot();){
            inserted = this.insert(slot, resource, amount, (TransactionContext)tx);
            if (inserted > 0) {
                tx.commit();
            }
        }
        if (inserted == 0) {
            return stack;
        }
        if (inserted >= amount) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(amount - inserted);
    }

    private int handleOverflow(ItemResource resource, int amount) {
        if (!this.hasVoidUpgrade()) {
            return 0;
        }
        ItemStackKey stackKey = ItemStackKey.of(resource);
        if (this.hasOneFullStackOfItem(stackKey)) {
            return this.triggerOverflowUpgrades(resource, amount);
        }
        return 0;
    }

    private boolean hasOneFullStackOfItem(ItemStackKey stackKey) {
        return this.getSlotTracker().getFullStacks().contains(stackKey) && !this.getSlotTracker().getFullSlots(stackKey).isEmpty();
    }

    private ItemStack triggerOverflowUpgrades(ItemStack ret) {
        IOverflowResponseUpgrade overflowUpgrade;
        Iterator<IOverflowResponseUpgrade> iterator = this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(IOverflowResponseUpgrade.class).iterator();
        while (iterator.hasNext() && !(ret = (overflowUpgrade = iterator.next()).onOverflow(ret)).isEmpty()) {
        }
        return ret;
    }

    private int triggerOverflowUpgrades(ItemResource resource, int amount) {
        IOverflowResponseUpgrade overflowUpgrade;
        int ret = 0;
        Iterator<IOverflowResponseUpgrade> iterator = this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(IOverflowResponseUpgrade.class).iterator();
        while (iterator.hasNext() && (ret = (overflowUpgrade = iterator.next()).onOverflow(resource, amount)) < amount) {
        }
        return ret;
    }

    private int runOnBeforeInsert(int slot, ItemResource resource, int amount, IStorageWrapper storageWrapper) {
        List<IInsertResponseUpgrade> wrappers = storageWrapper.getUpgradeHandler().getWrappersThatImplementFromMainStorage(IInsertResponseUpgrade.class);
        int moved = 0;
        for (IInsertResponseUpgrade upgrade : wrappers) {
            if ((moved += upgrade.onBeforeInsert(this, slot, resource, amount - moved)) != amount) continue;
            return amount;
        }
        return moved;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.isItemValid(slot, stack, null);
    }

    public boolean isItemValid(int slot, ItemStack stack, @Nullable Player player) {
        return this.isItemValid(slot, ItemResource.of((ItemStack)stack), player);
    }

    public boolean isItemValid(int slot, ItemResource resource, @Nullable Player player) {
        return this.inventoryPartitioner.getPartBySlot(slot).isValid(slot, resource, player, (x$0, x$1) -> super.isValid(x$0, x$1)) && this.isAllowed(resource) && this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).matchesFilter(slot, resource);
    }

    public boolean isValid(int slot, ItemResource resource) {
        return this.isItemValid(slot, resource, null);
    }

    protected abstract boolean isAllowed(ItemResource var1);

    public void saveInventory() {
        this.saveHandler.run();
    }

    public @Nullable Identifier getNoItemIcon(int slotIndex) {
        return this.inventoryPartitioner.getNoItemIcon(slotIndex);
    }

    public void copyStacksTo(InventoryHandler otherHandler) {
        InventoryHelper.copyTo(this, otherHandler);
    }

    public void addListener(IntConsumer onContentsChanged) {
        this.onContentsChangedListeners.add(onContentsChanged);
    }

    public void clearListeners() {
        this.onContentsChangedListeners.clear();
    }

    public double getStackSizeMultiplier() {
        return this.maxStackSizeMultiplier;
    }

    @Override
    public Set<ItemStackKey> getTrackedStacks() {
        this.initSlotTracker();
        HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>(this.slotTracker.getFullStacks());
        ret.addAll(this.slotTracker.getPartialStacks());
        return ret;
    }

    @Override
    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.getSlotTracker().registerListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
    }

    @Override
    public void unregisterStackKeyListeners() {
        this.slotTracker.unregisterStackKeyListeners();
    }

    @Override
    public boolean hasEmptySlots() {
        return this.slotTracker.hasEmptySlots();
    }

    public InventoryPartitioner getInventoryPartitioner() {
        return this.inventoryPartitioner;
    }

    public boolean isSlotAccessible(int slot) {
        return this.inventoryPartitioner.getPartBySlot(slot).isSlotAccessible(slot);
    }

    public Set<Integer> getNoSortSlots() {
        return this.inventoryPartitioner.getNoSortSlots();
    }

    public void onSlotFilterChanged(int slot) {
        this.inventoryPartitioner.getPartBySlot(slot).onSlotFilterChanged(slot);
    }

    public void registerFilterItemsChangeListener(Consumer<Set<Item>> listener) {
        this.filterItemsChangeListener = listener;
    }

    public void unregisterFilterItemsChangeListener() {
        this.filterItemsChangeListener = s -> {};
    }

    public void initFilterItems() {
        this.inventoryPartitioner.getFilterItems().forEach((item, slots) -> slots.forEach(slot -> this.filterItemSlots.add((int)slot, (Item)item)));
    }

    public void onFilterItemsChanged() {
        this.slotTracker.refreshSlotIndexesFrom(this);
        if (this.inventoryPartitioner == null) {
            return;
        }
        this.filterItemSlots.clear();
        this.inventoryPartitioner.getFilterItems().forEach((item, slots) -> slots.forEach(slot -> this.filterItemSlots.add((int)slot, (Item)item)));
        this.filterItemsChangeListener.accept(this.filterItemSlots.keySet());
    }

    public Set<Item> getFilterItems() {
        return this.filterItemSlots.keySet();
    }

    public void onInit() {
        if (this.inventoryPartitioner == null) {
            return;
        }
        this.inventoryPartitioner.onInit();
        this.slotTracker = new ISlotTracker.Noop();
    }

    public void setShouldInsertIntoEmpty(BooleanSupplier shouldInsertIntoEmpty) {
        this.shouldInsertIntoEmpty = shouldInsertIntoEmpty;
        this.getSlotTracker().setShouldInsertIntoEmpty(shouldInsertIntoEmpty);
    }

    public boolean isInfinite(int slot) {
        return this.inventoryPartitioner.isInfinite(slot);
    }

    @Override
    public ItemStack getStackInSlot(int index) {
        Objects.checkIndex(index, this.size());
        return this.inventoryPartitioner.getPartBySlot(index).getStackInSlot(index, slot -> (ItemStack)this.stacks.get(slot));
    }

    private boolean hasVoidUpgrade() {
        if (!this.voidUpgradeInfoInitialized) {
            this.hasVoidUpgrade = !this.storageWrapper.getUpgradeHandler().getTypeWrappers(VoidUpgradeItem.TYPE).isEmpty();
            this.voidUpgradeInfoInitialized = true;
        }
        return this.hasVoidUpgrade;
    }

    public boolean isInsertBlocked() {
        if (this.hasVoidUpgrade()) {
            return false;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            ItemResource resource = ItemResource.of((ItemStack)stack);
            if (stack.getCount() >= this.getCapacity(i, resource)) continue;
            return false;
        }
        return true;
    }

    private class SlotTrackerJournal
    extends SnapshotJournal<Void> {
        private SlotTrackerJournal() {
        }

        protected Void createSnapshot() {
            return null;
        }

        protected void revertToSnapshot(Void unused) {
            InventoryHandler.this.getSlotTracker().refreshSlotIndexesFrom(InventoryHandler.this);
        }
    }
}

