/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.transfer.item.ItemResource;

public final class ItemStackKey {
    private final ItemStack stack;
    private static final Map<ItemStack, ItemStackKey> CACHE = new ConcurrentHashMap<ItemStack, ItemStackKey>();
    private static final Map<ItemResource, ItemStackKey> RESOURCE_CACHE = new ConcurrentHashMap<ItemResource, ItemStackKey>();
    private boolean hashInitialized = false;
    private int hash;

    public static ItemStackKey of(ItemStack stack) {
        return CACHE.computeIfAbsent(stack, ItemStackKey::new);
    }

    public static ItemStackKey of(ItemResource resource) {
        return RESOURCE_CACHE.computeIfAbsent(resource, r -> ItemStackKey.of(r.toStack()));
    }

    private ItemStackKey(ItemStack stack) {
        this.stack = stack.copy();
        this.stack.setCount(1);
    }

    public static void clearCacheOnTickEnd(ServerTickEvent.Post event) {
        CACHE.clear();
    }

    public ItemResource toResource() {
        return ItemResource.of((ItemStack)this.stack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStackKey that = (ItemStackKey)o;
        return ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)that.stack);
    }

    public boolean hashCodeNotEquals(ItemStack otherStack) {
        return this.hashCode() != ItemStack.hashItemAndComponents((ItemStack)otherStack);
    }

    public int hashCode() {
        if (!this.hashInitialized) {
            this.hashInitialized = true;
            this.hash = ItemStack.hashItemAndComponents((ItemStack)this.stack);
        }
        return this.hash;
    }

    public boolean matches(ItemStack stack) {
        return this.hashCode() == ItemStack.hashItemAndComponents((ItemStack)stack);
    }

    public ItemStack stack() {
        return this.stack;
    }

    public String toString() {
        return "ItemStackKey[stack=" + String.valueOf(this.stack) + "]";
    }
}

