/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.renderdata;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.TankPosition;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeClientDataType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;
import org.jspecify.annotations.Nullable;

public final class RenderData {
    private static final Map<String, UpgradeClientDataType<?>> CLIENT_DATA_TYPES = new HashMap();
    public static final RenderData EMPTY = new RenderData();
    public static final Codec<RenderData> CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, RenderData> STREAM_CODEC;
    private final List<ItemStack> upgradeItems;
    private final Map<UpgradeClientDataType<?>, IUpgradeClientData> upgradeData;
    private final Map<TankPosition, TankRenderData> tanks;
    private Optional<BatteryRenderData> battery;
    private final DisplayData display;

    public static <T extends IUpgradeClientData> void register(UpgradeClientDataType<T> type) {
        CLIENT_DATA_TYPES.put(type.getName(), type);
    }

    public RenderData() {
        this.upgradeItems = new ArrayList<ItemStack>();
        this.upgradeData = new HashMap();
        this.tanks = new HashMap<TankPosition, TankRenderData>();
        this.battery = Optional.empty();
        this.display = new DisplayData();
    }

    public RenderData(List<ItemStack> upgradeItems, Map<UpgradeClientDataType<?>, IUpgradeClientData> upgradeData, Map<TankPosition, TankRenderData> tanks, Optional<BatteryRenderData> battery, DisplayData display) {
        this.upgradeItems = upgradeItems;
        this.upgradeData = upgradeData;
        this.tanks = tanks;
        this.battery = battery;
        this.display = display;
    }

    public void setUpgradeItems(List<ItemStack> upgradeItems) {
        this.upgradeItems.clear();
        this.upgradeItems.addAll(upgradeItems);
    }

    public <T extends IUpgradeClientData> void putUpgradeData(UpgradeClientDataType<T> upgradeClientDataType, T clientData) {
        this.upgradeData.put(upgradeClientDataType, clientData);
    }

    public void removeUpgradeData(UpgradeClientDataType<?> type) {
        this.upgradeData.remove(type);
    }

    public void removeAllUpgradeData() {
        this.upgradeData.clear();
    }

    public void clearTanks() {
        this.tanks.clear();
    }

    public void clearBattery() {
        this.battery = Optional.empty();
    }

    public void setBattery(@Nullable BatteryRenderData data) {
        this.battery = Optional.ofNullable(data);
    }

    public List<ItemStack> upgradeItems() {
        return this.upgradeItems;
    }

    public Map<UpgradeClientDataType<?>, IUpgradeClientData> upgradeData() {
        return this.upgradeData;
    }

    public Map<TankPosition, TankRenderData> tanks() {
        return this.tanks;
    }

    public Optional<BatteryRenderData> battery() {
        return this.battery;
    }

    public DisplayData display() {
        return this.display;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RenderData that = (RenderData)obj;
        return Objects.equals(this.upgradeItems, that.upgradeItems) && Objects.equals(this.upgradeData, that.upgradeData) && Objects.equals(this.tanks, that.tanks) && Objects.equals(this.battery, that.battery) && Objects.equals(this.display, that.display);
    }

    public int hashCode() {
        return Objects.hash(this.upgradeItems, this.upgradeData, this.tanks, this.battery, this.display);
    }

    public String toString() {
        return "RenderData[upgradeItems=" + String.valueOf(this.upgradeItems) + ", upgradeData=" + String.valueOf(this.upgradeData) + ", tanks=" + String.valueOf(this.tanks) + ", battery=" + String.valueOf(this.battery) + ", display=" + String.valueOf(this.display) + "]";
    }

    public void setTank(TankPosition tankPosition, TankRenderData data) {
        this.tanks.put(tankPosition, data);
    }

    public RenderData copy() {
        return new RenderData(this.upgradeItems.stream().map(ItemStack::copy).collect(Collectors.toCollection(ArrayList::new)), this.upgradeData.entrySet().stream().map(e -> Map.entry((UpgradeClientDataType)e.getKey(), ((IUpgradeClientData)e.getValue()).copy())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((IUpgradeClientData)e.getValue()).copy(), (a, b) -> b, HashMap::new)), this.tanks.entrySet().stream().map(e -> Map.entry((TankPosition)((Object)((Object)e.getKey())), ((TankRenderData)e.getValue()).copy())).collect(Collectors.toMap(Map.Entry::getKey, e -> ((TankRenderData)e.getValue()).copy(), (a, b) -> b, HashMap::new)), this.battery.map(BatteryRenderData::copy), this.display.copy());
    }

    static {
        RenderData.register(CookingUpgradeClientData.TYPE);
        RenderData.register(JukeboxUpgradeClientData.TYPE);
        CODEC = Codec.withAlternative((Codec)RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.OPTIONAL_CODEC.listOf().xmap(CodecHelper::toMutable, Function.identity()).fieldOf("upgradeItems").forGetter(RenderData::upgradeItems), (App)Codec.dispatchedMap((Codec)Codec.STRING.xmap(CLIENT_DATA_TYPES::get, UpgradeClientDataType::getName), UpgradeClientDataType::codec).xmap(CodecHelper::toMutable, Function.identity()).fieldOf("upgradeData").forGetter(RenderData::upgradeData), (App)Codec.unboundedMap(TankPosition.CODEC, TankRenderData.CODEC).fieldOf("tanks").xmap(CodecHelper::toMutable, Function.identity()).forGetter(RenderData::tanks), (App)BatteryRenderData.CODEC.optionalFieldOf("battery").forGetter(RenderData::battery), (App)DisplayData.CODEC.fieldOf("display").forGetter(RenderData::display)).apply((Applicative)inst, RenderData::new)), (Codec)CompoundTag.CODEC, LegacyDeserialization::legacyDeserialize);
        STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), RenderData::upgradeItems, StreamCodecHelper.ofMap(ByteBufCodecs.STRING_UTF8.map(CLIENT_DATA_TYPES::get, UpgradeClientDataType::getName), type -> new StreamCodec<RegistryFriendlyByteBuf, IUpgradeClientData>(){

            public IUpgradeClientData decode(RegistryFriendlyByteBuf buf) {
                return (IUpgradeClientData)type.streamCodec().decode((Object)buf);
            }

            public void encode(RegistryFriendlyByteBuf buf, IUpgradeClientData value) {
                UpgradeClientDataType typed = type;
                IUpgradeClientData casted = (IUpgradeClientData)typed.cast(value).orElseThrow();
                typed.streamCodec().encode((Object)buf, (Object)casted);
            }
        }, HashMap::new), RenderData::upgradeData, StreamCodecHelper.ofMap(TankPosition.STREAM_CODEC, TankRenderData.STREAM_CODEC, HashMap::new), RenderData::tanks, (StreamCodec)ByteBufCodecs.optional(BatteryRenderData.STREAM_CODEC), RenderData::battery, DisplayData.STREAM_CODEC, RenderData::display, RenderData::new);
    }

    public record DisplayData(List<DisplayItemData> displayItems, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
        public static final Codec<DisplayData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DisplayItemData.CODEC.listOf().xmap(CodecHelper::toMutable, Function.identity()).fieldOf("displayItems").forGetter(DisplayData::displayItems), (App)Codec.INT.listOf().xmap(CodecHelper::toMutable, Function.identity()).fieldOf("inaccessibleSlots").forGetter(DisplayData::inaccessibleSlots), (App)Codec.INT.listOf().xmap(CodecHelper::toMutable, Function.identity()).fieldOf("infiniteSlots").forGetter(DisplayData::infiniteSlots), (App)Codec.INT.listOf().xmap(CodecHelper::toMutable, Function.identity()).fieldOf("slotCounts").forGetter(DisplayData::slotCounts), (App)Codec.FLOAT.listOf().xmap(CodecHelper::toMutable, Function.identity()).fieldOf("slotFillRatios").forGetter(DisplayData::slotFillRatios)).apply((Applicative)inst, DisplayData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DisplayData> STREAM_CODEC = StreamCodec.composite((StreamCodec)DisplayItemData.STREAM_CODEC.apply(ByteBufCodecs.list()), DisplayData::displayItems, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), DisplayData::inaccessibleSlots, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), DisplayData::infiniteSlots, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), DisplayData::slotCounts, (StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs.list()), DisplayData::slotFillRatios, DisplayData::new);

        public DisplayData() {
            this(new ArrayList<DisplayItemData>(), new ArrayList<Integer>(), new ArrayList<Integer>(), new ArrayList<Integer>(), new ArrayList<Float>());
        }

        public void refreshData(List<DisplayItemData> displayItems, List<Integer> inaccessibleSlots, List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
            this.displayItems.clear();
            this.displayItems.addAll(displayItems);
            this.inaccessibleSlots.clear();
            this.inaccessibleSlots.addAll(inaccessibleSlots);
            this.infiniteSlots.clear();
            this.infiniteSlots.addAll(infiniteSlots);
            this.slotCounts.clear();
            this.slotCounts.addAll(slotCounts);
            this.slotFillRatios.clear();
            this.slotFillRatios.addAll(slotFillRatios);
        }

        public DisplayData copy() {
            return new DisplayData(this.displayItems.stream().map(DisplayItemData::copy).collect(Collectors.toCollection(ArrayList::new)), new ArrayList<Integer>(this.inaccessibleSlots), new ArrayList<Integer>(this.infiniteSlots), new ArrayList<Integer>(this.slotCounts), new ArrayList<Float>(this.slotFillRatios));
        }

        public void refreshDisplayItemsAndInaccessibleSlots(List<DisplayItemData> displayItems, List<Integer> inaccessibleSlots) {
            this.displayItems.clear();
            this.displayItems.addAll(displayItems);
            this.inaccessibleSlots.clear();
            this.inaccessibleSlots.addAll(inaccessibleSlots);
        }

        public void refreshSlotCountsFillRatiosAndInfiniteSlots(List<Integer> infiniteSlots, List<Integer> slotCounts, List<Float> slotFillRatios) {
            this.infiniteSlots.clear();
            this.infiniteSlots.addAll(infiniteSlots);
            this.slotCounts.clear();
            this.slotCounts.addAll(slotCounts);
            this.slotFillRatios.clear();
            this.slotFillRatios.addAll(slotFillRatios);
        }
    }

    public record TankRenderData(FluidStack fluidStack, float fillRatio) {
        public static final Codec<TankRenderData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)FluidStack.CODEC.optionalFieldOf("fluid", (Object)FluidStack.EMPTY).forGetter(TankRenderData::fluidStack), (App)Codec.FLOAT.fieldOf("fillRatio").forGetter(TankRenderData::fillRatio)).apply((Applicative)inst, TankRenderData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TankRenderData> STREAM_CODEC = StreamCodec.composite((StreamCodec)FluidStack.OPTIONAL_STREAM_CODEC, TankRenderData::fluidStack, (StreamCodec)ByteBufCodecs.FLOAT, TankRenderData::fillRatio, TankRenderData::new);

        public TankRenderData(FluidStack fluidStack, float fillRatio) {
            this.fluidStack = fluidStack;
            this.fillRatio = Math.max(0.0f, Math.min(1.0f, fillRatio));
        }

        public TankRenderData copy() {
            return new TankRenderData(this.fluidStack.copy(), this.fillRatio);
        }

        public Optional<FluidStack> getFluid() {
            return this.fluidStack.isEmpty() ? Optional.empty() : Optional.of(this.fluidStack);
        }
    }

    public record BatteryRenderData(float chargeRatio) {
        public static final Codec<BatteryRenderData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chargeRatio").forGetter(BatteryRenderData::chargeRatio)).apply((Applicative)inst, BatteryRenderData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BatteryRenderData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, BatteryRenderData::chargeRatio, BatteryRenderData::new);

        public BatteryRenderData copy() {
            return new BatteryRenderData(this.chargeRatio);
        }
    }

    private static class LegacyDeserialization {
        private static final String TANKS_TAG = "tanks";
        private static final String BATTERY_TAG = "battery";
        private static final String TANK_POSITION_TAG = "position";
        private static final String TANK_INFO_TAG = "info";
        private static final String ITEM_DISPLAY_TAG = "itemDisplay";
        private static final String UPGRADES_TAG = "upgrades";
        private static final String UPGRADE_ITEMS_TAG = "upgradeItems";
        private static final Map<UpgradeClientDataType<?>, Function<CompoundTag, IUpgradeClientData>> LEGACY_CLIENT_DATA_TYPES = Map.of(CookingUpgradeClientData.TYPE, nbt -> new CookingUpgradeClientData(nbt.getBooleanOr("burning", false)), JukeboxUpgradeClientData.TYPE, nbt -> new JukeboxUpgradeClientData(nbt.getBooleanOr("playing", false)));
        private static final String CHARGE_RATIO_TAG = "chargeRatio";
        private static final String ITEMS_TAG = "items";
        private static final String INACCESSIBLE_SLOTS_TAG = "inaccessibleSlots";
        private static final String INFINITE_SLOTS_TAG = "infiniteSlots";
        public static final String SLOT_COUNTS_TAG = "slotCounts";
        public static final String SLOT_FILL_RATIOS_TAG = "slotFillRatios";
        private static final String FLUID_TAG = "fluid";
        private static final String FILL_RATIO_TAG = "fillRatio";
        private static final String ITEM_TAG = "item";
        private static final String ROTATION_TAG = "rotation";
        private static final String SLOT_INDEX_TAG = "slotIndex";
        private static final String DISPLAY_SIDE_TAG = "displaySide";

        private LegacyDeserialization() {
        }

        private static RenderData legacyDeserialize(CompoundTag renderInfoTag) {
            DisplayData itemDisplayData = LegacyDeserialization.legacyDeserializeItemDisplay(renderInfoTag.getCompoundOrEmpty(ITEM_DISPLAY_TAG));
            ListTag upgradeItemsTag = renderInfoTag.getListOrEmpty(UPGRADE_ITEMS_TAG);
            ArrayList<ItemStack> upgradeItems = new ArrayList<ItemStack>();
            RegistryHelper.getRegistryAccess().ifPresent(registryAccess -> {
                for (int i = 0; i < upgradeItemsTag.size(); ++i) {
                    upgradeItems.add(NBTHelper.deserializeStackFromTag((Tag)upgradeItemsTag.getCompoundOrEmpty(i)).orElse(ItemStack.EMPTY));
                }
            });
            CompoundTag upgrades = renderInfoTag.getCompoundOrEmpty(UPGRADES_TAG);
            HashMap clientData = new HashMap();
            upgrades.keySet().forEach(key -> LEGACY_CLIENT_DATA_TYPES.entrySet().stream().filter(entry -> ((UpgradeClientDataType)entry.getKey()).getName().equals(key)).findFirst().ifPresent(entry -> {
                IUpgradeClientData data = (IUpgradeClientData)((Function)entry.getValue()).apply(upgrades.getCompoundOrEmpty(key));
                clientData.put((UpgradeClientDataType)entry.getKey(), data);
            }));
            Map<TankPosition, TankRenderData> tanks = LegacyDeserialization.legacyDeserializeTanks(renderInfoTag);
            Optional<BatteryRenderData> battery = NBTHelper.getCompound(renderInfoTag, BATTERY_TAG).map(tag -> new BatteryRenderData(tag.getFloatOr(CHARGE_RATIO_TAG, 0.0f)));
            return new RenderData(upgradeItems, clientData, tanks, battery, itemDisplayData);
        }

        private static Map<TankPosition, TankRenderData> legacyDeserializeTanks(CompoundTag renderInfoTag) {
            HashMap<TankPosition, TankRenderData> tankData = new HashMap<TankPosition, TankRenderData>();
            ListTag tanks = renderInfoTag.getListOrEmpty(TANKS_TAG);
            for (int i = 0; i < tanks.size(); ++i) {
                CompoundTag tank = tanks.getCompoundOrEmpty(i);
                tankData.put(tank.getString(TANK_POSITION_TAG).map(s -> TankPosition.valueOf(s.toUpperCase(Locale.ROOT))).orElse(TankPosition.LEFT), LegacyDeserialization.legacyDeserializeTank(tank.getCompoundOrEmpty(TANK_INFO_TAG)));
            }
            return tankData;
        }

        public static TankRenderData legacyDeserializeTank(CompoundTag tag) {
            FluidStack fluidStack;
            if (tag.contains(FLUID_TAG) && !(fluidStack = NBTHelper.deserializeFluidFromTag((Tag)tag.getCompoundOrEmpty(FLUID_TAG)).orElse(FluidStack.EMPTY)).isEmpty()) {
                return new TankRenderData(fluidStack, tag.getFloatOr(FILL_RATIO_TAG, 0.0f));
            }
            return new TankRenderData(FluidStack.EMPTY, tag.getFloatOr(FILL_RATIO_TAG, 0.0f));
        }

        public static DisplayData legacyDeserializeItemDisplay(CompoundTag tag) {
            List<Integer> inaccessibleSlots = tag.getIntArray(INACCESSIBLE_SLOTS_TAG).map(array -> Arrays.stream(array).boxed().collect(Collectors.toCollection(ArrayList::new))).orElse(Collections.emptyList());
            List<Integer> infiniteSlots = tag.getIntArray(INFINITE_SLOTS_TAG).map(array -> Arrays.stream(array).boxed().collect(Collectors.toCollection(ArrayList::new))).orElse(Collections.emptyList());
            List<Integer> slotCounts = tag.getIntArray(SLOT_COUNTS_TAG).map(array -> Arrays.stream(array).boxed().collect(Collectors.toCollection(ArrayList::new))).orElse(Collections.emptyList());
            List slotFillRatios = NBTHelper.getCollection(tag, SLOT_FILL_RATIOS_TAG, Tag::asFloat, ArrayList::new).orElseGet(ArrayList::new);
            if (tag.contains(ITEM_TAG)) {
                return new DisplayData(List.of(LegacyDeserialization.legacyDeserializeDisplayItem(tag)), inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
            }
            if (tag.contains(ITEMS_TAG)) {
                List items = NBTHelper.getCollection(tag, ITEMS_TAG, stackTag -> Optional.of(LegacyDeserialization.legacyDeserializeDisplayItem((CompoundTag)stackTag)), ArrayList::new).orElseGet(ArrayList::new);
                return new DisplayData(items, inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
            }
            return new DisplayData(Collections.emptyList(), inaccessibleSlots, infiniteSlots, slotCounts, slotFillRatios);
        }

        private static DisplayItemData legacyDeserializeDisplayItem(CompoundTag tag) {
            return new DisplayItemData(tag.getCompound(ITEM_TAG).flatMap(NBTHelper::deserializeStackFromTag).orElse(ItemStack.EMPTY), tag.getIntOr(ROTATION_TAG, 0), tag.getIntOr(SLOT_INDEX_TAG, 0), tag.getString(DISPLAY_SIDE_TAG).map(DisplaySide::fromName).orElse(DisplaySide.FRONT));
        }
    }

    public record DisplayItemData(ItemStack item, int rotation, int slotIndex, DisplaySide displaySide) {
        public static final Codec<DisplayItemData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("item").forGetter(DisplayItemData::item), (App)Codec.INT.fieldOf("rotation").forGetter(DisplayItemData::rotation), (App)Codec.INT.fieldOf("slotIndex").forGetter(DisplayItemData::slotIndex), (App)DisplaySide.CODEC.fieldOf("displaySide").forGetter(DisplayItemData::displaySide)).apply((Applicative)instance, DisplayItemData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DisplayItemData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, DisplayItemData::item, (StreamCodec)ByteBufCodecs.VAR_INT, DisplayItemData::rotation, (StreamCodec)ByteBufCodecs.VAR_INT, DisplayItemData::slotIndex, DisplaySide.STREAM_CODEC, DisplayItemData::displaySide, DisplayItemData::new);

        public DisplayItemData copy() {
            return new DisplayItemData(this.item.copy(), this.rotation, this.slotIndex, this.displaySide);
        }
    }
}

