/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;

public class SettingsTemplateStorage
extends SavedData {
    private static final SavedDataType<SettingsTemplateStorage> TYPE = new SavedDataType("sophisticatedcore_settings_templates", SettingsTemplateStorage::new, RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap(CodecHelper.STRING_ENCODED_UUID, (Codec)Codec.unboundedMap((Codec)ExtraCodecs.POSITIVE_INT, ContainerContents.SettingsData.CODEC)).fieldOf("playerTemplates").forGetter(storage -> storage.playerTemplates), (App)Codec.unboundedMap(CodecHelper.STRING_ENCODED_UUID, (Codec)Codec.unboundedMap((Codec)ExtraCodecs.NON_EMPTY_STRING, ContainerContents.SettingsData.CODEC)).fieldOf("playerNamedTemplates").forGetter(storage -> storage.playerNamedTemplates)).apply((Applicative)builder, SettingsTemplateStorage::new)));
    private Map<UUID, Map<Integer, ContainerContents.SettingsData>> playerTemplates = new HashMap<UUID, Map<Integer, ContainerContents.SettingsData>>();
    private Map<UUID, Map<String, ContainerContents.SettingsData>> playerNamedTemplates = new HashMap<UUID, Map<String, ContainerContents.SettingsData>>();
    private static final SettingsTemplateStorage clientStorageCopy = new SettingsTemplateStorage();

    private SettingsTemplateStorage() {
    }

    private SettingsTemplateStorage(Map<UUID, Map<Integer, ContainerContents.SettingsData>> playerTemplates, Map<UUID, Map<String, ContainerContents.SettingsData>> playerNamedTemplates) {
        this.playerTemplates = playerTemplates;
        this.playerNamedTemplates = playerNamedTemplates;
    }

    public void putPlayerTemplate(Player player, int slot, ContainerContents.SettingsData data) {
        this.playerTemplates.computeIfAbsent(player.getUUID(), u -> new HashMap()).put(slot, data);
        this.setDirty();
    }

    public void putPlayerNamedTemplate(Player player, String name, ContainerContents.SettingsData data) {
        this.playerNamedTemplates.computeIfAbsent(player.getUUID(), u -> new TreeMap()).put(name, data);
        this.setDirty();
    }

    public Map<Integer, ContainerContents.SettingsData> getPlayerTemplates(Player player) {
        return this.playerTemplates.getOrDefault(player.getUUID(), new HashMap());
    }

    public Map<String, ContainerContents.SettingsData> getPlayerNamedTemplates(Player player) {
        return this.playerNamedTemplates.getOrDefault(player.getUUID(), new TreeMap());
    }

    public static SettingsTemplateStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (SettingsTemplateStorage)storage.computeIfAbsent(TYPE);
        }
        return clientStorageCopy;
    }

    public void clearPlayerTemplates(Player player) {
        this.playerTemplates.remove(player.getUUID());
        this.playerNamedTemplates.remove(player.getUUID());
        this.setDirty();
    }
}

