/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.memory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.util.ItemResourceHelper;

public class MemorySettingsCategory
implements ISettingsCategory<MemorySettingsCategory, MemorySettingsCategoryData> {
    public static final String NAME = "memory";
    private final Supplier<InventoryHandler> inventoryHandlerSupplier;
    private MemorySettingsCategoryData data;
    private final Runnable save;
    private final Map<Item, Set<Integer>> filterItemSlots = new HashMap<Item, Set<Integer>>();
    private final Map<Integer, Set<Integer>> filterStackSlots = new HashMap<Integer, Set<Integer>>();
    private Consumer<Item> onItemAdded = i -> {};
    private Consumer<Integer> onStackAdded = i -> {};
    private Consumer<Item> onItemRemoved = i -> {};
    private Consumer<Integer> onStackRemoved = i -> {};

    public MemorySettingsCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, MemorySettingsCategoryData data, Runnable save) {
        this.inventoryHandlerSupplier = inventoryHandlerSupplier;
        this.data = data;
        this.save = save;
        this.initItemAndStackSlots();
    }

    private void initItemAndStackSlots() {
        this.data.slotFilterItems().forEach(this::addFilterItemSlot);
        this.data.slotFilterStacks().forEach(this::addFilterStackSlot);
    }

    public boolean matchesFilter(int slotNumber, ItemStack stack) {
        if (this.data.slotFilterItems().containsKey(slotNumber)) {
            return !stack.isEmpty() && stack.getItem() == this.data.slotFilterItems().get(slotNumber);
        }
        if (this.data.slotFilterStacks().containsKey(slotNumber)) {
            return !stack.isEmpty() && this.data.slotFilterStacks().get(slotNumber).matches(stack);
        }
        return true;
    }

    public boolean matchesFilter(int slotNumber, ItemResource resource) {
        if (this.data.slotFilterItems().containsKey(slotNumber)) {
            return resource.getItem() == this.data.slotFilterItems().get(slotNumber);
        }
        if (this.data.slotFilterStacks().containsKey(slotNumber)) {
            return resource.matches(this.data.slotFilterStacks().get(slotNumber).stack());
        }
        return true;
    }

    public Optional<ItemStack> getSlotFilterStack(int slotNumber, boolean copy) {
        if (this.data.slotFilterItems().containsKey(slotNumber)) {
            return Optional.of(new ItemStack((ItemLike)this.data.slotFilterItems().get(slotNumber)));
        }
        if (this.data.slotFilterStacks().containsKey(slotNumber)) {
            ItemStack filterStack = this.data.slotFilterStacks().get(slotNumber).stack();
            return Optional.of(copy ? filterStack.copy() : filterStack);
        }
        return Optional.empty();
    }

    public boolean isSlotSelected(int slotNumber) {
        return this.data.slotFilterItems().containsKey(slotNumber) || this.data.slotFilterStacks().containsKey(slotNumber);
    }

    public void unselectAllSlots() {
        this.unselectAllFilterItemSlots();
        this.unselectAllFilteStackSlots();
        this.save();
    }

    private void save() {
        this.save.run();
    }

    private void unselectAllFilteStackSlots() {
        this.filterStackSlots.keySet().forEach(i -> this.onStackRemoved.accept((Integer)i));
        this.data.clearSlotFilterStacks();
        this.filterStackSlots.clear();
    }

    private void unselectAllFilterItemSlots() {
        this.filterItemSlots.keySet().forEach(i -> this.onItemRemoved.accept((Item)i));
        this.data.clearSlotFilterItems();
        this.filterItemSlots.clear();
    }

    public void selectSlots(int minSlot, int maxSlot) {
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            InventoryHandler inventoryHandler = this.getInventoryHandler();
            if (slot >= inventoryHandler.size()) continue;
            ItemStack stackInSlot = inventoryHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty()) {
                if (this.data.ignoreNbt()) {
                    Item item = stackInSlot.getItem();
                    this.addSlotItem(slot, item);
                    continue;
                }
                this.addSlotStack(slot, stackInSlot);
                continue;
            }
            Item filterItem = inventoryHandler.getFilterItem(slot);
            if (filterItem == Items.AIR) continue;
            if (this.data.ignoreNbt()) {
                this.addSlotItem(slot, filterItem);
                continue;
            }
            this.addSlotStack(slot, new ItemStack((ItemLike)filterItem));
        }
        this.save();
    }

    private InventoryHandler getInventoryHandler() {
        return this.inventoryHandlerSupplier.get();
    }

    private void addSlotItem(int slot, Item item) {
        this.data.slotFilterItems().put(slot, item);
        this.addFilterItemSlot(slot, item);
    }

    private void addFilterItemSlot(int slot, Item item) {
        this.filterItemSlots.computeIfAbsent(item, k -> {
            this.onItemAdded.accept((Item)k);
            return new TreeSet();
        }).add(slot);
    }

    private void addSlotStack(int slot, ItemStack stack) {
        ItemStackKey stackKey = ItemStackKey.of(stack);
        this.data.addSlotStack(slot, stackKey);
        this.addFilterStackSlot(slot, stackKey);
    }

    private void addFilterStackSlot(int slot, ItemStackKey stackKey) {
        int stackHash = stackKey.hashCode();
        this.filterStackSlots.computeIfAbsent(stackHash, k -> {
            this.onStackAdded.accept(stackHash);
            return new TreeSet();
        }).add(slot);
    }

    public void selectSlot(int slotNumber) {
        this.selectSlots(slotNumber, slotNumber + 1);
    }

    public void unselectSlot(int slotNumber) {
        this.unselectFilterItemSlot(slotNumber);
        this.unselectFilterStackSlot(slotNumber);
        this.save();
    }

    private void unselectFilterItemSlot(int slotNumber) {
        if (!this.data.slotFilterItems().containsKey(slotNumber)) {
            return;
        }
        Item item = this.data.slotFilterItems().remove(slotNumber);
        Set<Integer> itemSlots = this.filterItemSlots.get(item);
        itemSlots.remove(slotNumber);
        if (itemSlots.isEmpty()) {
            this.filterItemSlots.remove(item);
            this.onItemRemoved.accept(item);
        }
    }

    private void unselectFilterStackSlot(int slotNumber) {
        if (!this.data.slotFilterStacks().containsKey(slotNumber)) {
            return;
        }
        ItemStackKey isk = this.data.slotFilterStacks().remove(slotNumber);
        int stackHash = isk.hashCode();
        Set<Integer> stackSlots = this.filterStackSlots.get(stackHash);
        stackSlots.remove(slotNumber);
        if (stackSlots.isEmpty()) {
            this.filterStackSlots.remove(stackHash);
            this.onStackRemoved.accept(stackHash);
        }
    }

    public boolean ignoresNbt() {
        return this.data.ignoreNbt();
    }

    public void setIgnoreNbt(boolean ignoreNbt) {
        if (this.data.ignoreNbt() == ignoreNbt) {
            return;
        }
        Set<Integer> slotIndexes = this.getSlotIndexes();
        if (this.data.ignoreNbt() && !ignoreNbt) {
            this.data.slotFilterItems().forEach((slot, item) -> {
                ItemStack stack = this.inventoryHandlerSupplier.get().getStackInSlot((int)slot);
                if (stack.isEmpty()) {
                    stack = new ItemStack((ItemLike)item);
                }
                this.addSlotStack((int)slot, stack);
            });
            this.unselectAllFilterItemSlots();
        } else {
            this.data.slotFilterStacks().forEach((slot, isk) -> this.addSlotItem((int)slot, isk.stack().getItem()));
            this.unselectAllFilteStackSlots();
        }
        this.data.setIgnoreNbt(ignoreNbt);
        this.save();
        slotIndexes.forEach(this::selectSlot);
    }

    @Override
    public void reloadFrom(MemorySettingsCategoryData data) {
        this.data = data;
    }

    @Override
    public void overwriteWith(MemorySettingsCategory otherCategory) {
        this.unselectAllSlots();
        this.data.setIgnoreNbt(otherCategory.ignoresNbt());
        if (this.data.ignoreNbt()) {
            this.overwriteFilterItems(otherCategory);
        } else {
            this.overwriteFilterStacks(otherCategory);
        }
        this.save();
    }

    private void overwriteFilterStacks(MemorySettingsCategory otherCategory) {
        InventoryHandler inventoryHandler = this.getInventoryHandler();
        otherCategory.data.slotFilterStacks().forEach((slot, isk) -> {
            if (slot >= inventoryHandler.size()) {
                return;
            }
            ItemStack stackInSlot = inventoryHandler.getStackInSlot((int)slot);
            if (stackInSlot.isEmpty() || otherCategory.matchesFilter((int)slot, stackInSlot)) {
                this.addSlotStack((int)slot, isk.stack());
            }
        });
    }

    private void overwriteFilterItems(MemorySettingsCategory otherCategory) {
        InventoryHandler inventoryHandler = this.getInventoryHandler();
        otherCategory.data.slotFilterItems().forEach((slot, item) -> {
            if (slot >= inventoryHandler.size()) {
                return;
            }
            ItemStack stackInSlot = inventoryHandler.getStackInSlot((int)slot);
            if (stackInSlot.isEmpty() || otherCategory.matchesFilter((int)slot, stackInSlot)) {
                this.addSlotItem((int)slot, (Item)item);
            }
        });
    }

    public Set<Integer> getSlotIndexes() {
        HashSet<Integer> slots = new HashSet<Integer>(this.data.slotFilterItems().keySet());
        slots.addAll(this.data.slotFilterStacks().keySet());
        return slots;
    }

    public Map<Item, Set<Integer>> getFilterItemSlots() {
        return this.filterItemSlots;
    }

    public Map<Integer, Set<Integer>> getFilterStackSlots() {
        return this.filterStackSlots;
    }

    public boolean matchesFilter(ItemStack stack) {
        return this.matchesFilter(stack.getItem(), ItemStack.hashItemAndComponents((ItemStack)stack));
    }

    private boolean matchesFilter(Item item, int componentHash) {
        return this.filterItemSlots.containsKey(item) || !this.filterStackSlots.isEmpty() && this.filterStackSlots.containsKey(componentHash);
    }

    public boolean matchesFilter(ItemResource resource) {
        return this.matchesFilter(resource.getItem(), ItemResourceHelper.hashItemAndComponents(resource));
    }

    public boolean matchesFilter(Item item, DataComponentMap components) {
        if (this.filterItemSlots.containsKey(item)) {
            return true;
        }
        int hash = 31 + item.hashCode();
        hash = 31 * hash + components.hashCode();
        return this.filterStackSlots.containsKey(hash);
    }

    public void registerListeners(Consumer<Item> onItemAdded, Consumer<Item> onItemRemoved, Consumer<Integer> onStackAdded, Consumer<Integer> onStackRemoved) {
        this.onItemAdded = onItemAdded;
        this.onItemRemoved = onItemRemoved;
        this.onStackAdded = onStackAdded;
        this.onStackRemoved = onStackRemoved;
    }

    public void unregisterListeners() {
        this.onItemAdded = i -> {};
        this.onItemRemoved = i -> {};
        this.onStackAdded = i -> {};
        this.onStackRemoved = i -> {};
    }

    public void setFilter(int slot, ItemStack filter) {
        ItemStack stackInSlot;
        InventoryHandler inventoryHandler = this.getInventoryHandler();
        if (slot < inventoryHandler.size() && (stackInSlot = inventoryHandler.getStackInSlot(slot)).isEmpty()) {
            if (this.data.ignoreNbt()) {
                Item item = filter.getItem();
                this.addSlotItem(slot, item);
            } else {
                this.addSlotStack(slot, filter);
            }
        }
        this.save();
    }

    @Override
    public boolean isLargerThanNumberOfSlots(int slots) {
        return this.data.slotFilterItems().keySet().stream().anyMatch(slotIndex -> slotIndex >= slots) || this.data.slotFilterStacks().keySet().stream().anyMatch(slotIndex -> slotIndex >= slots);
    }

    @Override
    public void copyTo(MemorySettingsCategory otherCategory, int startFromSlot, int slotOffset) {
        this.data.slotFilterItems().forEach((slotIndex, item) -> {
            if (slotIndex < startFromSlot) {
                return;
            }
            otherCategory.data.slotFilterItems().put(slotIndex + slotOffset, (Item)item);
        });
        this.data.slotFilterStacks().forEach((slotIndex, isk) -> {
            if (slotIndex < startFromSlot) {
                return;
            }
            otherCategory.data.slotFilterStacks().put(slotIndex + slotOffset, (ItemStackKey)isk);
        });
        otherCategory.save();
    }

    @Override
    public void deleteSlotSettingsFrom(int slotIndex) {
        this.data.removeFilterItemSlot(slotIndex);
        this.data.removeFilterStackSlot(slotIndex);
        this.save();
    }
}

