/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;

public class MemorySettingsCategoryData
implements ContainerContents.ISettingsCategoryData<MemorySettingsCategoryData> {
    public static final Codec<MemorySettingsCategoryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(CodecHelper.STRING_ENCODED_INT, (Codec)Item.CODEC.xmap(Holder::value, Item::builtInRegistryHolder)).fieldOf("slotFilterItems").forGetter(MemorySettingsCategoryData::slotFilterItems), (App)Codec.unboundedMap(CodecHelper.STRING_ENCODED_INT, (Codec)ItemStack.CODEC.xmap(ItemStackKey::of, ItemStackKey::stack)).fieldOf("slotFilterStacks").forGetter(MemorySettingsCategoryData::slotFilterStacks), (App)Codec.BOOL.fieldOf("ignoreNbt").forGetter(MemorySettingsCategoryData::ignoreNbt)).apply((Applicative)instance, MemorySettingsCategoryData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MemorySettingsCategoryData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.VAR_INT, (StreamCodec)Item.STREAM_CODEC.map(Holder::value, Item::builtInRegistryHolder)), MemorySettingsCategoryData::slotFilterItems, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.VAR_INT, (StreamCodec)ItemStack.STREAM_CODEC.map(ItemStackKey::of, ItemStackKey::stack)), MemorySettingsCategoryData::slotFilterStacks, (StreamCodec)ByteBufCodecs.BOOL, MemorySettingsCategoryData::ignoreNbt, MemorySettingsCategoryData::new);
    private Map<Integer, Item> slotFilterItems = new LinkedHashMap<Integer, Item>();
    private Map<Integer, ItemStackKey> slotFilterStacks = new LinkedHashMap<Integer, ItemStackKey>();
    private boolean ignoreNbt = true;

    public MemorySettingsCategoryData() {
    }

    public MemorySettingsCategoryData(Map<Integer, Item> slotFilterItems, Map<Integer, ItemStackKey> slotFilterStacks, boolean ignoreNbt) {
        this.slotFilterItems.putAll(slotFilterItems);
        this.slotFilterStacks.putAll(slotFilterStacks);
        this.ignoreNbt = ignoreNbt;
    }

    public Map<Integer, Item> slotFilterItems() {
        return this.slotFilterItems;
    }

    public Map<Integer, ItemStackKey> slotFilterStacks() {
        return this.slotFilterStacks;
    }

    public boolean ignoreNbt() {
        return this.ignoreNbt;
    }

    @Override
    public String id() {
        return "memory";
    }

    @Override
    public MemorySettingsCategoryData copy() {
        return new MemorySettingsCategoryData(new LinkedHashMap<Integer, Item>(this.slotFilterItems), new LinkedHashMap<Integer, ItemStackKey>(this.slotFilterStacks), this.ignoreNbt);
    }

    @Override
    public void reloadFrom(MemorySettingsCategoryData other) {
        this.ignoreNbt = other.ignoreNbt;
        this.slotFilterItems = new LinkedHashMap<Integer, Item>(other.slotFilterItems);
        this.slotFilterStacks = new LinkedHashMap<Integer, ItemStackKey>(other.slotFilterStacks);
    }

    public void addSlotStack(int slot, ItemStackKey stackKey) {
        this.slotFilterStacks.put(slot, stackKey);
    }

    public void clearSlotFilterStacks() {
        this.slotFilterStacks.clear();
    }

    public void clearSlotFilterItems() {
        this.slotFilterItems.clear();
    }

    public void setIgnoreNbt(boolean ignoreNbt) {
        this.ignoreNbt = ignoreNbt;
    }

    public void removeFilterItemSlot(int slotIndex) {
        this.slotFilterItems.entrySet().removeIf(e -> (Integer)e.getKey() >= slotIndex);
    }

    public void removeFilterStackSlot(int slotIndex) {
        this.slotFilterStacks.entrySet().removeIf(e -> (Integer)e.getKey() >= slotIndex);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MemorySettingsCategoryData)) {
            return false;
        }
        MemorySettingsCategoryData that = (MemorySettingsCategoryData)o;
        return this.ignoreNbt == that.ignoreNbt && Objects.equals(this.slotFilterItems, that.slotFilterItems) && Objects.equals(this.slotFilterStacks, that.slotFilterStacks);
    }

    public int hashCode() {
        return Objects.hash(this.slotFilterItems, this.slotFilterStacks, this.ignoreNbt);
    }
}

