/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.cooking;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoBlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoSmokingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeClientData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.IAutoCookingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;
import org.jspecify.annotations.Nullable;

public class AutoCookingUpgradeWrapper<W extends AutoCookingUpgradeWrapper<W, U, R>, U extends UpgradeItemBase<W>, R extends AbstractCookingRecipe>
extends UpgradeWrapperBase<W, U>
implements ITickableUpgrade,
ICookingUpgrade<R> {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    private static final int NO_INVENTORY_SPACE_COOLDOWN = 60;
    private final FilterLogic inputFilterLogic;
    private final FilterLogic fuelFilterLogic;
    private final CookingLogic<R> cookingLogic;
    private final Predicate<ItemStack> isValidInput;
    private final Predicate<ItemStack> isValidFuel;
    private final RecipeType<R> recipeType;
    private int outputCooldown = 0;
    private int fuelCooldown = 0;
    private int inputCooldown = 0;

    public AutoCookingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler, RecipeType<R> recipeType, ResourceKey<RecipePropertySet> acceptedInputs, float burnTimeModifier) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.recipeType = recipeType;
        RecipePropertySet validInput = RecipeHelper.getPropertySet(acceptedInputs);
        AutoCookingUpgradeConfig autoCookingUpgradeConfig = ((IAutoCookingUpgradeItem)((Object)this.upgradeItem)).getAutoCookingUpgradeConfig();
        this.inputFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)autoCookingUpgradeConfig.inputFilterSlots.get(), arg_0 -> ((RecipePropertySet)validInput).test(arg_0), ModCoreDataComponents.INPUT_FILTER_ATTRIBUTES);
        this.fuelFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)autoCookingUpgradeConfig.fuelFilterSlots.get(), s -> s.getBurnTime(recipeType, WorldHelper.getFuelValues()) > 0, ModCoreDataComponents.FUEL_FILTER_ATTRIBUTES);
        this.fuelFilterLogic.setAllowByDefault(true);
        this.fuelFilterLogic.setEmptyAllowListMatchesEverything();
        this.isValidInput = s -> validInput.test(s) && this.inputFilterLogic.matchesFilter((ItemStack)s);
        this.isValidFuel = s -> s.getBurnTime(recipeType, WorldHelper.getFuelValues()) > 0 && this.fuelFilterLogic.matchesFilter((ItemStack)s);
        this.cookingLogic = new CookingLogic<R>(upgrade, upgradeSaveHandler, this.isValidFuel, this.isValidInput, autoCookingUpgradeConfig, recipeType, burnTimeModifier);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.pauseAndRemoveRenderData();
        }
        super.setEnabled(enabled);
    }

    private void pauseAndRemoveRenderData() {
        this.cookingLogic.pause();
        RenderDataHandler renderDataHandler = this.storageWrapper.getRenderDataHandler();
        renderDataHandler.removeUpgradeClientData(CookingUpgradeClientData.TYPE);
    }

    @Override
    public void onBeforeRemoved() {
        this.pauseAndRemoveRenderData();
    }

    private void tryPushingOutput() {
        int inserted;
        if (this.outputCooldown > 0) {
            --this.outputCooldown;
            return;
        }
        ItemStack output = this.cookingLogic.getCookOutput();
        ITrackedContentsItemResourceHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        ItemResource resource = ItemResource.of((ItemStack)output);
        int n = inserted = output.isEmpty() ? 0 : InventoryHelper.insert(inventory, resource, output.getCount());
        if (inserted > 0) {
            InventoryHelper.extract((ResourceHandler<ItemResource>)this.cookingLogic.getCookingInventory(), resource, inserted);
            this.tryPushingXpToTanks();
        } else {
            this.outputCooldown = 60;
        }
        ItemStack fuel = this.cookingLogic.getFuel();
        if (!fuel.isEmpty() && fuel.getBurnTime(this.recipeType, WorldHelper.getFuelValues()) <= 0 && (inserted = InventoryHelper.insert(inventory, resource = ItemResource.of((ItemStack)fuel), fuel.getCount())) > 0) {
            InventoryHelper.extract((ResourceHandler<ItemResource>)this.cookingLogic.getCookingInventory(), 1, resource, inserted);
        }
    }

    private void tryPushingXpToTanks() {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            float storedExperience = this.cookingLogic.getStoredExperience();
            for (int i = 0; i < fluidHandler.size(); ++i) {
                FluidResource xpFluid = FluidResource.of((Fluid)((Fluid)ModFluids.XP_STILL.get()));
                try (Transaction tx = Transaction.openRoot();){
                    int filled = fluidHandler.insert((Resource)xpFluid, XpHelper.experienceToLiquid(storedExperience), (TransactionContext)tx);
                    if (filled <= 0) continue;
                    tx.commit();
                    this.cookingLogic.drainStoredExperience(XpHelper.liquidToExperience(filled));
                    storedExperience -= XpHelper.liquidToExperience(filled);
                    if (!(storedExperience <= 0.0f)) continue;
                    break;
                }
            }
        });
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level)) {
            return;
        }
        this.tryPushingOutput();
        this.tryPullingFuel();
        this.tryPullingInput();
        if (!this.cookingLogic.tick(level) && this.outputCooldown <= 0 && this.fuelCooldown <= 0 && this.inputCooldown <= 0) {
            this.setCooldown(level, 10);
        }
        boolean isBurning = this.cookingLogic.isBurning(level);
        RenderDataHandler renderDataHandler = this.storageWrapper.getRenderDataHandler();
        if (renderDataHandler.getUpgradeClientData(CookingUpgradeClientData.TYPE).map(CookingUpgradeClientData::burning).orElse(false) != isBurning) {
            if (isBurning) {
                renderDataHandler.setUpgradeClientData(CookingUpgradeClientData.TYPE, new CookingUpgradeClientData(true));
            } else {
                renderDataHandler.removeUpgradeClientData(CookingUpgradeClientData.TYPE);
            }
        }
    }

    private void tryPullingInput() {
        if (this.inputCooldown > 0) {
            --this.inputCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getCookInput(), this.cookingLogic::setCookInput, this.isValidInput)) {
            this.inputCooldown = 60;
        }
    }

    private void tryPullingFuel() {
        if (this.fuelCooldown > 0) {
            --this.fuelCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.cookingLogic.getFuel(), this.cookingLogic::setFuel, this.isValidFuel)) {
            this.fuelCooldown = 60;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryPullingGetUnsucessful(ItemStack stack, Consumer<ItemStack> setSlot, Predicate<ItemStack> isItemValid) {
        ItemStack toExtract;
        ITrackedContentsItemResourceHandler inventory = this.storageWrapper.getInventoryForUpgradeProcessing();
        if (stack.isEmpty()) {
            AtomicReference<ItemStack> ret = new AtomicReference<ItemStack>(ItemStack.EMPTY);
            InventoryHelper.iterate(inventory, (slot, st) -> {
                if (isItemValid.test((ItemStack)st)) {
                    ret.set(st.copy());
                }
            }, () -> !((ItemStack)ret.get()).isEmpty());
            if (ret.get().isEmpty()) return true;
            toExtract = ret.get();
            toExtract.setCount(toExtract.getMaxStackSize());
        } else {
            if (stack.getCount() == stack.getMaxStackSize() || !isItemValid.test(stack)) {
                return true;
            }
            toExtract = stack.copy();
            toExtract.setCount(stack.getMaxStackSize() - stack.getCount());
        }
        int extracted = InventoryHelper.extract(inventory, toExtract);
        if (extracted <= 0) {
            return true;
        }
        setSlot.accept(toExtract.copyWithCount(extracted + stack.getCount()));
        return false;
    }

    @Override
    public CookingLogic<R> getCookingLogic() {
        return this.cookingLogic;
    }

    public FilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public FilterLogic getFuelFilterLogic() {
        return this.fuelFilterLogic;
    }

    public static class AutoBlastingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoBlastingUpgradeWrapper, AutoBlastingUpgradeItem, BlastingRecipe> {
        public AutoBlastingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.BLASTING, (ResourceKey<RecipePropertySet>)RecipePropertySet.BLAST_FURNACE_INPUT, 0.5f);
        }
    }

    public static class AutoSmokingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmokingUpgradeWrapper, AutoSmokingUpgradeItem, SmokingRecipe> {
        public AutoSmokingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.SMOKING, (ResourceKey<RecipePropertySet>)RecipePropertySet.SMOKER_INPUT, 0.5f);
        }
    }

    public static class AutoSmeltingUpgradeWrapper
    extends AutoCookingUpgradeWrapper<AutoSmeltingUpgradeWrapper, AutoSmeltingUpgradeItem, SmeltingRecipe> {
        public AutoSmeltingUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler, RecipeType.SMELTING, (ResourceKey<RecipePropertySet>)RecipePropertySet.FURNACE_INPUT, 1.0f);
        }
    }
}

