/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.crafting;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import org.apache.commons.lang3.function.TriConsumer;

public class CraftingItemHandler
extends TransientCraftingContainer {
    private final Supplier<ResourceHandler<ItemResource>> supplyInventory;
    private final Consumer<Container> onCraftingMatrixChanged;
    private boolean itemsInitialized = false;
    private List<ItemStack> items = List.of();

    public CraftingItemHandler(Supplier<ResourceHandler<ItemResource>> supplyInventory, Consumer<Container> onCraftingMatrixChanged) {
        super(new AbstractContainerMenu(null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 3, 3);
        this.supplyInventory = supplyInventory;
        this.onCraftingMatrixChanged = onCraftingMatrixChanged;
    }

    public int getContainerSize() {
        return this.supplyInventory.get().size();
    }

    public boolean isEmpty() {
        return ResourceHandlerUtil.isEmpty(this.supplyInventory.get());
    }

    public ItemStack getItem(int index) {
        ResourceHandler<ItemResource> itemHandler = this.supplyInventory.get();
        return index >= itemHandler.size() ? ItemStack.EMPTY : ((ItemResource)itemHandler.getResource(index)).toStack(itemHandler.getAmountAsInt(index));
    }

    public List<ItemStack> getItems() {
        if (!this.itemsInitialized) {
            this.items = InventoryHelper.getStacks(this.supplyInventory.get());
            this.itemsInitialized = true;
        }
        return this.items;
    }

    public ItemStack removeItemNoUpdate(int index) {
        return InventoryHelper.getAndRemove(this.supplyInventory.get(), index);
    }

    public ItemStack removeItem(int index, int count) {
        ResourceHandler<ItemResource> inventory = this.supplyInventory.get();
        ItemResource resource = (ItemResource)inventory.getResource(index);
        int extracted = InventoryHelper.extract(this.supplyInventory.get(), index, resource, count);
        if (extracted > 0) {
            this.itemsInitialized = false;
            this.onCraftingMatrixChanged.accept((Container)this);
        }
        return resource.toStack(extracted);
    }

    public void setItem(int index, ItemStack stack) {
        InventoryHelper.set(this.supplyInventory.get(), index, ItemResource.of((ItemStack)stack), stack.getCount());
        this.onCraftingMatrixChanged.accept((Container)this);
        this.itemsInitialized = false;
    }

    public void setChanged() {
        super.setChanged();
        this.itemsInitialized = false;
    }

    public void fillStackedContents(StackedItemContents helper) {
        InventoryHelper.iterate(this.supplyInventory.get(), (TriConsumer<Integer, ItemResource, Integer>)((TriConsumer)(slot, resource, amount) -> helper.accountSimpleStack(resource.toStack(amount.intValue()))));
    }
}

