/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.voiding;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.ISlotChangeResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IInsertResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IOverflowResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ISlotLimitUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeItem;
import org.jspecify.annotations.Nullable;

public class VoidUpgradeWrapper
extends UpgradeWrapperBase<VoidUpgradeWrapper, VoidUpgradeItem>
implements IInsertResponseUpgrade,
IFilteredUpgrade,
ISlotChangeResponseUpgrade,
ITickableUpgrade,
IOverflowResponseUpgrade,
ISlotLimitUpgrade {
    private final FilterLogic filterLogic;
    private final Set<Integer> slotsToVoid = new HashSet<Integer>();
    private boolean shouldVoidOverflow;

    public VoidUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, ((VoidUpgradeItem)this.upgradeItem).getFilterSlotCount(), ModCoreDataComponents.FILTER_ATTRIBUTES);
        this.filterLogic.setAllowByDefault(true);
        this.setShouldVoidOverflowDefaultOrLoadFromNbt(false);
    }

    @Override
    public int onBeforeInsert(InventoryHandler inventoryHandler, int slot, ItemResource resource, int amount) {
        if (this.shouldVoidOverflow && inventoryHandler.getResource(slot).isEmpty() && (!this.filterLogic.shouldMatchComponents() || !this.filterLogic.shouldMatchDurability() || this.filterLogic.getPrimaryMatch() != PrimaryMatch.ITEM) && this.filterLogic.matchesFilter(resource)) {
            for (int s = 0; s < inventoryHandler.size(); ++s) {
                ItemResource filterResource;
                if (s == slot || !this.matchesFilter((filterResource = inventoryHandler.getResource(s)).getItem(), (Integer)filterResource.getOrDefault(DataComponents.DAMAGE, (Object)0), filterResource.isEmpty(), filterResource.getComponents(), resource.getItem(), (Integer)resource.getOrDefault(DataComponents.DAMAGE, (Object)0), resource.isEmpty(), resource.getComponents())) continue;
                return amount;
            }
            return 0;
        }
        return !this.shouldVoidOverflow && this.filterLogic.matchesFilter(resource) ? amount : 0;
    }

    @Override
    public void onAfterInsert(InventoryHandler inventoryHandler, int slot, TransactionContext tx) {
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public void setShouldWorkdInGUI(boolean shouldWorkdInGUI) {
        this.upgrade.set(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)shouldWorkdInGUI);
        this.save();
    }

    public boolean shouldWorkInGUI() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHOULD_WORK_IN_GUI, (Object)false);
    }

    public void setShouldVoidOverflow(boolean shouldVoidOverflow) {
        if (!shouldVoidOverflow && !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled()) {
            return;
        }
        this.shouldVoidOverflow = shouldVoidOverflow;
        this.upgrade.set(ModCoreDataComponents.SHOULD_VOID_OVERFLOW, (Object)shouldVoidOverflow);
        this.save();
    }

    public void setShouldVoidOverflowDefaultOrLoadFromNbt(boolean shouldVoidOverflowDefault) {
        this.shouldVoidOverflow = !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.SHOULD_VOID_OVERFLOW, (Object)shouldVoidOverflowDefault) != false;
    }

    @Override
    public boolean voidsOverflow() {
        return !((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled() || this.shouldVoidOverflow;
    }

    @Override
    public void onSlotChange(InventoryHandler inventoryHandler, int slot) {
        if (!this.shouldWorkInGUI() || this.voidsOverflow()) {
            return;
        }
        if (this.filterLogic.matchesFilter(inventoryHandler.getResource(slot))) {
            this.slotsToVoid.add(slot);
        }
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.slotsToVoid.isEmpty()) {
            return;
        }
        InventoryHandler storageInventory = this.storageWrapper.getInventoryHandler();
        try (Transaction tx = Transaction.openRoot();){
            for (int slot : this.slotsToVoid) {
                storageInventory.extract(slot, storageInventory.getResource(slot), storageInventory.getAmountAsInt(slot), (TransactionContext)tx);
            }
            tx.commit();
        }
        this.slotsToVoid.clear();
    }

    @Override
    public boolean worksInGui() {
        return this.shouldWorkInGUI();
    }

    @Override
    public ItemStack onOverflow(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack) ? ItemStack.EMPTY : stack;
    }

    @Override
    public int onOverflow(ItemResource resource, int amount) {
        return this.filterLogic.matchesFilter(resource) ? amount : 0;
    }

    @Override
    public boolean stackMatchesFilter(ItemStack stack) {
        return this.filterLogic.matchesFilter(stack);
    }

    @Override
    public boolean matchesFilter(ItemResource resource) {
        return this.filterLogic.matchesFilter(resource);
    }

    public boolean isVoidAnythingEnabled() {
        return ((VoidUpgradeItem)this.upgradeItem).isVoidAnythingEnabled();
    }

    @Override
    public int getSlotLimit() {
        return 64;
    }
}

