/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.xppump;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.AutomationDirection;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemResourceHelper;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;
import org.jspecify.annotations.Nullable;

public class XpPumpUpgradeWrapper
extends UpgradeWrapperBase<XpPumpUpgradeWrapper, XpPumpUpgradeItem>
implements ITickableUpgrade {
    private static final int DEFAULT_LEVEL = 10;
    private static final int COOLDOWN = 5;
    private static final int ALL_LEVELS = 10000;
    private static final int PLAYER_SEARCH_RANGE = 3;
    private final XpPumpUpgradeConfig xpPumpUpgradeConfig;

    protected XpPumpUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.xpPumpUpgradeConfig = ((XpPumpUpgradeItem)this.upgradeItem).getXpPumpUpgradeConfig();
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (this.isInCooldown(level)) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.interactWithPlayer(player);
            this.mendItems(player);
        } else {
            AABB searchBox = new AABB(pos).inflate(3.0);
            for (Player player : level.players()) {
                if (!searchBox.contains(player.getX(), player.getY(), player.getZ())) continue;
                this.interactWithPlayer(player);
                this.mendItems(player);
            }
        }
        this.setCooldown(level, 5);
    }

    private void mendItems(Player player) {
        if (!((Boolean)this.xpPumpUpgradeConfig.mendingOn.get()).booleanValue() || !this.shouldMendItems()) {
            return;
        }
        this.getRandomDamagedItemWithMending(player).ifPresent(itemInfo -> {
            float xpToTryDrain;
            ItemResource resource = (ItemResource)itemInfo.handler.getResource(itemInfo.slot);
            ItemStack itemStack = resource.toStack(itemInfo.handler.getAmountAsInt(itemInfo.slot));
            if (!itemStack.isEmpty() && itemStack.isDamaged() && itemStack.getXpRepairRatio() > 0.0f && (xpToTryDrain = Math.min((float)((Integer)this.xpPumpUpgradeConfig.maxXpPointsPerMending.get()).intValue(), (float)itemStack.getDamageValue() / itemStack.getXpRepairRatio())) > 0.0f) {
                this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
                    int extracted;
                    try (Transaction tx = Transaction.openRoot();){
                        extracted = fluidHandler.extract(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(xpToTryDrain), (TransactionContext)tx, false);
                        if (extracted == 0) {
                            return;
                        }
                        tx.commit();
                    }
                    float xpDrained = XpHelper.liquidToExperience(extracted);
                    int durabilityToRepair = (int)(xpDrained * itemStack.getXpRepairRatio());
                    itemStack.setDamageValue(itemStack.getDamageValue() - durabilityToRepair);
                    InventoryHelper.set(itemInfo.handler, itemInfo.slot, ItemResource.of((ItemStack)itemStack), itemStack.getCount());
                });
            }
        });
    }

    private Optional<DamagedItemInfo> getRandomDamagedItemWithMending(Player player) {
        ArrayList<DamagedItemInfo> matchingItems = new ArrayList<DamagedItemInfo>();
        List<ResourceHandler<ItemResource>> equipmentHandlers = InventoryHelper.getEquipmentItemHandlersFromPlayer(player);
        for (ResourceHandler<ItemResource> handler : equipmentHandlers) {
            for (int slot = 0; slot < handler.size(); ++slot) {
                ItemStack stack;
                ItemResource resource = (ItemResource)handler.getResource(slot);
                int amount = handler.getAmountAsInt(slot);
                if (!ItemResourceHelper.isDamageable(resource) || !(stack = resource.toStack(amount)).getItem().isDamaged(stack)) continue;
                ItemEnchantments enchantments = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
                for (Object2IntMap.Entry enchantmentEntry : enchantments.entrySet()) {
                    Holder enchantmentHolder = (Holder)enchantmentEntry.getKey();
                    Enchantment enchantment = (Enchantment)enchantmentHolder.value();
                    if (!enchantment.effects().has(EnchantmentEffectComponents.REPAIR_WITH_XP)) continue;
                    matchingItems.add(new DamagedItemInfo(handler, slot));
                }
            }
        }
        return Util.getRandomSafe(matchingItems, (RandomSource)player.getRandom());
    }

    private void interactWithPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> {
            int level = this.getLevel();
            AutomationDirection direction = this.getDirection();
            if (direction == AutomationDirection.OFF) {
                return;
            }
            if ((direction == AutomationDirection.INPUT || direction == AutomationDirection.KEEP) && (level < player.experienceLevel || level == player.experienceLevel && player.experienceProgress > 0.0f)) {
                this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, level, false);
            } else if ((direction == AutomationDirection.OUTPUT || direction == AutomationDirection.KEEP) && level > player.experienceLevel) {
                this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, level, false);
            }
        });
    }

    private void tryGivePlayerExperienceFromTank(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryGivePlayerExperienceFromTank(player, fluidHandler, stopAtLevel, true);
    }

    private void tryGivePlayerExperienceFromTank(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToGive = XpHelper.getExperienceForLevel(stopAtLevel) - XpHelper.getPlayerTotalExperience(player);
        try (Transaction tx = Transaction.openRoot();){
            int extracted = fluidHandler.extract(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToGive), (TransactionContext)tx, ignoreInOutLimit);
            if (extracted > 0) {
                tx.commit();
                player.giveExperiencePoints((int)XpHelper.liquidToExperience(extracted));
            }
        }
    }

    private void tryFillTankWithPlayerExperience(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel) {
        this.tryFillTankWithPlayerExperience(player, fluidHandler, stopAtLevel, true);
    }

    private void tryFillTankWithPlayerExperience(Player player, IStorageFluidHandler fluidHandler, int stopAtLevel, boolean ignoreInOutLimit) {
        int maxXpPointsToTake = XpHelper.getPlayerTotalExperience(player) - XpHelper.getExperienceForLevel(stopAtLevel);
        try (Transaction tx = Transaction.openRoot();){
            int filled = fluidHandler.insert(ModFluids.EXPERIENCE_TAG, XpHelper.experienceToLiquid(maxXpPointsToTake), (Fluid)ModFluids.XP_STILL.get(), (TransactionContext)tx, ignoreInOutLimit);
            if (filled > 0) {
                tx.commit();
                player.giveExperiencePoints((int)(-XpHelper.liquidToExperience(filled)));
            }
        }
    }

    public void takeLevelsFromPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, Math.max(player.experienceLevel - this.getLevelsToStore(), 0)));
    }

    public void takeAllExperienceFromPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryFillTankWithPlayerExperience(player, (IStorageFluidHandler)fluidHandler, 0));
    }

    public void giveLevelsToPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, player.experienceLevel + this.getLevelsToTake()));
    }

    public void giveAllExperienceToPlayer(Player player) {
        this.storageWrapper.getFluidHandler().ifPresent(fluidHandler -> this.tryGivePlayerExperienceFromTank(player, (IStorageFluidHandler)fluidHandler, 10000));
    }

    public AutomationDirection getDirection() {
        return (AutomationDirection)((Object)this.upgrade.getOrDefault(ModCoreDataComponents.AUTOMATION_DIRECTION, (Object)AutomationDirection.INPUT));
    }

    public void setDirection(AutomationDirection direction) {
        this.upgrade.set(ModCoreDataComponents.AUTOMATION_DIRECTION, (Object)direction);
        this.save();
    }

    public void setLevel(int level) {
        this.upgrade.set(ModCoreDataComponents.LEVEL, (Object)level);
        this.save();
    }

    public int getLevel() {
        return (Integer)this.upgrade.getOrDefault(ModCoreDataComponents.LEVEL, (Object)10);
    }

    public void setLevelsToStore(int levelsToStore) {
        this.upgrade.set(ModCoreDataComponents.LEVELS_TO_STORE, (Object)levelsToStore);
        this.save();
    }

    public int getLevelsToStore() {
        return (Integer)this.upgrade.getOrDefault(ModCoreDataComponents.LEVELS_TO_STORE, (Object)1);
    }

    public void setLevelsToTake(int levelsToTake) {
        this.upgrade.set(ModCoreDataComponents.LEVELS_TO_TAKE, (Object)levelsToTake);
        this.save();
    }

    public int getLevelsToTake() {
        return (Integer)this.upgrade.getOrDefault(ModCoreDataComponents.LEVELS_TO_TAKE, (Object)1);
    }

    public boolean shouldMendItems() {
        return (Boolean)this.upgrade.getOrDefault(ModCoreDataComponents.MEND_ITEMS, (Object)true);
    }

    public void setMendItems(boolean mendItems) {
        this.upgrade.set(ModCoreDataComponents.MEND_ITEMS, (Object)mendItems);
        this.save();
    }

    private record DamagedItemInfo(ResourceHandler<ItemResource> handler, int slot) {
    }
}

