/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks;

import de.maxhenkel.easypiglins.blocks.HorizontalRotatableBlock;
import de.maxhenkel.easypiglins.blocks.tileentity.BartererTileentity;
import de.maxhenkel.easypiglins.corelib.blockentity.SimpleBlockEntityTicker;
import de.maxhenkel.easypiglins.corelib.item.ItemUtils;
import de.maxhenkel.easypiglins.gui.BartererContainer;
import de.maxhenkel.easypiglins.items.ModItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BartererBlock
extends HorizontalRotatableBlock
implements EntityBlock {
    public BartererBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).strength(2.5f).sound(SoundType.METAL).noOcclusion().lightLevel(value -> 15));
    }

    protected InteractionResult useItemOn(ItemStack heldItem, final BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (!(tileEntity instanceof BartererTileentity)) {
            return super.useItemOn(heldItem, state, worldIn, pos, player, handIn, hit);
        }
        final BartererTileentity barterer = (BartererTileentity)tileEntity;
        if (!barterer.hasPiglin() && heldItem.getItem().equals(ModItems.PIGLIN.get())) {
            barterer.setPiglin(heldItem.copy());
            ItemUtils.decrItemStack(heldItem, player);
            BartererBlock.playPiglinSound(worldIn, pos, SoundEvents.PIGLIN_ADMIRING_ITEM);
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown() && barterer.hasPiglin()) {
            ItemStack stack = barterer.removePiglin();
            if (heldItem.isEmpty()) {
                player.setItemInHand(handIn, stack);
            } else if (!player.getInventory().add(stack)) {
                Direction direction = (Direction)state.getValue((Property)FACING);
                Containers.dropItemStack((Level)worldIn, (double)((double)(direction.getStepX() + pos.getX()) + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)(direction.getStepZ() + pos.getZ()) + 0.5), (ItemStack)stack);
            }
            BartererBlock.playPiglinSound(worldIn, pos, SoundEvents.PIGLIN_JEALOUS);
            return InteractionResult.SUCCESS;
        }
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)state.getBlock().getDescriptionId());
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
                return new BartererContainer(id, playerInventory, barterer.getInputInventory(), barterer.getOutputInventory());
            }
        });
        return InteractionResult.SUCCESS;
    }

    public static void playPiglinSound(Level world, BlockPos pos, SoundEvent soundEvent) {
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, soundEvent, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level1, BlockState state, BlockEntityType<T> type) {
        return new SimpleBlockEntityTicker();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BartererTileentity(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public float getShadeBrightness(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }
}

