/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easypiglins.blocks.BartererBlock;
import de.maxhenkel.easypiglins.blocks.tileentity.BartererTileentity;
import de.maxhenkel.easypiglins.blocks.tileentity.render.BartererRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.PiglinRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BartererRenderer
implements BlockEntityRenderer<BartererTileentity, BartererRenderState> {
    private final Minecraft minecraft = Minecraft.getInstance();
    private PiglinRenderer renderer;

    public BartererRenderState createRenderState() {
        return new BartererRenderState();
    }

    public void extractRenderState(BartererTileentity barterer, BartererRenderState renderState, float partialTicks, Vec3 vec3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)barterer, (BlockEntityRenderState)renderState, partialTicks, vec3, crumblingOverlay);
        renderState.direction = Direction.SOUTH;
        if (!barterer.isFakeWorld()) {
            renderState.direction = (Direction)barterer.getBlockState().getValue((Property)BartererBlock.FACING);
        } else {
            renderState.lightCoords = 0xF000F0;
        }
        Piglin piglin = barterer.getPiglinEntity();
        if (piglin != null) {
            renderState.renderPiglin = true;
            if (this.renderer == null) {
                this.renderer = (PiglinRenderer)this.minecraft.getEntityRenderDispatcher().getRenderer((Entity)piglin);
            }
            if (renderState.piglinRenderState == null) {
                renderState.piglinRenderState = this.renderer.createRenderState();
            }
            piglin.setItemInHand(InteractionHand.OFF_HAND, barterer.getRenderBarteringItem());
            this.renderer.extractRenderState((AbstractPiglin)piglin, renderState.piglinRenderState, 0.0f);
            renderState.piglinRenderState.lightCoords = renderState.lightCoords;
        } else {
            renderState.renderPiglin = false;
        }
    }

    public void submit(BartererRenderState renderState, PoseStack stack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        stack.pushPose();
        if (renderState.renderPiglin) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.direction.toYRot()));
            stack.translate(0.0, 0.0, -0.25);
            stack.scale(0.45f, 0.45f, 0.45f);
            this.renderer.submit((LivingEntityRenderState)renderState.piglinRenderState, stack, submitNodeCollector, cameraRenderState);
            stack.popPose();
        }
        stack.popPose();
    }
}

