/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.equipment.ArmorMaterials;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItemClient;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.UUIDDeduplicator;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingBackpackItemEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryInteractionHelper;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.ServerStorageSoundHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ColorHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.jspecify.annotations.Nullable;

public class BackpackItem
extends ItemBase
implements IStashStorageItem {
    private final IntSupplier numberOfSlots;
    private final IntSupplier numberOfUpgradeSlots;
    private final Supplier<BackpackBlock> blockSupplier;

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier, Item.Properties properties) {
        this(numberOfSlots, numberOfUpgradeSlots, blockSupplier, p -> p, properties);
    }

    public BackpackItem(IntSupplier numberOfSlots, IntSupplier numberOfUpgradeSlots, Supplier<BackpackBlock> blockSupplier, UnaryOperator<Item.Properties> updateProperties, Item.Properties properties) {
        super((Item.Properties)updateProperties.apply(properties.stacksTo(1).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.CHEST).setEquipSound(ArmorMaterials.LEATHER.equipSound()).build())));
        this.numberOfSlots = numberOfSlots;
        this.numberOfUpgradeSlots = numberOfUpgradeSlots;
        this.blockSupplier = blockSupplier;
    }

    public Block getBackpackBlock() {
        return this.blockSupplier.get();
    }

    public static void setColors(ItemStack backpackStack, int mainColor, int accentColor) {
        backpackStack.set(ModCoreDataComponents.MAIN_COLOR, (Object)mainColor);
        backpackStack.set(ModCoreDataComponents.ACCENT_COLOR, (Object)accentColor);
    }

    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        super.addCreativeTabItems(itemConsumer);
        if (this != ModItems.BACKPACK.get() || !net.p3pp3rf1y.sophisticatedcore.Config.COMMON.enabledItems.isItemEnabled((Item)this)) {
            return;
        }
        for (DyeColor color : DyeColor.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            BackpackItem.setColors(stack, color.getTextureDiffuseColor(), color.getTextureDiffuseColor());
            itemConsumer.accept(stack);
        }
        int mainColor = ColorHelper.calculateColor((int)-3382982, (int)-3382982, List.of(DyeColor.YELLOW, DyeColor.LIME));
        int accentColor = ColorHelper.calculateColor((int)-10342886, (int)-10342886, List.of(DyeColor.BLUE, DyeColor.BLACK));
        ItemStack stack = new ItemStack((ItemLike)this);
        BackpackItem.setColors(stack, mainColor, accentColor);
        itemConsumer.accept(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        if (tooltipFlag.isAdvanced()) {
            BackpackWrapper.fromStack(stack).getContentsUuid().ifPresent(uuid -> tooltipAdder.accept((Component)Component.literal((String)("UUID: " + String.valueOf(uuid))).withStyle(ChatFormatting.DARK_GRAY)));
        }
        if (!Minecraft.getInstance().hasShiftDown()) {
            tooltipAdder.accept((Component)Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (FMLEnvironment.getDist().isClient()) {
            return Optional.ofNullable(BackpackItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    private boolean hasEverlastingUpgrade(ItemStack stack) {
        return !BackpackWrapper.fromStack(stack).getUpgradeHandler().getTypeWrappers(EverlastingUpgradeItem.TYPE).isEmpty();
    }

    public @Nullable Entity createEntity(Level level, Entity entity, ItemStack itemstack) {
        if (!(entity instanceof ItemEntity)) {
            return null;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        UUIDDeduplicator.dedupeBackpackItemEntityInArea(itemEntity);
        return this.hasEverlastingUpgrade(itemstack) ? this.createEverlastingBackpack(level, (ItemEntity)entity, itemstack) : null;
    }

    private @Nullable EverlastingBackpackItemEntity createEverlastingBackpack(Level level, ItemEntity itemEntity, ItemStack itemstack) {
        EverlastingBackpackItemEntity backpackItemEntity = (EverlastingBackpackItemEntity)ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get().create(level, EntitySpawnReason.EVENT);
        if (backpackItemEntity != null) {
            backpackItemEntity.setPos(itemEntity.getX(), itemEntity.getY(), itemEntity.getZ());
            backpackItemEntity.setItem(itemstack);
            backpackItemEntity.setPickUpDelay(itemEntity.pickupDelay);
            if (itemEntity.getOwner() != null) {
                backpackItemEntity.setThrower(itemEntity.getOwner());
            }
            backpackItemEntity.setDeltaMovement(itemEntity.getDeltaMovement());
        }
        return backpackItemEntity;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPlaceContext blockItemUseContext;
        Player player = context.getPlayer();
        if (player == null || !player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (InventoryInteractionHelper.tryInventoryInteraction(context)) {
            return InteractionResult.SUCCESS;
        }
        Direction direction = player.getDirection().getOpposite();
        InteractionResult result = this.tryPlace(player, direction, blockItemUseContext = new BlockPlaceContext(context));
        return result == InteractionResult.PASS ? super.useOn(context) : result;
    }

    public InteractionResult tryPlace(@Nullable Player player, Direction direction, BlockPlaceContext blockItemUseContext) {
        if (!blockItemUseContext.canPlace()) {
            return InteractionResult.FAIL;
        }
        Level level = blockItemUseContext.getLevel();
        BlockPos pos = blockItemUseContext.getClickedPos();
        FluidState fluidstate = blockItemUseContext.getLevel().getFluidState(pos);
        BlockState placementState = (BlockState)((BlockState)this.blockSupplier.get().defaultBlockState().setValue(BackpackBlock.FACING, (Comparable)direction)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        if (!this.canPlace(blockItemUseContext, placementState)) {
            return InteractionResult.FAIL;
        }
        if (level.setBlockAndUpdate(pos, placementState)) {
            ItemStack backpack = blockItemUseContext.getItemInHand();
            WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BackpackBlockEntity.class).ifPresent(be -> {
                be.setBackpack(this.getBackpackCopy(player, backpack));
                be.refreshRenderState();
                be.tryToAddToController();
            });
            if (!level.isClientSide()) {
                BackpackItem.stopBackpackSounds(backpack, level, pos);
            }
            SoundType soundtype = placementState.getSoundType((LevelReader)level, pos, (Entity)player);
            level.playSound((Entity)player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            if (player == null || !player.isCreative()) {
                backpack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void stopBackpackSounds(ItemStack backpack, Level level, BlockPos pos) {
        BackpackWrapper.fromStack(backpack).getContentsUuid().ifPresent(uuid -> ServerStorageSoundHandler.stopPlayingDisc((Level)level, (Vec3)Vec3.atCenterOf((Vec3i)pos), (UUID)uuid));
    }

    private ItemStack getBackpackCopy(@Nullable Player player, ItemStack backpack) {
        if (player == null || !player.isCreative()) {
            return backpack.copy();
        }
        return BackpackWrapper.fromStack(backpack).cloneBackpack();
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player playerentity = context.getPlayer();
        CollisionContext iselectioncontext = playerentity == null ? CollisionContext.empty() : CollisionContext.of((Entity)playerentity);
        return state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) && context.getLevel().isUnobstructed(state, context.getClickedPos(), iselectioncontext);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            String handlerName = hand == InteractionHand.MAIN_HAND ? "main" : "offhand";
            int slot = hand == InteractionHand.MAIN_HAND ? player.getInventory().getSelectedSlot() : 0;
            BackpackContext.Item context = new BackpackContext.Item(handlerName, slot);
            player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new BackpackContainer(w, pl, context), stack.getHoverName()), context::toBuffer);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        if (level.isClientSide() || !(entity instanceof Player) || (player = (Player)entity).isSpectator() || player.isDeadOrDying() || ((Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get()).booleanValue() && slot == null) {
            return;
        }
        BackpackWrapper.fromStack(stack).getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick((Entity)player, player.level(), player.blockPosition()));
        super.inventoryTick(stack, level, entity, slot);
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots.getAsInt();
    }

    public int getNumberOfUpgradeSlots() {
        return this.numberOfUpgradeSlots.getAsInt();
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        BackpackContainer backpackContainer;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        return !(abstractContainerMenu instanceof BackpackContainer && (backpackContainer = (BackpackContainer)abstractContainerMenu).getVisibleStorageItem().map(visibleStorageItem -> visibleStorageItem == item).orElse(false) != false);
    }

    public @Nullable EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return stack.getItem() == ModItems.GOLD_BACKPACK.get();
    }

    public Optional<TooltipComponent> getInventoryTooltip(ItemStack stack) {
        return Optional.of(new BackpackContentsTooltip(stack));
    }

    public int stash(ItemStack storageStack, ItemResource resource, int amount, TransactionContext tx) {
        return BackpackWrapper.fromStack(storageStack).getInventoryForUpgradeProcessing().insert((Resource)resource, amount, tx);
    }

    public IStashStorageItem.StashResult getItemStashable(HolderLookup.Provider registries, ItemStack storageStack, ItemStack stack) {
        IBackpackWrapper wrapper = BackpackWrapper.fromStack(storageStack);
        if (wrapper.getContentsUuid().isEmpty()) {
            return IStashStorageItem.StashResult.SPACE;
        }
        if (InventoryHelper.simulateInsert((ResourceHandler)wrapper.getInventoryForUpgradeProcessing(), (ItemResource)ItemResource.of((ItemStack)stack), (int)stack.getCount()) == 0) {
            return IStashStorageItem.StashResult.NO_SPACE;
        }
        if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.getItem()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
            return IStashStorageItem.StashResult.MATCH_AND_SPACE;
        }
        return IStashStorageItem.StashResult.SPACE;
    }

    public boolean overrideStackedOnOther(ItemStack storageStack, Slot slot, ClickAction action, Player player) {
        int stashed;
        if (this.hasCreativeScreenContainerOpen(player) || storageStack.getCount() > 1 || !slot.mayPickup(player) || action != ClickAction.SECONDARY) {
            return super.overrideStackedOnOther(storageStack, slot, action, player);
        }
        ItemStack stackToStash = slot.getItem();
        ItemResource resource = ItemResource.of((ItemStack)stackToStash);
        try (Transaction tx = Transaction.openRoot();){
            stashed = this.stash(storageStack, resource, stackToStash.getCount(), (TransactionContext)tx);
        }
        if (stashed > 0) {
            slot.safeTake(stashed, stashed, player);
            tx = Transaction.openRoot();
            try {
                this.stash(storageStack, resource, stashed, (TransactionContext)tx);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
            return true;
        }
        return super.overrideStackedOnOther(storageStack, slot, action, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack storageStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess carriedAccess) {
        if (this.hasCreativeScreenContainerOpen(player) || storageStack.getCount() > 1 || !slot.mayPlace(storageStack) || action != ClickAction.SECONDARY) {
            return super.overrideOtherStackedOnMe(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        try (Transaction tx = Transaction.openRoot();){
            int stashed = this.stash(storageStack, ItemResource.of((ItemStack)otherStack), otherStack.getCount(), (TransactionContext)tx);
            if (stashed > 0) {
                carriedAccess.set(otherStack.copyWithCount(otherStack.getCount() - stashed));
                tx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return super.overrideOtherStackedOnMe(storageStack, otherStack, slot, action, player, carriedAccess);
    }

    private boolean hasCreativeScreenContainerOpen(Player player) {
        return player.level().isClientSide() && player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }

    public boolean canFitInsideContainerItems() {
        return (Boolean)Config.SERVER.canBePlacedInContainerItems.get();
    }

    public record BackpackContentsTooltip(ItemStack backpack) implements TooltipComponent
    {
        public ItemStack getBackpack() {
            return this.backpack;
        }
    }
}

