/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.data.BackpackInjectLootSubProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.data.BackpackLootEnabledCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;

public class BackpackLootModifierProvider
extends GlobalLootModifierProvider {
    BackpackLootModifierProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, registries, "sophisticatedbackpacks");
    }

    protected void start() {
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.SIMPLE_DUNGEON, (ResourceKey<LootTable>)BuiltInLootTables.SIMPLE_DUNGEON);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.ABANDONED_MINESHAFT, (ResourceKey<LootTable>)BuiltInLootTables.ABANDONED_MINESHAFT);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.DESERT_PYRAMID, (ResourceKey<LootTable>)BuiltInLootTables.DESERT_PYRAMID);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.WOODLAND_MANSION, (ResourceKey<LootTable>)BuiltInLootTables.WOODLAND_MANSION);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.SHIPWRECK_TREASURE, (ResourceKey<LootTable>)BuiltInLootTables.SHIPWRECK_TREASURE);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.BASTION_TREASURE, (ResourceKey<LootTable>)BuiltInLootTables.BASTION_TREASURE);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.END_CITY_TREASURE, (ResourceKey<LootTable>)BuiltInLootTables.END_CITY_TREASURE);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.NETHER_BRIDGE, (ResourceKey<LootTable>)BuiltInLootTables.NETHER_BRIDGE);
        this.addInjectLootTableModifier(BackpackInjectLootSubProvider.SPAWN_BONUS_CHEST, (ResourceKey<LootTable>)BuiltInLootTables.SPAWN_BONUS_CHEST);
    }

    private void addInjectLootTableModifier(ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
        this.add(lootTableToInjectInto.identifier().getPath(), (IGlobalLootModifier)new InjectLootModifier(lootTable, lootTableToInjectInto), new ICondition[0]);
    }

    public static class InjectLootModifier
    extends LootModifier {
        public static final MapCodec<InjectLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(m -> m.lootTable), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table_to_inject_into").forGetter(m -> m.lootTableToInjectInto))).apply((Applicative)inst, InjectLootModifier::new));
        private final ResourceKey<LootTable> lootTable;
        private final ResourceKey<LootTable> lootTableToInjectInto;

        protected InjectLootModifier(LootItemCondition[] conditions, ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
            super(conditions);
            this.lootTable = lootTable;
            this.lootTableToInjectInto = lootTableToInjectInto;
        }

        protected InjectLootModifier(ResourceKey<LootTable> lootTable, ResourceKey<LootTable> lootTableToInjectInto) {
            this(new LootItemCondition[]{BackpackLootEnabledCondition.builder().build(), LootTableIdCondition.builder((Identifier)lootTableToInjectInto.identifier()).build()}, lootTable, lootTableToInjectInto);
        }

        protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
            context.getResolver().get(this.lootTable).ifPresent(extraTable -> ((LootTable)extraTable.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)context.getLevel(), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0))));
            return generatedLoot;
        }

        public MapCodec<? extends IGlobalLootModifier> codec() {
            return ModItems.INJECT_LOOT.get();
        }
    }
}

