/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot;

import java.util.Collections;
import java.util.List;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.core.BalmRegistrars;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerInfoProvider;
import net.blay09.mods.balm.platform.compatibility.recipeviewer.RecipeViewerRegistrar;
import net.blay09.mods.balm.platform.event.callback.ServerPlayerCallback;
import net.blay09.mods.trashslot.InternalMethodsImpl;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.TrashSlotConfig;
import net.blay09.mods.trashslot.api.TrashSlotAPI;
import net.blay09.mods.trashslot.client.TrashSlotGuiHandler;
import net.blay09.mods.trashslot.client.gui.TrashSlotComponent;
import net.blay09.mods.trashslot.network.MessageTrashSlotContent;
import net.blay09.mods.trashslot.network.ModNetworking;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrashSlot {
    public static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "trashslot";
    public static boolean isServerSideInstalled;

    public static void initialize(BalmRegistrars registrars) {
        TrashSlotAPI.__setupAPI(new InternalMethodsImpl());
        TrashSlotConfig.initialize();
        ModNetworking.initialize(Balm.networking());
        ServerPlayerCallback.Join.EVENT.register(player -> {
            TrashHelper.setTrashItem((Player)player, ItemStack.EMPTY);
            Balm.networking().sendTo((Player)player, (CustomPacketPayload)new MessageTrashSlotContent(ItemStack.EMPTY));
        });
        ServerPlayerCallback.Respawn.EVENT.register((oldPlayer, newPlayer) -> Balm.networking().sendTo((Player)newPlayer, (CustomPacketPayload)new MessageTrashSlotContent(ItemStack.EMPTY)));
        ServerPlayerCallback.OpenMenu.EVENT.register((player, menu) -> {
            ItemStack trashItem = TrashHelper.getTrashItem((Player)player);
            Balm.networking().sendTo((Player)player, (CustomPacketPayload)new MessageTrashSlotContent(trashItem));
        });
        Balm.modSupport().recipeViewers().register(Identifier.fromNamespaceAndPath((String)MOD_ID, (String)"occlusions"), new RecipeViewerInfoProvider(){

            public void initialize(RecipeViewerRegistrar recipeViewerRegistrar) {
                recipeViewerRegistrar.registerGlobalScreenOcclusion(containerScreen -> {
                    TrashSlotComponent trashSlot = TrashSlotGuiHandler.getTrashSlotComponent();
                    return trashSlot != null && trashSlot.isVisible() ? List.of(trashSlot.getRectangle()) : Collections.emptyList();
                });
            }
        });
    }
}

