/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.Balm;
import net.blay09.mods.balm.platform.config.reflection.Comment;
import net.blay09.mods.balm.platform.config.reflection.Config;
import net.blay09.mods.balm.platform.config.reflection.NestedType;
import net.blay09.mods.balm.platform.event.callback.ConfigCallback;
import net.blay09.mods.trashslot.TrashSlot;
import net.blay09.mods.trashslot.client.deletion.CreativeDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DefaultDeletionProvider;
import net.blay09.mods.trashslot.client.deletion.DeletionProvider;
import org.jetbrains.annotations.Nullable;

@Config(value="trashslot")
public class TrashSlotConfig {
    @Comment(value="This causes the deletion slot to delete items instantly, similar to Creative Mode.")
    public boolean instantDeletion = false;
    @Comment(value="Set to true if you want the delete keybindings to work in creative as well. Note: Items will be deleted permanently in creative, regardless of instantDeletion setting!")
    public boolean enableDeleteKeysInCreative = true;
    @Comment(value="TrashSlot will show a hint the first time the trash slot is toggled off or can be enabled on a supported screen. Set to false to disable.")
    public boolean enableHints = true;
    @Comment(value="Not recommended, but this will allow you to use the keybinds for deleting items even if the trash slot itself is hidden.")
    public boolean allowDeletionWhileTrashSlotIsInvisible = false;
    @Comment(value="List of items that cannot be deleted, in comma-separated format of \"modid:name\".")
    @NestedType(value=String.class)
    public List<String> deletionDenyList = new ArrayList<String>();
    private static DeletionProvider deletionProvider;
    private static final DeletionProvider creativeDeletionProvider;

    public static TrashSlotConfig getActive() {
        return (TrashSlotConfig)Balm.config().getActiveConfig(TrashSlotConfig.class);
    }

    public static void initialize() {
        Balm.config().registerConfig(TrashSlotConfig.class);
        ConfigCallback.Reloaded.EVENT.register(schema -> {
            deletionProvider = null;
        });
    }

    @Nullable
    public static DeletionProvider getDeletionProvider() {
        if (TrashSlot.isServerSideInstalled && deletionProvider == null) {
            deletionProvider = TrashSlotConfig.getActive().instantDeletion ? creativeDeletionProvider : new DefaultDeletionProvider();
        }
        return deletionProvider;
    }

    public static DeletionProvider getCreativeDeletionProvider() {
        return creativeDeletionProvider;
    }

    static {
        creativeDeletionProvider = new CreativeDeletionProvider();
    }
}

