/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.util.minecraft;

import com.hyfata.najoan.koreanpatch.mixin.accessor.GuiGraphicsAccessor;
import com.hyfata.najoan.koreanpatch.util.minecraft.gui.FloatRenderState;
import com.hyfata.najoan.koreanpatch.util.minecraft.gui.FloatTextRenderState;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class RenderUtil {
    private static final Minecraft client = Minecraft.getInstance();

    public static void drawCenteredText(GuiGraphics guiGraphics, FormattedCharSequence text, float x, float y) {
        RenderUtil.drawCenteredText(guiGraphics, text, x, y, -1);
    }

    public static void drawCenteredText(GuiGraphics guiGraphics, FormattedCharSequence text, float x, float y, int color) {
        Font textRenderer = RenderUtil.client.font;
        float textWidth = textRenderer.width(text);
        float xPosition = x - textWidth / 2.0f;
        Objects.requireNonNull(RenderUtil.client.font);
        float yPosition = y - 9.0f / 2.0f;
        RenderUtil.drawText(guiGraphics, text, xPosition, yPosition, color);
    }

    public static void drawText(GuiGraphics guiGraphics, FormattedCharSequence text, float x, float y) {
        RenderUtil.drawText(guiGraphics, text, x, y, -1);
    }

    public static void drawText(GuiGraphics guiGraphics, FormattedCharSequence text, float x, float y, int color) {
        if (ARGB.alpha((int)color) != 0) {
            GuiGraphicsAccessor accessor = (GuiGraphicsAccessor)guiGraphics;
            accessor.getGuiRenderState().submitText((GuiTextRenderState)new FloatTextRenderState(RenderUtil.client.font, text, new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), x, y, color, 0, true, false, accessor.getScissorStack().peek()));
        }
    }

    public static void fill(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, int color) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        RenderUtil.submitColoredRectangle(guiGraphics, TextureSetup.noTexture(), x1, y1, x2, y2, color);
    }

    private static void submitColoredRectangle(GuiGraphics guiGraphics, TextureSetup textureSetup, float x0, float y0, float x1, float y1, int col1) {
        GuiGraphicsAccessor accessor = (GuiGraphicsAccessor)guiGraphics;
        accessor.getGuiRenderState().submitGuiElement((GuiElementRenderState)new FloatRenderState(RenderPipelines.GUI, textureSetup, new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), x0, y0, x1, y1, col1, col1, accessor.getScissorStack().peek()));
    }

    public static void drawVertexCircleFrame(GuiGraphics guiGraphics, float centerX, float centerY, float radius, int frameColor, float frameThickness, VertexDirection direction) {
        float innerRadius = radius - frameThickness;
        if (innerRadius < 0.0f) {
            throw new IllegalArgumentException("Frame thickness cannot be greater than the outer radius.");
        }
        int steps = 18;
        float angleStep = 1.5707964f / (float)steps;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = Mth.cos((double)angleStep);
        float sinDelta = Mth.sin((double)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, innerRadius, cos, sin, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, cos, sin, direction);
            RenderUtil.fill(guiGraphics, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    public static void drawVertexSuperellipseFrame(GuiGraphics guiGraphics, float centerX, float centerY, float radiusX, float radiusY, float exponent, int frameColor, float frameThickness, VertexDirection direction) {
        int steps = 36;
        float angleStep = 1.5707964f / (float)steps;
        float correctedExponent = 2.0f / exponent;
        float cos = 1.0f;
        float sin = 0.0f;
        float cosDelta = Mth.cos((double)angleStep);
        float sinDelta = Mth.sin((double)angleStep);
        for (int i = 0; i < steps; ++i) {
            float tempCos = cos;
            cos = cos * cosDelta - sin * sinDelta;
            sin = tempCos * sinDelta + sin * cosDelta;
            float projX = (float)Math.pow(Mth.abs((float)cos), correctedExponent);
            float projY = (float)Math.pow(Mth.abs((float)sin), correctedExponent);
            float[] innerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX - frameThickness, radiusY - frameThickness, projX, projY, direction);
            float[] outerPoint = RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radiusX, radiusY, projX, projY, direction);
            RenderUtil.fill(guiGraphics, innerPoint[0], innerPoint[1], outerPoint[0], outerPoint[1], frameColor);
        }
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radius, float projX, float projY, VertexDirection direction) {
        return RenderUtil.calculateVertexDirectionPoint(centerX, centerY, radius, radius, projX, projY, direction);
    }

    private static float[] calculateVertexDirectionPoint(float centerX, float centerY, float radiusX, float radiusY, float projX, float projY, VertexDirection direction) {
        float x;
        return new float[]{x, switch (direction.ordinal()) {
            case 0 -> {
                x = centerX - radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case 1 -> {
                x = centerX + radiusX * projX;
                yield centerY - radiusY * projY;
            }
            case 2 -> {
                x = centerX - radiusX * projX;
                yield centerY + radiusY * projY;
            }
            case 3 -> {
                x = centerX + radiusX * projX;
                yield centerY + radiusY * projY;
            }
            default -> throw new IllegalArgumentException("Invalid VertexDirection");
        }};
    }

    public static enum VertexDirection {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

