/*
 * Decompiled with CFR 0.152.
 */
package com.hyfata.najoan.koreanpatch.wrapper;

import com.hyfata.najoan.koreanpatch.client.GUIStatus;
import com.hyfata.najoan.koreanpatch.mixin.accessor.CreativeModeInventoryScreenInvoker;
import com.hyfata.najoan.koreanpatch.mixin.accessor.EditBoxAccessor;
import com.hyfata.najoan.koreanpatch.process.HangulProcessor;
import com.hyfata.najoan.koreanpatch.process.LangTypeManager;
import com.hyfata.najoan.koreanpatch.process.keyboard.KeyboardLayout;
import com.hyfata.najoan.koreanpatch.util.HangulUtil;
import com.hyfata.najoan.koreanpatch.wrapper.InterfaceIMEWrapper;
import com.hyfata.najoan.koreanpatch.wrapper.handler.IMEWrapperHandler;
import java.util.concurrent.Callable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class WrapperEditBox
implements InterfaceIMEWrapper {
    private final EditBoxAccessor accessor;
    private final Minecraft client = Minecraft.getInstance();

    public WrapperEditBox(EditBoxAccessor accessor) {
        this.accessor = accessor;
    }

    @Override
    public int getCursor() {
        return this.accessor.invokeGetCursorPosition();
    }

    @Override
    public void writeText(String str) {
        this.accessor.invokeInsertText(str);
        this.updateScreen();
    }

    @Override
    public void modifyText(String str) {
        int cursorPosition = this.accessor.invokeGetCursorPosition();
        this.accessor.invokeSetHighlightPos(cursorPosition - 1);
        this.accessor.invokeInsertText(str);
    }

    private void updateScreen() {
        if (this.client.screen == null) {
            return;
        }
        if (this.client.screen instanceof CreativeModeInventoryScreen && !this.accessor.invokeGetValue().isEmpty()) {
            ((CreativeModeInventoryScreenInvoker)this.client.screen).updateCreativeSearch();
        }
    }

    private boolean onBackspaceKeyPressed() {
        if (!this.accessor.invokeGetHighlighted().isEmpty()) {
            return false;
        }
        int cursorPosition = this.accessor.invokeGetCursorPosition();
        return IMEWrapperHandler.onBackspaceKeyPressed(this, cursorPosition, this.accessor.invokeGetValue());
    }

    private boolean onHangulCharTyped(int keyCode, int modifiers) {
        return IMEWrapperHandler.onHangulCharTyped(this, keyCode, modifiers, this.accessor.invokeGetValue(), this.accessor.invokeGetHighlighted().isEmpty());
    }

    private boolean validateKeyPressed(KeyEvent keyEvent) {
        Minecraft client = Minecraft.getInstance();
        if (client.screen != null && !GUIStatus.getInstance().isBypassInjection() && keyEvent.key() == 259) {
            return this.onBackspaceKeyPressed();
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.validateKeyPressed(keyEvent)) {
            callbackInfo.setReturnValue((Object)Boolean.TRUE);
        }
    }

    public boolean keyPressed(KeyEvent keyEvent, Callable<Boolean> callable) {
        if (this.validateKeyPressed(keyEvent)) {
            return true;
        }
        return this.returnCallable(callable);
    }

    private boolean validateCharTyped(CharacterEvent event, boolean isEditable) {
        char chr = (char)event.codepoint();
        return Minecraft.getInstance().screen != null && !GUIStatus.getInstance().isBypassInjection() && LangTypeManager.getInstance().isKorean() && isEditable && event.isAllowedChatCharacter() && Character.charCount(chr) == 1;
    }

    public boolean charTyped(CharacterEvent charEvent, boolean isEditable, Callable<Boolean> callable) {
        char chr = (char)charEvent.codepoint();
        int modifiers = charEvent.modifiers();
        if (!this.validateCharTyped(charEvent, isEditable)) {
            return this.returnCallable(callable);
        }
        int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
        if (qwertyIndex == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return this.returnCallable(callable);
        }
        if (!this.accessor.invokeCanConsumeInput()) {
            return false;
        }
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
        if (this.getCursor() == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
            this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
        }
        return true;
    }

    public void charTyped(CharacterEvent charEvent, CallbackInfoReturnable<Boolean> cir, boolean isEditable) {
        char chr = (char)charEvent.codepoint();
        int modifiers = charEvent.modifiers();
        if (!this.validateCharTyped(charEvent, isEditable)) {
            return;
        }
        int qwertyIndex = KeyboardLayout.INSTANCE.getQwertyIndexCodePoint(chr);
        if (qwertyIndex == -1) {
            KeyboardLayout.INSTANCE.assemblePosition = -1;
            return;
        }
        if (!this.accessor.invokeCanConsumeInput()) {
            cir.setReturnValue((Object)Boolean.FALSE);
            return;
        }
        cir.setReturnValue((Object)Boolean.TRUE);
        char curr = KeyboardLayout.INSTANCE.layout.toCharArray()[qwertyIndex];
        if (this.getCursor() == 0 || !HangulProcessor.isHangulCharacter(curr) || !this.onHangulCharTyped(chr, modifiers)) {
            this.writeText(String.valueOf(HangulUtil.getFixedHangulChar(modifiers, chr, curr)));
            KeyboardLayout.INSTANCE.assemblePosition = HangulProcessor.isHangulCharacter(curr) ? this.getCursor() : -1;
        }
    }

    private boolean returnCallable(Callable<Boolean> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            return false;
        }
    }
}

