/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.mixin;

import com.mojang.blaze3d.opengl.GlDevice;
import com.mojang.blaze3d.opengl.GlProgram;
import com.mojang.blaze3d.opengl.GlRenderPipeline;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.HashSet;
import java.util.Set;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.CompositeRenderer;
import net.irisshaders.iris.pipeline.IrisPipelines;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.vertices.ImmediateState;
import net.minecraft.client.renderer.RenderPipelines;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GlDevice.class})
public abstract class MixinShaderManager_Overrides {
    @Unique
    private Set<RenderPipeline> missingShaders = new HashSet<RenderPipeline>();

    @Inject(method={"getOrCompilePipeline"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectIrisProgram(RenderPipeline renderPipeline, CallbackInfoReturnable<GlRenderPipeline> cir) {
        IrisRenderingPipeline irisPipeline;
        if (renderPipeline == CompositeRenderer.COMPOSITE_PIPELINE) {
            return;
        }
        if (renderPipeline == RenderPipelines.ANIMATE_SPRITE_BLIT || renderPipeline == RenderPipelines.ANIMATE_SPRITE_INTERPOLATE) {
            return;
        }
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        if (pipeline instanceof IrisRenderingPipeline && (irisPipeline = (IrisRenderingPipeline)pipeline).shouldOverrideShaders() && !ImmediateState.bypass) {
            RenderPipeline newProgram = renderPipeline;
            GlProgram program = MixinShaderManager_Overrides.override(irisPipeline, newProgram);
            if (program != null) {
                cir.setReturnValue((Object)new GlRenderPipeline(renderPipeline, program));
            } else if (this.missingShaders.add(renderPipeline)) {
                if (renderPipeline.getLocation().getNamespace().equals("minecraft")) {
                    Iris.logger.fatal("Missing program " + String.valueOf(renderPipeline.getLocation()) + " in override list. This is likely an Iris bug!!!", new Throwable());
                } else {
                    Iris.logger.error("Missing program " + String.valueOf(renderPipeline.getLocation()) + " in override list. This is not a critical problem, but it could lead to weird rendering.", new Throwable());
                }
            }
        }
    }

    private static GlProgram override(IrisRenderingPipeline pipeline, RenderPipeline shaderProgram) {
        ShaderKey shaderKey = IrisPipelines.getPipeline(pipeline, shaderProgram);
        return shaderKey == null ? null : pipeline.getShaderMap().getShader(shaderKey);
    }
}

