/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.world.interests;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;

public interface PoiOrdering {
    default public boolean isOrdered(BlockPos center, PoiManager poiManager, List<BlockPos> positions) {
        if (!positions.isEmpty()) {
            BlockPos curr = positions.getFirst();
            for (int i = 1; i < positions.size(); ++i) {
                BlockPos next = positions.get(i);
                int order = this.compare(center, poiManager, curr, next);
                if (order != 1) {
                    return false;
                }
                curr = next;
            }
        }
        return true;
    }

    default public void checkOrderOrThrow(BlockPos center, PoiManager poiManager, List<BlockPos> positions) {
        if (!positions.isEmpty()) {
            BlockPos curr = positions.getFirst();
            for (int i = 1; i < positions.size(); ++i) {
                BlockPos next = positions.get(i);
                int order = this.compare(center, poiManager, curr, next);
                if (order != -1) {
                    if (order == 0) {
                        order = this.compare(center, poiManager, curr, next);
                        throw new IllegalStateException("Positions are equal at index " + i + ": " + String.valueOf(curr) + " == " + String.valueOf(next));
                    }
                    order = this.compare(center, poiManager, curr, next);
                    throw new IllegalStateException("Positions are ordered incorrectly at index " + i + ": " + String.valueOf(curr) + " < " + String.valueOf(next) + "! Offsets: curr=(" + (curr.getX() - center.getX()) + ", " + (curr.getY() - center.getY()) + ", " + (curr.getZ() - center.getZ()) + "), next=(" + (next.getX() - center.getX()) + ", " + (next.getY() - center.getY()) + ", " + (next.getZ() - center.getZ()) + ")");
                }
                curr = next;
            }
        }
    }

    default public Comparator<BlockPos> getAsComparator(BlockPos center, PoiManager poiManager) {
        return (posA, posB) -> this.compare(center, poiManager, (BlockPos)posA, (BlockPos)posB);
    }

    public int compare(BlockPos var1, PoiManager var2, BlockPos var3, BlockPos var4);

    public record L2ThenMinYThenInSquare() implements PoiOrdering
    {
        public static final L2ThenMinYThenInSquare INSTANCE = new L2ThenMinYThenInSquare();

        @Override
        public int compare(BlockPos center, PoiManager poiManager, BlockPos posA, BlockPos posB) {
            double distBSq;
            double distASq = center.distSqr((Vec3i)posA);
            int orderDist = Double.compare(distASq, distBSq = center.distSqr((Vec3i)posB));
            if (orderDist != 0) {
                return orderDist;
            }
            int orderY = Integer.compare(posA.getY(), posB.getY());
            if (orderY != 0) {
                return orderY;
            }
            return InSquare.INSTANCE.compare(center, poiManager, posA, posB);
        }
    }

    public record L2ThenInSquare() implements PoiOrdering
    {
        public static final L2ThenInSquare INSTANCE = new L2ThenInSquare();

        @Override
        public int compare(BlockPos center, PoiManager poiManager, BlockPos posA, BlockPos posB) {
            double distBSq;
            double distASq = center.distSqr((Vec3i)posA);
            int orderDist = Double.compare(distASq, distBSq = center.distSqr((Vec3i)posB));
            if (orderDist != 0) {
                return orderDist;
            }
            return InSquare.INSTANCE.compare(center, poiManager, posA, posB);
        }
    }

    public record InSquare() implements PoiOrdering
    {
        public static final InSquare INSTANCE = new InSquare();

        @Override
        public int compare(BlockPos center, PoiManager poiManager, BlockPos posA, BlockPos posB) {
            int bChunkX;
            int bChunkZ;
            int aChunkZ = posA.getZ() >> 4;
            int orderZ = Integer.compare(aChunkZ, bChunkZ = posB.getZ() >> 4);
            if (orderZ != 0) {
                return orderZ;
            }
            int aChunkX = posA.getX() >> 4;
            int orderX = Integer.compare(aChunkX, bChunkX = posB.getX() >> 4);
            if (orderX != 0) {
                return orderX;
            }
            return InChunk.INSTANCE.compare(center, poiManager, posA, posB);
        }
    }

    public record InChunk() implements PoiOrdering
    {
        public static final InChunk INSTANCE = new InChunk();

        @Override
        public int compare(BlockPos center, PoiManager poiManager, BlockPos posA, BlockPos posB) {
            int bChunkY;
            int bChunkX;
            int bChunkZ;
            if (posA.equals((Object)posB)) {
                return 0;
            }
            int aChunkZ = posA.getZ() >> 4;
            int orderZ = Integer.compare(aChunkZ, bChunkZ = posB.getZ() >> 4);
            if (orderZ != 0) {
                throw new IllegalStateException("Positions are not in the same chunk: " + String.valueOf(posA) + " in " + String.valueOf(new ChunkPos(posA)) + " vs " + String.valueOf(posB) + " in " + String.valueOf(new ChunkPos(posB)));
            }
            int aChunkX = posA.getX() >> 4;
            int orderX = Integer.compare(aChunkX, bChunkX = posB.getX() >> 4);
            if (orderX != 0) {
                throw new IllegalStateException("Positions are not in the same chunk: " + String.valueOf(posA) + " in " + String.valueOf(new ChunkPos(posA)) + " vs " + String.valueOf(posB) + " in " + String.valueOf(new ChunkPos(posB)));
            }
            int aChunkY = posA.getY() >> 4;
            int orderY = Integer.compare(aChunkY, bChunkY = posB.getY() >> 4);
            if (orderY != 0) {
                return orderY;
            }
            Optional poiSection = poiManager.getOrLoad(SectionPos.asLong((BlockPos)posA));
            if (poiSection.isEmpty()) {
                throw new IllegalStateException("PoiManager " + String.valueOf(poiManager) + " has no section at position " + String.valueOf(posA));
            }
            PoiSection poiSection1 = (PoiSection)poiSection.get();
            List<PoiRecord> retrievedRecords = poiSection1.getRecords(a -> true, PoiManager.Occupancy.ANY).filter(poiRecord -> poiRecord.getPos().equals((Object)posA) || poiRecord.getPos().equals((Object)posB)).toList();
            if (retrievedRecords.size() != 2) {
                throw new IllegalStateException("Expected two POI records at " + String.valueOf(posA) + ", " + String.valueOf(posB) + ", found " + retrievedRecords.size());
            }
            if (retrievedRecords.getFirst().getPos().equals((Object)posA)) {
                return -1;
            }
            if (retrievedRecords.getFirst().getPos().equals((Object)posB)) {
                return 1;
            }
            throw new IllegalStateException("Expected two differing poi positions matching " + String.valueOf(posA) + ", " + String.valueOf(posB) + ", found " + String.valueOf(retrievedRecords));
        }
    }
}

