/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.non_poi_block_search;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.ai.non_poi_block_search.CheckAndCacheBlockChecker;
import net.caffeinemc.mods.lithium.common.ai.non_poi_block_search.LithiumMoveToBlockGoal;
import net.caffeinemc.mods.lithium.common.ai.non_poi_block_search.NonPOISearchDistances;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={MoveToBlockGoal.class})
public abstract class MoveToBlockGoalMixin
implements LithiumMoveToBlockGoal {
    @Shadow
    @Final
    protected PathfinderMob mob;
    @Shadow
    @Final
    private int searchRange;
    @Shadow
    @Final
    private int verticalSearchRange;
    @Shadow
    protected int verticalSearchStart;
    @Shadow
    protected BlockPos blockPos;

    @Override
    public boolean lithium$findNearestBlock(Predicate<BlockState> requiredBlock, BiPredicate<ChunkAccess, BlockPos.MutableBlockPos> lithium$isValidTarget, boolean shouldChunkLoad) {
        BlockPos center = this.mob.blockPosition().offset(0, -1, 0);
        Level levelReader = this.mob.level();
        CheckAndCacheBlockChecker checker = new CheckAndCacheBlockChecker(center, this.searchRange - 1, this.verticalSearchRange, (LevelReader)levelReader, requiredBlock, shouldChunkLoad);
        LongArrayList sortedChunksMaybeWithBlock = new LongArrayList(checker.getChunkSize());
        checker.initializeChunks(arg_0 -> sortedChunksMaybeWithBlock.addLast(arg_0));
        if (checker.shouldStop()) {
            return false;
        }
        int minY = Pos.BlockCoord.getMinY((LevelHeightAccessor)levelReader);
        int maxY = Pos.BlockCoord.getMaxYInclusive((LevelHeightAccessor)levelReader);
        if (!checker.hasUnloadedPossibleChunks()) {
            return this.lithium$chunkAwareSearch(center, lithium$isValidTarget, checker, sortedChunksMaybeWithBlock, minY, maxY);
        }
        return this.lithium$vanillaOrderSearch(center, lithium$isValidTarget, checker, minY, maxY);
    }

    @Unique
    private boolean lithium$vanillaOrderSearch(BlockPos center, BiPredicate<ChunkAccess, BlockPos.MutableBlockPos> lithium$isValidTarget, CheckAndCacheBlockChecker checker, int minY, int maxY) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        int centerY = center.getY();
        int layer = this.verticalSearchStart;
        while (layer <= this.verticalSearchRange) {
            int y = centerY + layer;
            if (y >= minY && y <= maxY) {
                for (int ring = 0; ring < this.searchRange; ++ring) {
                    int dX = 0;
                    while (dX <= ring) {
                        int dZ;
                        int n = dZ = dX < ring && dX > -ring ? ring : 0;
                        while (dZ <= ring) {
                            ChunkAccess chunkAccess;
                            currentPos.setWithOffset((Vec3i)center, dX, layer, dZ);
                            if (this.mob.isWithinHome((BlockPos)currentPos) && checker.checkPosition((BlockPos)currentPos) && lithium$isValidTarget.test(chunkAccess = checker.getCachedChunkAccess((BlockPos)currentPos), currentPos)) {
                                this.blockPos = currentPos;
                                return true;
                            }
                            dZ = dZ > 0 ? -dZ : 1 - dZ;
                        }
                        dX = dX > 0 ? -dX : 1 - dX;
                    }
                }
            }
            layer = layer > 0 ? -layer : 1 - layer;
        }
        return false;
    }

    @Unique
    private boolean lithium$chunkAwareSearch(BlockPos center, BiPredicate<ChunkAccess, BlockPos.MutableBlockPos> lithium$isValidTarget, CheckAndCacheBlockChecker checker, LongArrayList sortedChunksMaybeWithBlock, int minY, int maxY) {
        sortedChunksMaybeWithBlock.sort((chunkLong0, chunkLong1) -> NonPOISearchDistances.MoveToBlockGoalDistances.getMinimumSortOrderOfChunk(center, chunkLong0) - NonPOISearchDistances.MoveToBlockGoalDistances.getMinimumSortOrderOfChunk(center, chunkLong1));
        Predicate<BlockState> requiredBlock = checker.blockStatePredicate;
        int minSectionY = checker.minSectionY;
        BlockPos.MutableBlockPos foundPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        int layer = this.verticalSearchStart;
        while (layer <= this.verticalSearchRange) {
            int y = center.getY() + layer;
            if (y >= minY && y <= maxY) {
                int chunkZ;
                long chunkPos;
                int chunkX;
                int chunkY = SectionPos.blockToSectionCoord((int)y);
                int ySectionIndex = chunkY - minSectionY;
                int closestFound = Integer.MAX_VALUE;
                int ringMax = this.searchRange - 1;
                LongListIterator longListIterator = sortedChunksMaybeWithBlock.iterator();
                while (longListIterator.hasNext() && closestFound >= NonPOISearchDistances.MoveToBlockGoalDistances.getMinimumSortOrderOfChunk(center, chunkX = ChunkPos.getX((long)(chunkPos = ((Long)longListIterator.next()).longValue())), chunkZ = ChunkPos.getZ((long)chunkPos))) {
                    if (!checker.checkCachedSection(chunkX, chunkY, chunkZ)) continue;
                    ChunkAccess chunkAccess = checker.getCachedChunkAccess(chunkPos);
                    int chunkBlockX = SectionPos.sectionToBlockCoord((int)chunkX);
                    int xMin = Math.max(center.getX() - ringMax, chunkBlockX);
                    int xMax = Math.min(center.getX() + ringMax, chunkBlockX + 15);
                    int chunkBlockZ = SectionPos.sectionToBlockCoord((int)chunkZ);
                    int zMin = Math.max(center.getZ() - ringMax, chunkBlockZ);
                    int zMax = Math.min(center.getZ() + ringMax, chunkBlockZ + 15);
                    LevelChunkSection levelChunkSection = chunkAccess.getSections()[ySectionIndex];
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int x = xMin; x <= xMax; ++x) {
                            int dZ;
                            int dX = x - center.getX();
                            int ring = NonPOISearchDistances.MoveToBlockGoalDistances.getRing(dX, dZ = z - center.getZ());
                            int currentDistance = NonPOISearchDistances.MoveToBlockGoalDistances.getVanillaSortOrderInt(ring, dX, dZ);
                            if (currentDistance >= closestFound || !this.mob.isWithinHome((BlockPos)currentPos.set(x, y, z)) || !requiredBlock.test(levelChunkSection.getBlockState(x & 0xF, y & 0xF, z & 0xF)) || !lithium$isValidTarget.test(chunkAccess, currentPos)) continue;
                            ringMax = ring;
                            xMin = Math.max(center.getX() - ringMax, chunkBlockX);
                            xMax = Math.min(center.getX() + ringMax, chunkBlockX + 15);
                            zMax = Math.min(center.getZ() + ringMax, chunkBlockZ + 15);
                            foundPos.set(x, y, z);
                            closestFound = currentDistance;
                        }
                    }
                }
                if (closestFound < Integer.MAX_VALUE) {
                    this.blockPos = foundPos;
                    return true;
                }
            }
            layer = layer > 0 ? -layer : 1 - layer;
        }
        return false;
    }
}

