/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.ai.poi;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.BitSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.caffeinemc.mods.lithium.common.util.Distances;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.util.collections.ListeningLong2ObjectOpenHashMap;
import net.caffeinemc.mods.lithium.common.util.functions.FunLongAnd5;
import net.caffeinemc.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionStorage.class})
public abstract class SectionStorageMixin<R>
implements RegionBasedStorageSectionExtended<R> {
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> storage;
    @Shadow
    @Final
    protected LevelHeightAccessor levelHeightAccessor;
    private Long2ObjectOpenHashMap<BitSet> columns;

    @Shadow
    protected abstract Optional<R> get(long var1);

    @Shadow
    protected abstract void unpackChunk(ChunkPos var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(SimpleRegionStorage simpleRegionStorage, Codec codec, Function function, BiFunction biFunction, Function function2, RegistryAccess registryAccess, ChunkIOErrorReporter chunkIOErrorReporter, LevelHeightAccessor levelHeightAccessor, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.storage = new ListeningLong2ObjectOpenHashMap<Optional>(this::onEntryAdded, this::onEntryRemoved);
    }

    private void onEntryRemoved(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.levelHeightAccessor, SectionPos.y((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.levelHeightAccessor)) {
            return;
        }
        int x = SectionPos.x((long)key);
        long pos = ChunkPos.asLong((int)x, (int)(z = SectionPos.z((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags != null) {
            flags.clear(y);
            if (flags.isEmpty()) {
                this.columns.remove(pos);
            }
        }
    }

    private void onEntryAdded(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.levelHeightAccessor, SectionPos.y((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.levelHeightAccessor)) {
            return;
        }
        int x = SectionPos.x((long)key);
        long pos = ChunkPos.asLong((int)x, (int)(z = SectionPos.z((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags == null) {
            flags = new BitSet(Pos.SectionYIndex.getNumYSections(this.levelHeightAccessor));
            this.columns.put(pos, (Object)flags);
        }
        flags.set(y, value.isPresent());
    }

    @Override
    public <S, T, U> U lithium$getFirstInRangeInChunkColumn(int chunkX, int chunkZ, long deltaYSqMargin, BlockPos center, long radiusSq, FunLongAnd5<R, BlockPos, Predicate<Holder<S>>, Predicate<BlockPos>, T, U> sectionMapper, Predicate<Holder<S>> predicate, Predicate<BlockPos> filter, T status) {
        BitSet sectionsWithPOI = this.lithium$getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return null;
        }
        int minYSection = Pos.SectionYCoord.getMinYSection(this.levelHeightAccessor);
        int chunkYIndex = sectionsWithPOI.nextSetBit(0);
        while (chunkYIndex != -1) {
            Object r;
            U result;
            int chunkY = chunkYIndex + minYSection;
            long minYDistance = Distances.getClosestBlockCoordInSection(center.getY(), chunkY) - center.getY();
            if (minYDistance * minYDistance <= deltaYSqMargin && (result = sectionMapper.apply(r = ((Optional)this.storage.get(SectionPos.asLong((int)chunkX, (int)chunkY, (int)chunkZ))).orElse(null), center, predicate, filter, status, radiusSq)) != null) {
                return result;
            }
            chunkYIndex = sectionsWithPOI.nextSetBit(chunkYIndex + 1);
        }
        return null;
    }

    @Override
    public Iterable<R> lithium$getInChunkColumn(final int chunkX, final int chunkZ) {
        final BitSet sectionsWithPOI = this.lithium$getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return Collections::emptyIterator;
        }
        final Long2ObjectMap<Optional<R>> loadedElements = this.storage;
        final LevelHeightAccessor world = this.levelHeightAccessor;
        return () -> new AbstractIterator<R>(this){
            private int nextBit;
            {
                this.nextBit = sectionsWithPOI.nextSetBit(0);
            }

            protected R computeNext() {
                while (this.nextBit >= 0) {
                    Optional next = (Optional)loadedElements.get(SectionPos.asLong((int)chunkX, (int)Pos.SectionYCoord.fromSectionIndex(world, this.nextBit), (int)chunkZ));
                    this.nextBit = sectionsWithPOI.nextSetBit(this.nextBit + 1);
                    if (!next.isPresent()) continue;
                    return next.get();
                }
                return this.endOfData();
            }
        };
    }

    @Override
    public BitSet lithium$getNonEmptyPOISections(int chunkX, int chunkZ) {
        long pos = ChunkPos.asLong((int)chunkX, (int)chunkZ);
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags != null) {
            return flags;
        }
        this.unpackChunk(new ChunkPos(pos));
        return Objects.requireNonNull((BitSet)this.columns.get(pos), "Failed to load POI section data!");
    }

    @Override
    public Optional<R> lithium$getElementAt(long sectionPos) {
        return (Optional)this.storage.get(sectionPos);
    }

    @Override
    public int lithium$getChunkYMin() {
        return Pos.SectionYCoord.getMinYSection(this.levelHeightAccessor);
    }

    @Override
    public int lithium$getChunkYMaxInclusive() {
        return Pos.SectionYCoord.getMaxYSectionInclusive(this.levelHeightAccessor);
    }
}

