/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.util.entity_movement_tracking;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import net.caffeinemc.mods.lithium.common.entity.PositionedEntityTrackingSection;
import net.caffeinemc.mods.lithium.common.tracking.entity.EntityMovementTrackerSection;
import net.caffeinemc.mods.lithium.common.tracking.entity.MovementTrackerHelper;
import net.caffeinemc.mods.lithium.common.tracking.entity.SectionedEntityMovementTracker;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={EntitySection.class})
public abstract class EntitySectionMixin
implements EntityMovementTrackerSection,
PositionedEntityTrackingSection {
    @Shadow
    private Visibility chunkStatus;
    @Unique
    private final ReferenceOpenHashSet<SectionedEntityMovementTracker<?>> sectionVisibilityListeners = new ReferenceOpenHashSet(0);
    @Unique
    private final ArrayList<SectionedEntityMovementTracker<?>>[] entityMovementListenersByType = new ArrayList[MovementTrackerHelper.NUM_MOVEMENT_NOTIFYING_CLASSES];
    @Unique
    private final long[] lastEntityMovementByType = new long[MovementTrackerHelper.NUM_MOVEMENT_NOTIFYING_CLASSES];

    @Shadow
    public abstract boolean isEmpty();

    @Override
    public void lithium$addListener(SectionedEntityMovementTracker<?> listener) {
        this.sectionVisibilityListeners.add(listener);
        if (this.chunkStatus.isAccessible()) {
            listener.onSectionEnteredRange(this);
        }
    }

    @Override
    public void lithium$removeListener(EntitySectionStorage<?> sectionedEntityCache, SectionedEntityMovementTracker<?> listener) {
        boolean removed = this.sectionVisibilityListeners.remove(listener);
        if (this.chunkStatus.isAccessible() && removed) {
            listener.onSectionLeftRange(this);
        }
        if (this.isEmpty()) {
            sectionedEntityCache.remove(this.lithium$getPos());
        }
    }

    @Override
    public void lithium$trackEntityMovement(int notificationMask, long time) {
        long[] lastEntityMovementByType = this.lastEntityMovementByType;
        int size = lastEntityMovementByType.length;
        int entityClassIndex = Integer.numberOfTrailingZeros(notificationMask);
        while (entityClassIndex < size) {
            lastEntityMovementByType[entityClassIndex] = time;
            ArrayList<SectionedEntityMovementTracker<?>> entityMovementListeners = this.entityMovementListenersByType[entityClassIndex];
            if (entityMovementListeners != null) {
                for (int listIndex = entityMovementListeners.size() - 1; listIndex >= 0; --listIndex) {
                    SectionedEntityMovementTracker<?> sectionedEntityMovementTracker = entityMovementListeners.remove(listIndex);
                    sectionedEntityMovementTracker.emitEntityMovement(notificationMask, this);
                }
            }
            int mask = -2 << entityClassIndex;
            entityClassIndex = Integer.numberOfTrailingZeros(notificationMask & mask);
        }
    }

    @Override
    public long lithium$getChangeTime(int trackedClass) {
        return this.lastEntityMovementByType[trackedClass];
    }

    @ModifyReturnValue(method={"isEmpty()Z"}, at={@At(value="RETURN")})
    public boolean modifyIsEmpty(boolean previousIsEmpty) {
        return previousIsEmpty && this.sectionVisibilityListeners.isEmpty();
    }

    @ModifyVariable(method={"updateChunkStatus(Lnet/minecraft/world/level/entity/Visibility;)Lnet/minecraft/world/level/entity/Visibility;"}, at=@At(value="HEAD"), argsOnly=true)
    public Visibility swapStatus(Visibility newStatus) {
        block3: {
            block4: {
                if (this.chunkStatus.isAccessible() == newStatus.isAccessible()) break block3;
                if (newStatus.isAccessible()) break block4;
                if (this.sectionVisibilityListeners.isEmpty()) break block3;
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionLeftRange(this);
                }
                break block3;
            }
            if (!this.sectionVisibilityListeners.isEmpty()) {
                for (SectionedEntityMovementTracker listener : this.sectionVisibilityListeners) {
                    listener.onSectionEnteredRange(this);
                }
            }
        }
        return newStatus;
    }

    @Override
    public <S, E extends EntityAccess> void lithium$listenToMovementOnce(SectionedEntityMovementTracker<E> listener, int trackedClass) {
        if (this.entityMovementListenersByType[trackedClass] == null) {
            this.entityMovementListenersByType[trackedClass] = new ArrayList();
        }
        this.entityMovementListenersByType[trackedClass].add(listener);
    }

    @Override
    public <S, E extends EntityAccess> void lithium$removeListenToMovementOnce(SectionedEntityMovementTracker<E> listener, int trackedClass) {
        if (this.entityMovementListenersByType[trackedClass] != null) {
            this.entityMovementListenersByType[trackedClass].remove(listener);
        }
    }
}

