/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.proxy;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.IResettable;
import fr.rakambda.fallingtree.common.config.ITreeConfiguration;
import fr.rakambda.fallingtree.common.config.enums.AdjacentStopMode;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.config.enums.BreakOrder;
import fr.rakambda.fallingtree.common.config.enums.DetectionMode;
import fr.rakambda.fallingtree.common.config.enums.MaxSizeAction;
import fr.rakambda.fallingtree.common.wrapper.IBlock;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.NonNull;

public class TreeProxyConfiguration
implements ITreeConfiguration,
IResettable {
    private final ITreeConfiguration delegate;
    private BreakMode breakMode;

    @Override
    public void reset() {
        this.breakMode = null;
    }

    @Override
    public @NonNull Collection<IBlock> getAllowedNonDecayLeaveBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedNonDecayLeaveBlocks(mod);
    }

    @Override
    public @NonNull Collection<IBlock> getDeniedLeaveBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getDeniedLeaveBlocks(mod);
    }

    @Override
    public @NonNull Collection<IBlock> getDeniedLogBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getDeniedLogBlocks(mod);
    }

    @Override
    public @NonNull Collection<IBlock> getAllowedLeaveBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedLeaveBlocks(mod);
    }

    @Override
    public @NonNull Collection<IBlock> getAllowedLogBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedLogBlocks(mod);
    }

    @Override
    public @NonNull Collection<IBlock> getAllowedAdjacentBlockBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllowedAdjacentBlockBlocks(mod);
    }

    @Override
    public @NonNull Collection<IBlock> getDefaultLogsBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getDefaultLogsBlocks(mod);
    }

    @Override
    public @NonNull Collection<IBlock> getAllAllowedAdjacentBlockBlocks(@NonNull FallingTreeCommon<?> mod) {
        return this.delegate.getAllAllowedAdjacentBlockBlocks(mod);
    }

    @Override
    public @NonNull BreakMode getBreakMode() {
        return Optional.ofNullable(this.breakMode).orElseGet(this.delegate::getBreakMode);
    }

    @Override
    public @NonNull DetectionMode getDetectionMode() {
        return this.delegate.getDetectionMode();
    }

    @Override
    public @NonNull Map<String, DetectionMode> getDetectionModeBiomeOverride() {
        return this.delegate.getDetectionModeBiomeOverride();
    }

    @Override
    public int getMaxScanSize() {
        return this.delegate.getMaxScanSize();
    }

    @Override
    public int getMinSize() {
        return this.delegate.getMinSize();
    }

    @Override
    public int getMaxSize() {
        return this.delegate.getMaxSize();
    }

    @Override
    public int getMaxLeafDistanceFromLog() {
        return this.delegate.getMaxLeafDistanceFromLog();
    }

    @Override
    public @NonNull MaxSizeAction getMaxSizeAction() {
        return this.delegate.getMaxSizeAction();
    }

    @Override
    public @NonNull BreakOrder getBreakOrder() {
        return this.delegate.getBreakOrder();
    }

    @Override
    public int getMinimumLeavesAroundRequired() {
        return this.delegate.getMinimumLeavesAroundRequired();
    }

    @Override
    public boolean isIncludePersistentLeavesInRequiredCount() {
        return this.delegate.isIncludePersistentLeavesInRequiredCount();
    }

    @Override
    public boolean isTreeBreaking() {
        return this.delegate.isTreeBreaking();
    }

    @Override
    public boolean isLeavesBreaking() {
        return this.delegate.isLeavesBreaking();
    }

    @Override
    public int getLeavesBreakingForceRadius() {
        return this.delegate.getLeavesBreakingForceRadius();
    }

    @Override
    public boolean isAllowMixedLogs() {
        return this.delegate.isAllowMixedLogs();
    }

    @Override
    public boolean isBreakNetherTreeWarts() {
        return this.delegate.isBreakNetherTreeWarts();
    }

    @Override
    public boolean isBreakMangroveRoots() {
        return this.delegate.isBreakMangroveRoots();
    }

    @Override
    public int getSearchAreaRadius() {
        return this.delegate.getSearchAreaRadius();
    }

    @Override
    public @NonNull AdjacentStopMode getAdjacentStopMode() {
        return this.delegate.getAdjacentStopMode();
    }

    @Override
    public boolean isSpawnItemsAtBreakPoint() {
        return this.delegate.isSpawnItemsAtBreakPoint();
    }

    @Override
    public float getTrunkLootPercentage() {
        return this.delegate.getTrunkLootPercentage();
    }

    @Generated
    public TreeProxyConfiguration(ITreeConfiguration delegate) {
        this.delegate = delegate;
    }

    @Generated
    public void setBreakMode(BreakMode breakMode) {
        this.breakMode = breakMode;
    }
}

