/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.tree;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.config.enums.BreakMode;
import fr.rakambda.fallingtree.common.tree.AbortedResult;
import fr.rakambda.fallingtree.common.tree.IBreakAttemptResult;
import fr.rakambda.fallingtree.common.tree.Tree;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooBigException;
import fr.rakambda.fallingtree.common.tree.breaking.BreakTreeTooSmallException;
import fr.rakambda.fallingtree.common.tree.breaking.FallingAnimationTreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ITreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.InstantaneousTreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.breaking.ShiftDownTreeBreakingHandler;
import fr.rakambda.fallingtree.common.tree.builder.TreeTooBigException;
import fr.rakambda.fallingtree.common.utils.CacheSpeed;
import fr.rakambda.fallingtree.common.wrapper.IBlockEntity;
import fr.rakambda.fallingtree.common.wrapper.IBlockPos;
import fr.rakambda.fallingtree.common.wrapper.IBlockState;
import fr.rakambda.fallingtree.common.wrapper.IItemStack;
import fr.rakambda.fallingtree.common.wrapper.ILevel;
import fr.rakambda.fallingtree.common.wrapper.IPlayer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TreeHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(TreeHandler.class);
    private final @NonNull FallingTreeCommon<?> mod;
    private final Map<UUID, CacheSpeed> speedCache = new ConcurrentHashMap<UUID, CacheSpeed>();

    public boolean shouldCancelEvent(@NonNull ILevel level, @NonNull IPlayer player, @NonNull IBlockPos originPos, @NonNull IBlockState originState, @Nullable IBlockEntity originEntity) {
        if (!this.mod.isPlayerInRightState(player)) {
            return false;
        }
        if (this.shouldPreserveTool(player)) {
            return true;
        }
        try {
            this.mod.getTreeBuilder().getTree(player, level, originPos, originState, originEntity).isEmpty();
        }
        catch (TreeTooBigException e) {
            return false;
        }
        return false;
    }

    private boolean shouldPreserveTool(@NonNull IPlayer player) {
        IItemStack handItem = player.getMainHandItem();
        return this.mod.getConfiguration().getTools().getDurabilityMode().shouldPreserve(handItem.getDurability());
    }

    public @NonNull IBreakAttemptResult breakTree(boolean isCancellable, @NonNull ILevel level, @NonNull IPlayer player, @NonNull IBlockPos originPos, @NonNull IBlockState originState, @Nullable IBlockEntity originEntity) {
        if (!level.isServer()) {
            return AbortedResult.NOT_SERVER;
        }
        if (!this.mod.getConfiguration().getTrees().isTreeBreaking()) {
            return AbortedResult.NOT_ENABLED;
        }
        if (!this.mod.checkForceToolUsage(player, level, originPos)) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.force_tool_usage", this.mod.getConfiguration().getTrees().getMaxScanSize()));
            return AbortedResult.REQUIRED_TOOL_ABSENT;
        }
        if (!this.mod.isPlayerInRightState(player)) {
            return AbortedResult.INVALID_PLAYER_STATE;
        }
        try {
            Optional<Tree> treeOptional = this.mod.getTreeBuilder().getTree(player, level, originPos, originState, originEntity);
            if (treeOptional.isEmpty()) {
                return AbortedResult.NO_SUCH_TREE;
            }
            Tree tree = treeOptional.get();
            BreakMode breakMode = this.getBreakMode(player.getMainHandItem());
            return this.getBreakingHandler(breakMode).breakTree(isCancellable, player, tree);
        }
        catch (TreeTooBigException e) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.tree_too_big", this.mod.getConfiguration().getTrees().getMaxScanSize()));
            return AbortedResult.TREE_TOO_BIG_SCAN;
        }
        catch (BreakTreeTooSmallException e) {
            return AbortedResult.TREE_TOO_SMALL_BREAK;
        }
        catch (BreakTreeTooBigException e) {
            this.mod.notifyPlayer(player, this.mod.translate("chat.fallingtree.break_tree_too_big", this.mod.getConfiguration().getTrees().getMaxSize()));
            return AbortedResult.TREE_TOO_BIG_BREAK;
        }
    }

    private @NonNull BreakMode getBreakMode(@NonNull IItemStack itemStack) {
        return itemStack.getBreakModeFromEnchant().orElseGet(() -> this.mod.getConfiguration().getTrees().getBreakMode());
    }

    private @NonNull ITreeBreakingHandler getBreakingHandler(@NonNull BreakMode breakMode) {
        return switch (breakMode) {
            default -> throw new MatchException(null, null);
            case BreakMode.INSTANTANEOUS -> InstantaneousTreeBreakingHandler.getInstance(this.mod);
            case BreakMode.FALL_ITEM -> FallingAnimationTreeBreakingHandler.getInstance(this.mod, true, true);
            case BreakMode.FALL_BLOCK -> FallingAnimationTreeBreakingHandler.getInstance(this.mod, false, true);
            case BreakMode.FALL_ALL_BLOCK -> FallingAnimationTreeBreakingHandler.getInstance(this.mod, false, false);
            case BreakMode.SHIFT_DOWN -> ShiftDownTreeBreakingHandler.getInstance(this.mod);
        };
    }

    public @NonNull Optional<Float> getBreakSpeed(@NonNull IPlayer player, @NonNull IBlockPos blockPos, @NonNull IBlockState blockState, float originalSpeed) {
        if (!this.mod.getConfiguration().getTrees().isTreeBreaking()) {
            return Optional.empty();
        }
        if (!this.getBreakMode(player.getMainHandItem()).isApplySpeedMultiplier()) {
            return Optional.empty();
        }
        if (!this.mod.isPlayerInRightState(player)) {
            return Optional.empty();
        }
        CacheSpeed cacheSpeed = this.speedCache.compute(player.getUUID(), (uuid, speed) -> {
            if (Objects.isNull(speed) || !speed.isValid(blockPos)) {
                speed = this.getSpeed(player, blockPos, blockState, originalSpeed);
            }
            return speed;
        });
        return Optional.ofNullable(cacheSpeed).map(CacheSpeed::getSpeed);
    }

    private @Nullable CacheSpeed getSpeed(@NonNull IPlayer player, @NonNull IBlockPos pos, @NonNull IBlockState blockState, float originalSpeed) {
        double speedMultiplicand = this.mod.getConfiguration().getTools().getSpeedMultiplicand();
        try {
            return speedMultiplicand <= 0.0 ? null : (CacheSpeed)this.mod.getTreeBuilder().getTree(player, player.getLevel(), pos, blockState, null).map(tree -> new CacheSpeed(pos, originalSpeed / ((float)speedMultiplicand * (float)tree.getLogCount()))).orElse(null);
        }
        catch (TreeTooBigException e) {
            return null;
        }
    }

    @Generated
    public TreeHandler(@NonNull FallingTreeCommon<?> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

