/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Map;
import java.util.UUID;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureCache;
import journeymap.common.accessors.NativeImageAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayerResolver;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.Identifier;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.component.ResolvableProfile;

public class IgnSkin {
    public static Identifier DEFAULT_SKIN = Identifier.fromNamespaceAndPath((String)"journeymap", (String)"skin/default");
    public static final Map<UUID, DynamicTexture> faceImageCache = Maps.newHashMap();
    public static final Map<UUID, NativeImage> nativeImageCache = Maps.newHashMap();

    public static DynamicTexture getFace(GameProfile profile) {
        DynamicTexture face = faceImageCache.get(profile.id());
        if (face == null) {
            NativeImage nativeImage = nativeImageCache.get(profile.id());
            if (nativeImage == null) {
                Minecraft mc = Minecraft.getInstance();
                ResolvableProfile resolver = ResolvableProfile.createResolved((GameProfile)profile);
                LocalPlayerResolver profileresolver = new LocalPlayerResolver(mc, mc.services().profileResolver());
                resolver.resolveProfile((ProfileResolver)profileresolver).thenAccept(gameProfile -> nativeImageCache.put(profile.id(), IgnSkin.getSkin(gameProfile)));
                return null;
            }
            face = new DynamicTexture(() -> profile.name().toLowerCase(), nativeImage);
            faceImageCache.put(profile.id(), face);
        }
        return face;
    }

    private static NativeImage getSkin(GameProfile profile) {
        try {
            DynamicTexture tex;
            TextureManager textureManager;
            AbstractTexture texture;
            PlayerSkinRenderCache.RenderInfo renderInfo = Minecraft.getInstance().playerSkinRenderCache().getOrDefault(ResolvableProfile.createUnresolved((UUID)profile.id()));
            PlayerSkin skin = renderInfo.playerSkin();
            if (skin != null && (texture = (textureManager = Minecraft.getInstance().getTextureManager()).getTexture(skin.body().texturePath())) != null && texture instanceof DynamicTexture && (tex = (DynamicTexture)texture).getPixels() != null) {
                return IgnSkin.cropToFace(tex.getPixels());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Identifier getDefault() {
        try {
            AbstractTexture texture;
            AbstractTexture skin = TextureCache.getTexture(DEFAULT_SKIN);
            if (skin == null && (texture = TextureCache.getTexture(Identifier.withDefaultNamespace((String)"textures/entity/player/wide/steve.png"))) != null && texture instanceof DynamicTexture) {
                DynamicTexture tex = (DynamicTexture)texture;
                skin = new DynamicTexture(() -> "default", IgnSkin.cropToFace(tex.getPixels()));
                Minecraft.getInstance().getTextureManager().register(DEFAULT_SKIN, skin);
            }
        }
        catch (Throwable t) {
            Minecraft.getInstance().getTextureManager().register(DEFAULT_SKIN, (AbstractTexture)new DynamicTexture(() -> "blank", ImageUtil.getNewBlankImage(24, 24)));
        }
        return DEFAULT_SKIN;
    }

    public static NativeImage cropToFace(NativeImage playerSkin) {
        NativeImage skin = new NativeImage(playerSkin.getWidth(), playerSkin.getHeight(), false);
        skin.copyFrom(playerSkin);
        if (skin != null && skin.pixels != 0L) {
            if (skin.format().hasAlpha()) {
                NativeImage hat = ImageUtil.getSubImage(40, 8, 8, 8, skin, false);
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        int hatPixel = hat.getPixel(x, y);
                        ((NativeImageAccess)skin).blendPixelRGBA(x + 8, y + 8, hatPixel);
                    }
                }
                hat.close();
            }
            NativeImage sub = ImageUtil.getSubImage(8, 8, 8, 8, skin, false);
            return ImageUtil.getSizedImage(24, 24, sub, false);
        }
        return ImageUtil.getNewBlankImage(24, 24);
    }
}

