/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.buttons;

import journeymap.client.cartography.color.RGB;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Nullable;

public class BasicImageButton
extends Button {
    protected final WidgetSprites sprites;
    protected int color = -1;
    protected int texHeight;
    protected int texWidth;
    protected int yOffset = 0;
    protected int xOffset = 0;
    private static final WidgetSprites SPRITES = new WidgetSprites(Identifier.withDefaultNamespace((String)"widget/button"), Identifier.withDefaultNamespace((String)"widget/button_disabled"), Identifier.withDefaultNamespace((String)"widget/button_highlighted"));

    public BasicImageButton(int x, int y, int width, int height, WidgetSprites sprites, Button.OnPress onPress) {
        this(x, y, width, height, sprites, null, onPress, CommonComponents.EMPTY);
    }

    public BasicImageButton(int x, int y, int width, int height, WidgetSprites sprites, Button.OnPress onPress, Component message) {
        this(x, y, width, height, sprites, null, onPress, message);
    }

    public BasicImageButton(int x, int y, int width, int height, WidgetSprites sprites, @Nullable Integer color, Button.OnPress onPress, Component message) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        if (color != null) {
            this.color = RGB.toInteger(RGB.floats(color, 255.0f));
        }
        this.sprites = sprites;
        this.texHeight = height;
        this.texWidth = width;
    }

    public BasicImageButton(int width, int height, WidgetSprites sprites, @Nullable Integer color, Button.OnPress onPress, Component message) {
        this(0, 0, width, height, sprites, color, onPress, message);
    }

    public BasicImageButton(int width, int height, WidgetSprites sprites, Button.OnPress onPress, Component message) {
        this(0, 0, width, height, sprites, null, onPress, message);
    }

    public BasicImageButton(int width, int height, WidgetSprites sprites, Button.OnPress onPress) {
        this(0, 0, width, height, sprites, null, onPress, (Component)Component.empty());
    }

    public BasicImageButton setYOffset(int yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public BasicImageButton setXOffset(int xOffset) {
        this.xOffset = xOffset;
        return this;
    }

    public BasicImageButton setTexHeight(int texHeight) {
        this.texHeight = texHeight;
        return this;
    }

    public BasicImageButton setTexWidth(int texWidth) {
        this.texWidth = texWidth;
        return this;
    }

    public BasicImageButton setColor(int color) {
        this.color = color;
        return this;
    }

    public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderDefaultSprite(graphics);
        Identifier identifier = this.sprites.get(this.isActive(), this.isHoveredOrFocused());
        graphics.blit(RenderPipelines.GUI_TEXTURED, identifier, this.getX() + this.xOffset, this.getY() + this.yOffset, 0.0f, 0.0f, this.texWidth, this.texHeight, this.texWidth, this.texHeight, RGB.toArgb(this.color, 1.0f));
    }

    public void renderScrollingStringOverContents(ActiveTextCollector activeTextCollector, Component component, int i) {
    }
}

