/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.dropdown.SelectableParent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;

public class DropDownItem
extends Button {
    private Object id;
    private String label;
    private SelectableParent parent;
    private Button.OnPress onPress;
    private boolean autoClose = true;

    public DropDownItem(SelectableParent parent, Object id, String label, Button.OnPress onPress, String ... toolTip) {
        this(parent, id, label, onPress);
        this.setTooltip(toolTip);
    }

    public DropDownItem(SelectableParent parent, Object id, String label, Button.OnPress onPress) {
        super(label);
        this.onPress = onPress;
        this.label = label;
        this.id = id;
        this.parent = parent;
        this.setTextOnly(this.fontRenderer);
    }

    public DropDownItem(SelectableParent parent, Object id, String label, String ... toolTip) {
        this(parent, id, label);
        this.setTooltip(toolTip);
    }

    public DropDownItem(SelectableParent parent, Object id, String label) {
        super(label);
        this.label = label;
        this.id = id;
        this.parent = parent;
        this.setTextOnly(this.fontRenderer);
    }

    public DropDownItem(SelectableParent parent, Object id, boolean autoClose, String label, Button.OnPress onPress) {
        this(parent, id, label, onPress);
        this.autoClose = autoClose;
    }

    public void press() {
        this.onPress.onPress((net.minecraft.client.gui.components.Button)this);
    }

    @Override
    public void renderSpecialDecoration(GuiGraphics graphics, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (!this.autoClose) {
            DrawUtil.drawCenteredLabel(graphics, (Component)Component.literal((String)">"), x + width - 10, this.getMiddleY(), null, 0.0f, this.varLabelColor, 1.0f, 1.0, this.drawLabelShadow);
        }
    }

    public Object getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public boolean isAutoClose() {
        return this.autoClose;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.isHovered()) {
            return true;
        }
        return super.mouseClicked(event, doubleClick);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY);
    }

    public void select() {
        this.parent.setSelected(this);
    }

    @Override
    public boolean isHovered() {
        return super.isHovered();
    }
}

