/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.dropdown;

import java.util.List;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.screens.ScrollPaneScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;

public class PopupMenu
extends ScrollPaneScreen
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    protected int mouseX;
    protected int mouseY;
    protected final Screen parent;
    protected DropDownItem selected;
    protected boolean pass = false;
    protected boolean isSub = false;
    protected boolean mouseOver = false;

    public PopupMenu(PopupMenu parent) {
        this((Screen)parent);
        this.isSub = true;
    }

    public PopupMenu(Screen parent) {
        super(null, null, 0, 0, 0, 0);
        this.parent = parent;
        this.setParent(this);
    }

    public void display(List<DropDownItem> items) {
        if (!this.pass) {
            for (DropDownItem item : items) {
                item.setHorizontalAlignment(DrawUtil.HAlign.Right);
            }
            this.pass = true;
            this.setRenderDecorations(false);
            this.setRenderSolidBackground(true);
            this.setItems(items);
            this.setPaneWidth(this.getPaneWidth(items));
            this.setPaneHeight(this.getPaneHeight(items));
            this.setPointsInScreenBounds();
            super.display();
        }
    }

    private void setPointsInScreenBounds() {
        int x;
        boolean inBoundsY;
        int screenWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int screenHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        boolean inBoundsX = this.mouseX + this.getPaneWidth() < screenWidth;
        boolean bl = inBoundsY = this.mouseY + this.getPaneHeight() < screenHeight;
        if (this.parent instanceof PopupMenu) {
            int width = this.scrollPane != null ? this.getPaneWidth() : this.getPaneWidth() - 6;
            x = inBoundsX ? this.mouseX : ((PopupMenu)this.parent).getPaneX() - width;
        } else {
            x = inBoundsX ? this.mouseX : screenWidth - this.getPaneWidth() - 4;
        }
        int y = inBoundsY ? this.mouseY : screenHeight - this.getPaneHeight() - 2;
        this.mouseX = x;
        this.mouseY = y;
        this.setPaneX(x);
        this.setPaneY(y);
    }

    public void resetPass() {
        this.pass = false;
    }

    @Override
    public void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.mouseOver = this.mouseOverPane(mouseX, mouseY);
        int x = (int)(Minecraft.getInstance().mouseHandler.xpos() * (double)Minecraft.getInstance().getWindow().getGuiScaledWidth() / (double)Minecraft.getInstance().getWindow().getScreenWidth());
        int y = (int)(Minecraft.getInstance().mouseHandler.ypos() * (double)Minecraft.getInstance().getWindow().getGuiScaledHeight() / (double)Minecraft.getInstance().getWindow().getScreenHeight());
        super.renderPopupScreen(graphics, x, y, partialTicks);
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        boolean clicked = super.mouseClicked(event, doubleClick);
        if (!clicked && !this.mouseOverPane(event.x(), event.y())) {
            this.resetPass();
            return this.parent.mouseClicked(event, doubleClick);
        }
        return clicked;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (!this.mouseOverPane(mouseX, mouseY)) {
            this.parent.mouseMoved(mouseX, mouseY);
        }
        super.mouseMoved(mouseX, mouseY);
    }

    private int getPaneHeight(List<DropDownItem> items) {
        int size = Math.min(items.size(), 6);
        return size * (items.get(0).getHeight() + (size == 1 ? 7 : 5));
    }

    private int getPaneWidth(List<DropDownItem> items) {
        int width = 0;
        if (items != null) {
            Font fontRenderer = Minecraft.getInstance().font;
            for (DropDownItem item : items) {
                width = Math.max(width, fontRenderer.width(item.getLabel()));
            }
            this.width = width + 40;
        }
        return this.width;
    }

    public void setClickLoc(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    @Override
    public void setSelected(DropDownItem button) {
        this.selected = button;
    }

    public void closeStack() {
        this.visible = false;
        this.popLayer();
        if (this.parent instanceof PopupMenu) {
            ((PopupMenu)this.parent).closeStack();
        }
    }

    @Override
    public void onClick(DropDownItem pressed) {
        pressed.select();
        if (pressed.isAutoClose()) {
            this.closeStack();
        }
        this.removable.onRemove();
    }

    @Override
    public void onRemove() {
        if (this.selected != null) {
            this.selected.press();
            this.selected = null;
        }
    }

    @Override
    public boolean isPauseScreen() {
        return this.parent.isPauseScreen();
    }
}

