/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.widgets;

import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;

public class ColoredStringWidget
extends StringWidget {
    protected float alignX = 0.5f;
    protected boolean shadow = true;
    protected boolean scrolling = false;
    protected int color = 0xFFFFFF;
    protected StringWidget.TextOverflow textOverflow = StringWidget.TextOverflow.CLAMPED;

    public ColoredStringWidget(Component message, Font font) {
        this(message, font.width(message.getVisualOrderText()), font);
    }

    public ColoredStringWidget(Component message, int width, Font font) {
        this(0, 0, width, 9, message, font);
    }

    public ColoredStringWidget(int width, int height, Component message, Font font) {
        this(0, 0, width, height, message, font);
    }

    public ColoredStringWidget(int x, int y, int width, int height, Component message, Font font) {
        super(x, y, width, height, message, font);
        this.active = false;
    }

    public ColoredStringWidget setColor(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    private ColoredStringWidget horizontalAlignment(float horizontalAlignment) {
        this.alignX = horizontalAlignment;
        return this;
    }

    public ColoredStringWidget scrolling() {
        this.scrolling = true;
        return this;
    }

    public ColoredStringWidget noShadow() {
        this.shadow = false;
        return this;
    }

    public ColoredStringWidget alignLeft() {
        return this.horizontalAlignment(0.0f);
    }

    public ColoredStringWidget alignCenter() {
        return this.horizontalAlignment(0.5f);
    }

    public ColoredStringWidget alignRight() {
        return this.horizontalAlignment(1.0f);
    }

    public void visitLines(ActiveTextCollector textCollector) {
        Component component = this.getMessage();
        if (this.color != 0xFFFFFF) {
            component.copy().getStyle().withColor(TextColor.fromRgb((int)this.color));
        }
        Font font = this.getFont();
        int width = this.getWidth();
        int fontWidth = font.width((FormattedText)component);
        int y = this.getY() + (this.getHeight() - 9) / 2;
        int x = this.getX() + Math.round(this.alignX * (float)(width - fontWidth));
        if (this.scrolling && fontWidth > x + width && this.isHovered()) {
            switch (this.textOverflow) {
                case CLAMPED: {
                    textCollector.accept(x, y, ColoredStringWidget.clipText((Component)component, (Font)font, (int)width));
                    break;
                }
                case SCROLLING: {
                    this.renderScrollingStringOverContents(textCollector, component, 2);
                }
            }
        } else {
            textCollector.accept(x, y, component.getVisualOrderText());
        }
    }

    public StringWidget setMaxWidth(int maxWidth, StringWidget.TextOverflow textOverflow) {
        this.textOverflow = textOverflow;
        return super.setMaxWidth(maxWidth, textOverflow);
    }
}

