/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;

public class MapChat
extends ChatScreen {
    protected boolean hidden = false;
    protected int cursorCounter;

    public MapChat(String defaultText, boolean hidden) {
        super(defaultText, false);
        this.hidden = hidden;
    }

    public void removed() {
        super.removed();
        this.hidden = true;
    }

    public void close() {
        this.removed();
    }

    public void tick() {
        if (this.hidden) {
            return;
        }
        super.tick();
    }

    public boolean charTyped(CharacterEvent event) {
        int keyCode = event.codepoint();
        if (this.hidden) {
            return false;
        }
        if (keyCode == 256) {
            this.close();
            return true;
        }
        if (keyCode != 257 && keyCode != 335) {
            return super.charTyped(event);
        }
        String s = this.input.getValue().trim();
        if (!s.isEmpty()) {
            this.handleChatInput(s, true);
        }
        this.input.setValue("");
        Minecraft.getInstance().gui.getChat().resetChatScroll();
        return true;
    }

    public boolean keyPressed(KeyEvent event) {
        int key = event.key();
        if (key == 257 || key == 335) {
            String s = this.input.getValue().trim();
            if (!s.isEmpty()) {
                this.handleChatInput(s, true);
            }
            this.input.setValue("");
            Minecraft.getInstance().gui.getChat().resetChatScroll();
            this.close();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.hidden) {
            return false;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hidden) {
            return;
        }
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setText(String defaultText) {
        this.input.setValue(defaultText);
    }
}

