/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.event;

import com.mojang.brigadier.CommandDispatcher;
import journeymap.api.services.Services;
import journeymap.common.command.CreateWaypoint;
import journeymap.common.events.ServerEventHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.PermissionsChangedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class NeoForgeServerEvents {
    private final ServerEventHandler handler = new ServerEventHandler();

    @SubscribeEvent
    public void onPermissionChangedEvent(PermissionsChangedEvent event) {
        if (event.getEntity() instanceof ServerPlayer && event.getNewLevel() != event.getOldLevel()) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            MinecraftServer server = player.level().getServer();
            NameAndId profile = player.nameAndId();
            ServerOpList ops = server.getPlayerList().getOps();
            if (event.getNewLevel().level().isEqualOrHigherThan(server.operatorUserPermissions().level())) {
                ops.add(new ServerOpListEntry(profile, server.operatorUserPermissions(), ops.canBypassPlayerLimit(profile)));
            } else if (event.getNewLevel().level().id() == 0) {
                ops.remove(profile);
            }
            this.handler.sendConfigsToPlayer(player);
        }
    }

    @SubscribeEvent
    public void onServerTickEvent(ServerTickEvent.Pre event) {
        if (Services.COMMON_SERVICE.getServer() == null || Services.COMMON_SERVICE.getServer() != null && Services.COMMON_SERVICE.getServer().getPlayerList().getPlayers().size() <= 1) {
            return;
        }
        ServerLevel world = Services.COMMON_SERVICE.getServer().getLevel(Level.OVERWORLD);
        this.handler.onServerTickEvent((Level)world);
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.handler.onEntityJoinWorldEvent(event.getEntity());
        }
    }

    @SubscribeEvent
    public void onEntityLeaveWorldEvent(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                this.handler.unloadPlayer((Entity)player, level);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            this.handler.onPlayerLoggedInEvent(event.getEntity());
        }
    }

    @SubscribeEvent
    public void registerCommandEvent(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CreateWaypoint.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }
}

