/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helper;

import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraft.world.level.biome.Biome;

public class BiomeHelper {
    public static Biome getBiomeFromResource(Identifier biome) {
        Minecraft mc = Minecraft.getInstance();
        return (Biome)((Holder.Reference)mc.level.registryAccess().lookupOrThrow(Registries.BIOME).get(biome).get()).value();
    }

    public static Biome getBiomeFromResourceString(String biome) {
        Identifier biomeResource = Identifier.parse((String)biome);
        return BiomeHelper.getBiomeFromResource(biomeResource);
    }

    public static String getTranslatedBiomeName(Biome biome) {
        Identifier biomeResource = BiomeHelper.getBiomeResource(biome);
        return BiomeHelper.getTranslatedBiomeName(biomeResource);
    }

    public static Identifier getBiomeResource(Biome biome) {
        Minecraft mc = Minecraft.getInstance();
        return mc.level.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)biome);
    }

    public static String getTranslatedBiomeName(Identifier biomeResource) {
        String biomeName = Component.translatable((String)Util.makeDescriptionId((String)"biome", (Identifier)biomeResource)).getString();
        if (biomeName.contains("unregistered_sadface") || biomeName.startsWith("biome.")) {
            biomeName = biomeResource.getPath();
        }
        return biomeName;
    }
}

