/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.helpers;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.stream.Collectors;
import journeymap.api.services.ClientPlatformService;
import journeymap.client.event.handlers.KeyEventHandler;
import journeymap.client.event.handlers.keymapping.KeyConflictContext;
import journeymap.client.event.handlers.keymapping.KeyModifier;
import journeymap.client.event.handlers.keymapping.UpdateAwareKeyBinding;
import journeymap.client.event.keymapping.NeoForgeUpdateAwareKeyBinding;
import journeymap.client.model.block.BlockMD;
import journeymap.client.world.JmBlockAccess;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class NeoForgeClientHooks
implements ClientPlatformService {
    @Override
    public TextureAtlasSprite getTextureAtlasSprite(BlockMD blockMD) {
        FlowingFluid fluidBlock = ((LiquidBlock)blockMD.getBlock()).fluid;
        Identifier loc = IClientFluidTypeExtensions.of((FluidType)fluidBlock.getFluidType()).getStillTexture();
        return FluidSpriteCache.getSprite((Identifier)loc);
    }

    @Override
    public List<BakedQuad> getQuads(BlockStateModel model, @Nullable BlockState blockState, @Nullable Direction facing, @Nullable BlockPos blockPos, ChunkSectionLayer type) {
        return model.collectParts((BlockAndTintGetter)JmBlockAccess.INSTANCE, blockPos, blockState, RandomSource.create()).stream().flatMap(qm -> qm.getQuads(facing).stream()).collect(Collectors.toList());
    }

    @Override
    public int getFluidTint(BlockMD blockMD) {
        FlowingFluid fluidBlock = ((LiquidBlock)blockMD.getBlock()).fluid;
        if (Fluids.FLOWING_WATER.equals(fluidBlock) || Fluids.WATER.equals(fluidBlock)) {
            return 4159204;
        }
        return IClientFluidTypeExtensions.of((FluidType)fluidBlock.getFluidType()).getTintColor();
    }

    @Override
    public UpdateAwareKeyBinding getKeyBinding(String description, KeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Type inputType, int keyCode, KeyMapping.Category category, KeyEventHandler handler) {
        return new NeoForgeUpdateAwareKeyBinding(description, keyConflictContext, keyModifier, InputConstants.Type.KEYSYM, keyCode, category, handler);
    }
}

