/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera;

import com.mojang.blaze3d.platform.NativeImage;
import de.maxhenkel.camera.ImageTools;
import de.maxhenkel.camera.net.MessageRequestImage;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class TextureCache {
    private Map<UUID, CameraTextureObject> clientImageCache = new HashMap<UUID, CameraTextureObject>();
    private Map<UUID, Identifier> clientResourceCache = new HashMap<UUID, Identifier>();
    private Map<UUID, Long> awaitingImages = new HashMap<UUID, Long>();
    public static TextureCache instance;

    public void addImage(UUID uuid, BufferedImage image) {
        if (this.awaitingImages.containsKey(uuid)) {
            this.awaitingImages.remove(uuid);
        }
        Identifier resourceLocation = Identifier.fromNamespaceAndPath((String)"camera", (String)("texures/camera/" + uuid.toString()));
        CameraTextureObject cameraTextureObject = new CameraTextureObject(() -> ((Identifier)resourceLocation).toString(), ImageTools.toNativeImage(image));
        this.clientImageCache.put(uuid, cameraTextureObject);
        this.clientResourceCache.put(uuid, resourceLocation);
        Minecraft.getInstance().getEntityRenderDispatcher().textureManager.register(resourceLocation, (AbstractTexture)cameraTextureObject);
    }

    public Identifier getImage(UUID uuid) {
        CameraTextureObject cameraTextureObject = this.clientImageCache.get(uuid);
        if (this.checkImage(uuid, cameraTextureObject)) {
            return null;
        }
        return this.clientResourceCache.get(uuid);
    }

    private boolean checkImage(UUID uuid, CameraTextureObject cameraTextureObject) {
        if (cameraTextureObject == null) {
            if (this.awaitingImages.containsKey(uuid) && this.awaitingImages.get(uuid) + 10000L > System.currentTimeMillis()) {
                return true;
            }
            this.awaitingImages.put(uuid, System.currentTimeMillis());
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new MessageRequestImage(uuid), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return false;
    }

    public NativeImage getNativeImage(UUID uuid) {
        CameraTextureObject cameraTextureObject = this.clientImageCache.get(uuid);
        if (this.checkImage(uuid, cameraTextureObject)) {
            return null;
        }
        return cameraTextureObject.getPixels();
    }

    public static TextureCache instance() {
        if (instance == null) {
            instance = new TextureCache();
        }
        return instance;
    }

    public static class CameraTextureObject
    extends DynamicTexture {
        public CameraTextureObject(Supplier<String> stringSupplier, NativeImage image) {
            super(stringSupplier, image);
        }
    }
}

