/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.camera.entities;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.maxhenkel.camera.TextureCache;
import de.maxhenkel.camera.entities.ImageEntity;
import de.maxhenkel.camera.entities.ImageEntityRenderState;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gizmos.GizmoStyle;
import net.minecraft.gizmos.Gizmos;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class ImageRenderer
extends EntityRenderer<ImageEntity, ImageEntityRenderState> {
    private static final Identifier DEFAULT_IMAGE = Identifier.fromNamespaceAndPath((String)"camera", (String)"textures/images/default_image.png");
    private static final Identifier EMPTY_IMAGE = Identifier.fromNamespaceAndPath((String)"camera", (String)"textures/images/empty_image.png");
    private static final Identifier FRAME_SIDE = Identifier.fromNamespaceAndPath((String)"camera", (String)"textures/images/frame_side.png");
    private static final Identifier FRAME_BACK = Identifier.fromNamespaceAndPath((String)"camera", (String)"textures/images/frame_back.png");
    private static final float THICKNESS = 0.0625f;
    public static final UUID DEFAULT_IMAGE_UUID = new UUID(0L, 0L);
    private static Minecraft mc;

    public ImageRenderer(EntityRendererProvider.Context context) {
        super(context);
        mc = Minecraft.getInstance();
    }

    public ImageEntityRenderState createRenderState() {
        return new ImageEntityRenderState();
    }

    public void submit(ImageEntityRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        super.submit((EntityRenderState)state, stack, collector, cameraRenderState);
        stack.pushPose();
        stack.translate(-0.5, 0.0, -0.5);
        ImageRenderer.submitImage(state.imageState, state.facing, state.frameWidth, state.frameHeight, state.light, stack, collector);
        stack.popPose();
        ImageRenderer.submitBoundingBox(state, stack, collector);
    }

    public static void submitImage(ImageEntityRenderState.ImageState imageState, Direction facing, float width, float height, int light, PoseStack stack, SubmitNodeCollector collector) {
        float ratioY;
        float ratioX;
        stack.pushPose();
        Identifier resourceLocation = imageState.resourceLocation();
        float imageRatio = imageState.imageRatio();
        boolean stretch = DEFAULT_IMAGE.equals((Object)resourceLocation);
        ImageRenderer.rotate(facing, stack);
        float frameRatio = width / height;
        float ratio = imageRatio / frameRatio;
        if (stretch) {
            ratioX = 0.0f;
            ratioY = 0.0f;
        } else if (ratio >= 1.0f) {
            ratioY = (1.0f - 1.0f / ratio) / 2.0f * height;
            ratioX = 0.0f;
        } else {
            ratioX = (1.0f - ratio) / 2.0f * width;
            ratioY = 0.0f;
        }
        collector.submitCustomGeometry(stack, RenderTypes.entityCutout((Identifier)resourceLocation), (pose, vertexConsumer) -> {
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, ratioY, 0.0625f, 0.0f, 1.0f, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, ratioY, 0.0625f, 1.0f, 1.0f, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, height - ratioY, 0.0625f, 1.0f, 0.0f, light);
            ImageRenderer.vertex(vertexConsumer, pose, ratioX, height - ratioY, 0.0625f, 0.0f, 0.0f, light);
        });
        collector.submitCustomGeometry(stack, RenderTypes.entityCutout((Identifier)FRAME_SIDE), (pose, vertexConsumer) -> {
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 1.0f, 0.0f + ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.9375f, 0.0f + ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, height - ratioY, 0.0625f, 0.9375f, 1.0f - ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, height - ratioY, 0.0f, 1.0f, 1.0f - ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, 0.0f + ratioY, 0.0f, 0.0f, 0.0f + ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, height - ratioY, 0.0f, 0.0f, 1.0f - ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, height - ratioY, 0.0625f, 0.0625f, 1.0f - ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, 0.0f + ratioY, 0.0625f, 0.0625f, 0.0f + ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, height - ratioY, 0.0625f, 0.0f + ratioX, 0.9375f, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, height - ratioY, 0.0625f, 1.0f - ratioX, 0.9375f, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, 0.0f + ratioY, 0.0625f, 1.0f - ratioX, 0.0625f, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, 0.0f + ratioY, 0.0625f, 0.0f + ratioX, 0.0625f, light);
        });
        collector.submitCustomGeometry(stack, RenderTypes.entityCutout((Identifier)FRAME_BACK), (pose, vertexConsumer) -> {
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, 0.0f + ratioY, 0.0f, 1.0f - ratioX, 0.0f + ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, 0.0f + ratioY, 0.0f, 0.0f + ratioX, 0.0f + ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, 0.0f + ratioX, height - ratioY, 0.0f, 0.0f + ratioX, 1.0f - ratioY, light);
            ImageRenderer.vertex(vertexConsumer, pose, width - ratioX, height - ratioY, 0.0f, 1.0f - ratioX, 1.0f - ratioY, light);
        });
        stack.popPose();
    }

    public void extractRenderState(ImageEntity image, ImageEntityRenderState state, float partialTicks) {
        super.extractRenderState((Entity)image, (EntityRenderState)state, partialTicks);
        state.imageEntityUUID = image.getUUID();
        state.frameWidth = image.getFrameWidth();
        state.frameHeight = image.getFrameHeight();
        state.facing = image.getFacing();
        state.imageState = ImageRenderer.extractImageState(image.getImageUUID().orElse(DEFAULT_IMAGE_UUID));
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)image.level(), (BlockPos)image.getCenterPosition());
        state.imageBoundingBox = image.getBoundingBox();
    }

    public static ImageEntityRenderState.ImageState extractImageState(@Nonnull UUID imageId) {
        float imageRatio;
        Identifier resourceLocation;
        if (DEFAULT_IMAGE_UUID.equals(imageId)) {
            resourceLocation = DEFAULT_IMAGE;
            imageRatio = 1.5f;
        } else {
            Identifier rl = TextureCache.instance().getImage(imageId);
            if (rl != null) {
                resourceLocation = rl;
                NativeImage nativeImage = TextureCache.instance().getNativeImage(imageId);
                imageRatio = (float)nativeImage.getWidth() / (float)nativeImage.getHeight();
            } else {
                resourceLocation = DEFAULT_IMAGE;
                imageRatio = 1.5f;
            }
        }
        return new ImageEntityRenderState.ImageState(imageId, imageRatio, resourceLocation);
    }

    private static void vertex(VertexConsumer builder, PoseStack.Pose pose, float x, float y, float z, float u, float v, int light) {
        builder.addVertex((Matrix4fc)pose.pose(), x, y, z).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
    }

    private static void submitBoundingBox(ImageEntityRenderState state, PoseStack stack, SubmitNodeCollector collector) {
        EntityHitResult entityHitResult;
        HitResult hitResult = ImageRenderer.mc.hitResult;
        if (!(hitResult instanceof EntityHitResult) || !(entityHitResult = (EntityHitResult)hitResult).getEntity().getUUID().equals(state.imageEntityUUID)) {
            return;
        }
        if (ImageRenderer.mc.options.hideGui) {
            return;
        }
        Gizmos.cuboid((AABB)state.imageBoundingBox, (GizmoStyle)GizmoStyle.stroke((int)ARGB.colorFromFloat((float)0.4f, (float)0.0f, (float)0.0f, (float)0.0f)), (boolean)false);
    }

    public static void rotate(Direction facing, PoseStack matrixStack) {
        switch (facing) {
            case NORTH: {
                matrixStack.translate(1.0, 0.0, 1.0);
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case SOUTH: {
                break;
            }
            case EAST: {
                matrixStack.translate(0.0, 0.0, 1.0);
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                matrixStack.translate(1.0, 0.0, 0.0);
                matrixStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            }
        }
    }
}

