/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.util.BlockBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;
import org.jspecify.annotations.Nullable;

public class ControllerBlock
extends BlockBase
implements ISneakItemInteractionBlock,
EntityBlock {
    public ControllerBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.STONE).requiresCorrectToolForDrops().strength(3.0f, 6.0f));
    }

    public @Nullable BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ControllerBlockEntity(pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (level.isClientSide()) {
            return;
        }
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ControllerBlockEntity.class).ifPresent(ControllerBlockEntityBase::searchAndAddBoundables);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ControllerBlockEntity.class).ifPresent(controller -> {
            AtomicBoolean appliedUpgrade = new AtomicBoolean(false);
            controller.getStoragePositions().forEach(storagePos -> WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)storagePos, StorageBlockEntity.class).ifPresent(be -> {
                Block patt0$temp = be.getBlockState().getBlock();
                if (patt0$temp instanceof StorageBlockBase) {
                    StorageBlockBase storageblock = (StorageBlockBase)patt0$temp;
                    if (storageblock.tryAddSingleUpgrade(player, (StorageBlockEntity)be, stack).consumesAction()) {
                        appliedUpgrade.set(true);
                    } else {
                        StorageTierUpgradeItem storageTierUpgradeItem;
                        Item patt1$temp = stack.getItem();
                        if (patt1$temp instanceof StorageTierUpgradeItem && (storageTierUpgradeItem = (StorageTierUpgradeItem)patt1$temp).tryUpgradeStorage(stack, level, (BlockPos)storagePos, be.getBlockState(), player).consumesAction()) {
                            appliedUpgrade.set(true);
                        }
                    }
                }
            }));
            if (!appliedUpgrade.get()) {
                controller.depositPlayerItems(player, hand);
            }
        });
        return InteractionResult.SUCCESS.heldItemTransformedTo(stack.isEmpty() ? ItemStack.EMPTY : stack);
    }

    @Override
    public boolean trySneakItemInteraction(Player player, InteractionHand hand, BlockState state, Level level, BlockPos pos, BlockHitResult hitVec, ItemStack itemInHand) {
        if (level.isClientSide()) {
            return false;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ControllerBlockEntity.class).map(controller -> {
            AtomicBoolean result = new AtomicBoolean(false);
            controller.getStoragePositions().forEach(storagePos -> {
                StorageBlockBase storageblock;
                Block block = level.getBlockState(storagePos).getBlock();
                if (block instanceof StorageBlockBase && (storageblock = (StorageBlockBase)block).tryFillUpgrades(player, hand, level, (BlockPos)storagePos, player.getItemInHand(hand))) {
                    result.set(true);
                }
            });
            return result.get();
        }).orElse(false);
    }
}

