/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllerBoundable;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ControllerBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jspecify.annotations.Nullable;

public class StorageIOBlockEntity
extends BlockEntity
implements IControllerBoundable,
ILinkable {
    private @Nullable BlockPos controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean chunkBeingUnloaded = false;
    private @Nullable BlockCapabilityCache<ResourceHandler<ItemResource>, Direction> controllerItemHandlerCache;

    protected StorageIOBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public StorageIOBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlocks.STORAGE_IO_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public Set<BlockPos> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.controllerItemHandlerCache = null;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void linkToController(BlockPos controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.setChanged();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.removeControllerPos();
        this.setChanged();
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.controllerItemHandlerCache = null;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public BlockPos getStorageBlockPos() {
        return this.getBlockPos();
    }

    public Level getStorageBlockLevel() {
        return this.getLevel();
    }

    public boolean canConnectStorages() {
        return false;
    }

    public void addToController(Level level, BlockPos pos, BlockPos controllerPos) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)controllerPos, ControllerBlockEntityBase.class).ifPresent(c -> c.addStorage(pos));
    }

    public boolean canBeConnected() {
        return this.isLinked() || this.getControllerPos().isEmpty();
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.getBlockPos());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public void removeFromController() {
        if (!this.level.isClientSide()) {
            this.getControllerPos().flatMap(p -> WorldHelper.getBlockEntity((BlockGetter)this.level, (BlockPos)p, ControllerBlockEntityBase.class)).ifPresent(c -> c.removeNonConnectingBlock(this.getBlockPos()));
            this.removeControllerPos();
        }
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        this.saveControllerPos(out);
        if (this.isLinkedToController) {
            out.putBoolean("isLinkedToController", this.isLinkedToController);
        }
    }

    public void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.loadControllerPos(in);
        this.isLinkedToController = in.getBooleanOr("isLinkedToController", false);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return super.getUpdateTag(registries).merge(ValueIOHelper.collectOutputToTag((HolderLookup.Provider)registries, this::saveAdditional));
    }

    public @Nullable Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void invalidateItemHandlerCache() {
        this.controllerItemHandlerCache = null;
        this.invalidateCapabilities();
    }

    public @Nullable ResourceHandler<ItemResource> getExternalItemResourceHandler(@Nullable Direction side) {
        Level level;
        if (this.getControllerPos().isEmpty()) {
            return null;
        }
        if (this.controllerItemHandlerCache == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.controllerItemHandlerCache = BlockCapabilityCache.create((BlockCapability)Capabilities.Item.BLOCK, (ServerLevel)serverLevel, (BlockPos)this.getControllerPos().get(), (Object)side, () -> !this.isRemoved(), this::invalidateItemHandlerCache);
        }
        if (this.controllerItemHandlerCache != null) {
            return (ResourceHandler)this.controllerItemHandlerCache.getCapability();
        }
        return WorldHelper.getBlockEntity((BlockGetter)this.getLevel(), (BlockPos)this.getControllerPos().get(), ControllerBlockEntity.class).map(c -> c.getExternalItemResourceHandler()).orElse(null);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void setRemoved() {
        if (!this.chunkBeingUnloaded && this.level != null) {
            this.unlinkFromController();
        }
        super.setRemoved();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.removeFromController();
    }
}

