/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelRendererBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public class BarrelRenderer<T extends BarrelBlockEntity>
extends BarrelRendererBase<T, BarrelRenderState> {
    public BarrelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    private void submitFrontFace(SubmitNodeCollector submitNodeCollector, BarrelRenderState renderState, PoseStack poseStack) {
        if (renderState.displayItems.isEmpty() && !this.holdsItemThatShowsUpgrades() && !renderState.showsUpgrades) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(renderState.facing));
        poseStack.translate(-0.5, -0.5, -(0.5 - (double)(renderState.flatTop ? 0.0f : 0.0625f)));
        boolean holdsItemThatShowsUpgrades = this.holdsItemThatShowsUpgrades();
        if (renderState.showsUpgrades || holdsItemThatShowsUpgrades) {
            if (renderState.flatTop) {
                this.flatDisplayItemRenderer.submitUpgradeItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY, holdsItemThatShowsUpgrades);
            } else {
                this.displayItemRenderer.submitUpgradeItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY, this.holdsItemThatShowsUpgrades());
            }
        }
        if (!renderState.displayItems.isEmpty()) {
            if (renderState.flatTop) {
                this.flatDisplayItemRenderer.submitDisplayItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY);
            } else {
                this.displayItemRenderer.submitDisplayItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY);
            }
        }
        poseStack.popPose();
    }

    public BarrelRenderState createRenderState() {
        return new BarrelRenderState();
    }

    @Override
    public void extractRenderState(T blockEntity, BarrelRenderState renderState, float partialTick, Vec3 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        if (renderState.packed) {
            return;
        }
        BlockState blockState = blockEntity.getBlockState();
        renderState.facing = (Direction)blockState.getValue(BarrelBlock.FACING);
    }

    public void submit(BarrelRenderState barrelRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (barrelRenderState.packed) {
            return;
        }
        this.submitFrontFace(submitNodeCollector, barrelRenderState, poseStack);
        this.submitHiddenTier(submitNodeCollector, barrelRenderState, poseStack);
        this.submitHiddenLock(submitNodeCollector, barrelRenderState, poseStack);
    }

    public static class BarrelRenderState
    extends BarrelRendererBase.BarrelRenderStateBase {
        public Direction facing;
    }
}

