/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.renderdata.DisplaySide;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.ClientEventHandler;
import net.p3pp3rf1y.sophisticatedstorage.client.StorageTextureManager;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.LockRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderState;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public class ChestRenderer
extends StorageRenderer<ChestBlockEntity, ChestRenderState> {
    private static final String BOTTOM = "bottom";
    private static final String LID = "lid";
    private static final String LOCK = "lock";
    private final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.4378125, new Vec3(-0.0625, 0.0, -0.0075));
    private final Map<ChestType, ChestSubRenderer> chestSubRenderers;
    private final ModelPart root;
    private final MaterialSet materialSet;

    public ChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        ModelPart corePart = context.bakeLayer(ClientEventHandler.CHEST_LAYER);
        ModelPart lockPart = context.bakeLayer(ClientEventHandler.CHEST_LOCK_LAYER);
        this.root = corePart;
        ChestSubRenderer singleChestRenderer = new ChestSubRenderer(ChestType.SINGLE, corePart, lockPart);
        corePart = context.bakeLayer(ClientEventHandler.CHEST_RIGHT_LAYER);
        lockPart = context.bakeLayer(ClientEventHandler.CHEST_LOCK_RIGHT_LAYER);
        ChestSubRenderer doubleChestRightRenderer = new ChestSubRenderer(ChestType.RIGHT, corePart, lockPart);
        corePart = context.bakeLayer(ClientEventHandler.CHEST_LEFT_LAYER);
        lockPart = context.bakeLayer(ClientEventHandler.CHEST_LOCK_LEFT_LAYER);
        ChestSubRenderer doubleChestLeftRenderer = new ChestSubRenderer(ChestType.LEFT, corePart, lockPart);
        this.chestSubRenderers = Map.of(ChestType.SINGLE, singleChestRenderer, ChestType.RIGHT, doubleChestRightRenderer, ChestType.LEFT, doubleChestLeftRenderer);
        this.materialSet = context.materials();
    }

    public static LayerDefinition createSingleBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createSingleLockLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyRightLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleLockRightLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(15.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleBodyLeftLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 19).addBox(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild(LID, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createDoubleLockLeftLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild(LOCK, CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -2.0f, 14.0f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public ModelPart rootModelPart() {
        return this.root;
    }

    private void submitDisplayItem(SubmitNodeCollector submitNodeCollector, ChestRenderState renderState, PoseStack poseStack, StorageRenderState.DisplayItemInfo displayItem) {
        DisplaySide displaySide = displayItem.displaySide();
        if (displaySide == DisplaySide.LEFT) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            if (renderState.chestType == ChestType.LEFT) {
                poseStack.translate(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.RIGHT) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            if (renderState.chestType == ChestType.RIGHT) {
                poseStack.translate(0.0f, 0.0f, -1.0f);
            }
        } else if (displaySide == DisplaySide.FRONT) {
            if (renderState.chestType == ChestType.RIGHT) {
                poseStack.translate(-0.5, 0.0, 0.0);
            } else if (renderState.chestType == ChestType.LEFT) {
                poseStack.translate(0.5, 0.0, 0.0);
            }
        }
        poseStack.translate(-0.5, -0.5, -0.4375);
        this.displayItemRenderer.submitDisplayItem(submitNodeCollector, poseStack, renderState.lightCoords, OverlayTexture.NO_OVERLAY, displayItem);
    }

    private void submitLocked(SubmitNodeCollector submitNodeCollector, ChestRenderState renderState, PoseStack poseStack, ChestType chestType, float lidAngle) {
        poseStack.pushPose();
        if (lidAngle > 0.0f) {
            poseStack.translate(0.0, 0.5625, 0.875);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(lidAngle * 90.0f));
            poseStack.translate(0.0, -0.5625, -0.875);
        }
        if (chestType == ChestType.LEFT) {
            poseStack.translate(0.5, 0.0, 0.0);
        } else if (chestType == ChestType.RIGHT) {
            poseStack.translate(-0.5, 0.0, 0.0);
        }
        LockRenderer.submitLock(submitNodeCollector, renderState, poseStack, 0.8125f, this::holdsToolInToggleLockOrLockDisplay, this.materialSet);
        poseStack.popPose();
    }

    public ChestRenderState createRenderState() {
        return new ChestRenderState();
    }

    @Override
    public void extractRenderState(ChestBlockEntity blockEntity, ChestRenderState renderState, float partialTick, Vec3 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        BlockState blockState = blockEntity.getBlockState();
        renderState.woodType = blockEntity.getWoodType();
        renderState.chestType = (ChestType)blockState.getValue(ChestBlock.TYPE);
        renderState.block = blockState.getBlock();
        renderState.facing = (Direction)blockState.getValue(ChestBlock.FACING);
        float openNess = blockEntity.getOpenNess(partialTick);
        openNess = 1.0f - openNess;
        renderState.open = openNess = 1.0f - openNess * openNess * openNess;
        StorageWrapper storageWrapper = blockEntity.getMainStorageWrapper();
        renderState.hasMainColor = storageWrapper.hasMainColor();
        renderState.hasAccentColor = storageWrapper.hasAccentColor();
        renderState.mainColor = storageWrapper.getMainColor();
        renderState.accentColor = storageWrapper.getAccentColor();
        renderState.packed = blockEntity.isPacked();
        renderState.isMainChest = blockEntity.isMainChest();
        renderState.showUpgradesOnTop = blockEntity.showUpgradesOnTop;
    }

    public void submit(ChestRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        ChestSubRenderer subRenderer = this.chestSubRenderers.get(renderState.chestType);
        if (!subRenderer.setChestMaterialsFrom(renderState.woodType.orElse(WoodType.ACACIA), renderState.block)) {
            return;
        }
        poseStack.pushPose();
        float f = renderState.facing.toYRot();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-f));
        poseStack.translate(-0.5, -0.5, -0.5);
        if (renderState.woodType.isPresent() || !renderState.hasMainColor || !renderState.hasAccentColor) {
            subRenderer.submitBottomAndLid(submitNodeCollector, renderState, poseStack, StorageTextureManager.ChestMaterial.BASE, this.materialSet);
        }
        if (renderState.hasMainColor) {
            subRenderer.submitBottomAndLidWithTint(submitNodeCollector, renderState, poseStack, renderState.mainColor, StorageTextureManager.ChestMaterial.TINTABLE_MAIN, this.materialSet);
        }
        if (renderState.hasAccentColor) {
            subRenderer.submitBottomAndLidWithTint(submitNodeCollector, renderState, poseStack, renderState.accentColor, StorageTextureManager.ChestMaterial.TINTABLE_ACCENT, this.materialSet);
        }
        if (renderState.showsTier) {
            subRenderer.submitTier(submitNodeCollector, renderState, poseStack, this.materialSet);
        } else if (this.holdsItemThatShowsHiddenTiers()) {
            subRenderer.submitHiddenTier(submitNodeCollector, poseStack, renderState, this.materialSet);
        }
        if (renderState.displayItems.isEmpty() || ((StorageRenderState.DisplayItemInfo)renderState.displayItems.getFirst()).displaySide() != DisplaySide.FRONT) {
            subRenderer.submitChestLock(submitNodeCollector, renderState, poseStack, this.materialSet);
        }
        if (renderState.packed) {
            poseStack.pushPose();
            poseStack.translate(-0.005, -0.005, -0.005);
            poseStack.scale(1.01f, 1.01f, 1.01f);
            subRenderer.submitBottomAndLid(submitNodeCollector, renderState, poseStack, StorageTextureManager.ChestMaterial.PACKED, this.materialSet);
            poseStack.popPose();
        } else {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            poseStack.pushPose();
            poseStack.translate(-0.5, -0.5, -0.4375);
            if (renderState.isMainChest && (renderState.showsUpgrades || this.holdsItemThatShowsUpgrades())) {
                poseStack.pushPose();
                if (renderState.chestType == ChestType.LEFT) {
                    poseStack.translate(1.0f, 0.0f, 0.0f);
                }
                if (renderState.showUpgradesOnTop) {
                    if (renderState.open > 0.0f) {
                        poseStack.translate(0.0, 0.5625, 0.875);
                        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderState.open * 90.0f));
                        poseStack.translate(0.0, -0.5625, -0.875);
                    }
                    poseStack.translate(0.5, 0.5, 0.4375);
                    poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                    poseStack.translate(-0.5, -0.4375, -0.375);
                }
                this.displayItemRenderer.submitUpgradeItems(submitNodeCollector, renderState, poseStack, OverlayTexture.NO_OVERLAY, renderState.showsDisabledUpgradeDisplay);
                poseStack.popPose();
            }
            if (renderState.isMainChest) {
                this.submitLocked(submitNodeCollector, renderState, poseStack, renderState.chestType, renderState.open);
            }
            poseStack.popPose();
            if (renderState.isMainChest && !renderState.displayItems.isEmpty()) {
                this.submitDisplayItem(submitNodeCollector, renderState, poseStack, (StorageRenderState.DisplayItemInfo)renderState.displayItems.getFirst());
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    @Override
    protected StorageWrapper getStorageWrapper(ChestBlockEntity blockEntity) {
        return blockEntity.getMainStorageWrapper();
    }

    private static class ChestSubRenderer {
        private final ChestType chestType;
        private final ChestCoreModel coreModel;
        private final ChestCoreModel hiddenTierModel;
        private final ChestLockModel lockModel;
        private Map<StorageTextureManager.ChestMaterial, Material> chestMaterials;
        private Material tierMaterial;

        public ChestSubRenderer(ChestType chestType, ModelPart corePart, ModelPart lockPart) {
            this.chestType = chestType;
            this.coreModel = new ChestCoreModel(corePart, RenderTypes::entityCutout);
            this.hiddenTierModel = new ChestCoreModel(corePart, RenderTypes::entityTranslucent);
            this.lockModel = new ChestLockModel(lockPart, RenderTypes::entityCutout);
        }

        private boolean setChestMaterialsFrom(WoodType woodType, Block block) {
            this.chestMaterials = StorageTextureManager.INSTANCE.getWoodChestMaterials(this.chestType, woodType);
            if (this.chestMaterials == null) {
                return false;
            }
            this.tierMaterial = this.getTierMaterial(block);
            return true;
        }

        private void submitHiddenTier(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, ChestRenderState renderState, MaterialSet materialSet) {
            poseStack.pushPose();
            poseStack.translate(-0.005, -0.005, -0.005);
            poseStack.scale(1.01f, 1.01f, 1.01f);
            int color = Integer.MAX_VALUE;
            RenderType renderType = RenderTypes.entityTranslucent((Identifier)this.tierMaterial.atlasLocation());
            TextureAtlasSprite sprite = materialSet.get(this.tierMaterial);
            submitNodeCollector.submitModel((Model)this.hiddenTierModel, (Object)Float.valueOf(renderState.open), poseStack, renderType, renderState.lightCoords, OverlayTexture.NO_OVERLAY, color, sprite, 0, renderState.breakProgress);
            poseStack.popPose();
        }

        private void submitBottomAndLid(SubmitNodeCollector submitNodeCollector, ChestRenderState renderState, PoseStack poseStack, StorageTextureManager.ChestMaterial chestMaterial, MaterialSet materialSet) {
            Material material = this.chestMaterials.get((Object)chestMaterial);
            RenderType renderType = material.renderType(RenderTypes::entityCutout);
            TextureAtlasSprite sprite = materialSet.get(material);
            this.submitBottomAndLid(submitNodeCollector, renderState, poseStack, renderType, sprite);
        }

        private void submitBottomAndLid(SubmitNodeCollector submitNodeCollector, ChestRenderState renderState, PoseStack poseStack, RenderType renderType, TextureAtlasSprite sprite) {
            if (renderState.open > 0.0f) {
                poseStack.pushPose();
                poseStack.translate(-5.0E-4f, -0.001f, -5.0E-4f);
                poseStack.scale(1.001f, 1.001f, 1.001f);
            }
            submitNodeCollector.submitModel((Model)this.coreModel, (Object)Float.valueOf(renderState.open), poseStack, renderType, renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, sprite, 0, renderState.breakProgress);
            if (renderState.open > 0.0f) {
                poseStack.popPose();
            }
        }

        private void submitBottomAndLidWithTint(SubmitNodeCollector submitNodeCollector, ChestRenderState renderState, PoseStack poseStack, int tint, StorageTextureManager.ChestMaterial chestMaterial, MaterialSet materialSet) {
            Material material = this.chestMaterials.get((Object)chestMaterial);
            RenderType renderType = material.renderType(RenderTypes::entityCutout);
            TextureAtlasSprite sprite = materialSet.get(material);
            int color = 0xFF000000 | tint;
            if (renderState.open > 0.0f) {
                poseStack.pushPose();
                poseStack.translate(-5.0E-4f, -0.001f, -5.0E-4f);
                poseStack.scale(1.001f, 1.001f, 1.001f);
            }
            submitNodeCollector.submitModel((Model)this.coreModel, (Object)Float.valueOf(renderState.open), poseStack, renderType, renderState.lightCoords, OverlayTexture.NO_OVERLAY, color, sprite, 0, renderState.breakProgress);
            if (renderState.open > 0.0f) {
                poseStack.popPose();
            }
        }

        private void submitChestLock(SubmitNodeCollector submitNodeCollector, ChestRenderState renderState, PoseStack poseStack, MaterialSet materialSet) {
            submitNodeCollector.submitModel((Model)this.lockModel, (Object)Float.valueOf(renderState.open), poseStack, RenderTypes.entityCutout((Identifier)this.tierMaterial.atlasLocation()), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, materialSet.get(this.tierMaterial), 0, renderState.breakProgress);
        }

        private Material getTierMaterial(Block block) {
            if (block == ModBlocks.COPPER_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.COPPER_TIER);
            }
            if (block == ModBlocks.IRON_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.IRON_TIER);
            }
            if (block == ModBlocks.GOLD_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.GOLD_TIER);
            }
            if (block == ModBlocks.DIAMOND_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.DIAMOND_TIER);
            }
            if (block == ModBlocks.NETHERITE_CHEST.get()) {
                return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.NETHERITE_TIER);
            }
            return this.chestMaterials.get((Object)StorageTextureManager.ChestMaterial.WOOD_TIER);
        }

        public void submitTier(SubmitNodeCollector submitNodeCollector, ChestRenderState chestRenderState, PoseStack poseStack, MaterialSet materialSet) {
            RenderType renderType = RenderTypes.entityCutout((Identifier)this.tierMaterial.atlasLocation());
            TextureAtlasSprite sprite = materialSet.get(this.tierMaterial);
            this.submitBottomAndLid(submitNodeCollector, chestRenderState, poseStack, renderType, sprite);
        }
    }

    public static class ChestRenderState
    extends StorageRenderState {
        public Optional<WoodType> woodType;
        public ChestType chestType;
        public Block block;
        public Direction facing;
        public float open;
        public boolean hasMainColor;
        public boolean hasAccentColor;
        public int mainColor;
        public int accentColor;
        public boolean packed;
        public boolean isMainChest;
        public boolean showUpgradesOnTop;
    }

    private static class ChestLockModel
    extends Model<Float> {
        private final ModelPart lockPart;

        public ChestLockModel(ModelPart root, Function<Identifier, RenderType> renderType) {
            super(root, renderType);
            this.lockPart = root.getChild(ChestRenderer.LOCK);
        }

        public void setupAnim(Float lidAngle) {
            super.setupAnim((Object)lidAngle);
            this.lockPart.xRot = -(lidAngle.floatValue() * 1.5707964f);
        }
    }

    private static class ChestCoreModel
    extends Model<Float> {
        private final ModelPart lidPart;

        public ChestCoreModel(ModelPart root, Function<Identifier, RenderType> renderType) {
            super(root, renderType);
            this.lidPart = root.getChild(ChestRenderer.LID);
        }

        public void setupAnim(Float lidAngle) {
            super.setupAnim((Object)lidAngle);
            this.lidPart.xRot = -(lidAngle.floatValue() * 1.5707964f);
        }
    }
}

