/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TransformationHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderState;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DisplayItemRenderer {
    private static final ItemStackRenderState EMPTY_UPGRADE_STACK = new ItemStackRenderState();
    public static final float SMALL_BLOCK_ITEM_OFFSET = 0.5f;
    public static final float SMALL_BLOCK_ITEM_SCALE = 0.5f;
    static final float BIG_ITEM_SCALE = 0.5f;
    static final float SMALL_ITEM_SCALE = 0.25f;
    static final float UPGRADE_ITEM_SCALE = 0.125f;
    private static final ItemStackRenderState INACCESSIBLE_SLOT_STACK = new ItemStackRenderState();
    private final double yCenterTranslation;
    private final Vec3 upgradesOffset;
    private static final Cache<Integer, Double> ITEM_HASHCODE_OFFSETS = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build();

    public DisplayItemRenderer(double yCenterTranslation, Vec3 upgradesOffset) {
        this.yCenterTranslation = yCenterTranslation;
        this.upgradesOffset = upgradesOffset;
        ItemModelResolver itemModelResolver = Minecraft.getInstance().getItemModelResolver();
        itemModelResolver.updateForTopItem(EMPTY_UPGRADE_STACK, new ItemStack((ItemLike)ModItems.UPGRADE_BASE.get()), ItemDisplayContext.FIXED, null, null, 0);
        itemModelResolver.updateForTopItem(INACCESSIBLE_SLOT_STACK, new ItemStack((ItemLike)ModItems.INACCESSIBLE_SLOT.get()), ItemDisplayContext.FIXED, null, null, 0);
    }

    static boolean isGui3d(ItemStackRenderState renderState) {
        AABB.Builder builder = new AABB.Builder();
        renderState.visitExtents(arg_0 -> ((AABB.Builder)builder).include(arg_0));
        return builder.build().getZsize() > 0.0625;
    }

    public void submitDisplayItem(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, int packedLight, int packedOverlay, StorageRenderState.DisplayItemInfo displayItemInfo) {
        this.submitSingleItem(submitNodeCollector, poseStack, packedLight, packedOverlay, 1, displayItemInfo.item(), displayItemInfo.index(), displayItemInfo.itemOffset(), displayItemInfo.rotation(), displayItemInfo.isBlockItem());
    }

    public void submitDisplayItems(SubmitNodeCollector submitNodeCollector, StorageRenderState storageRenderState, PoseStack poseStack, int packedOverlay) {
        if (storageRenderState.displayItems.isEmpty() && storageRenderState.inaccessibleSlots.isEmpty()) {
            return;
        }
        for (int displayItemIndex = 0; displayItemIndex < storageRenderState.displayItemSlots; ++displayItemIndex) {
            if (!storageRenderState.inaccessibleSlots.contains(displayItemIndex)) continue;
            this.submitSingleItem(submitNodeCollector, poseStack, storageRenderState.lightCoords, packedOverlay, storageRenderState.displayItemSlots, INACCESSIBLE_SLOT_STACK, displayItemIndex);
        }
        for (StorageRenderState.DisplayItemInfo displayItemInfo : storageRenderState.displayItems) {
            this.submitSingleDisplayItem(submitNodeCollector, poseStack, storageRenderState.lightCoords, packedOverlay, displayItemInfo, storageRenderState.displayItemSlots);
        }
    }

    public void submitUpgradeItems(SubmitNodeCollector submitNodeCollector, StorageRenderState storageRenderState, PoseStack poseStack, int packedOverlay, boolean renderEmptySlots) {
        poseStack.pushPose();
        int i = 0;
        for (ItemStackRenderState upgradeItem : storageRenderState.upgradeItems) {
            if (upgradeItem.isEmpty() && !renderEmptySlots) continue;
            poseStack.pushPose();
            poseStack.translate((double)(1.0f - (float)(i * 2) / 16.0f - 0.0625f) + this.upgradesOffset.x(), 0.0625 + this.upgradesOffset.y(), this.upgradesOffset.z());
            poseStack.scale(0.125f, 0.125f, 0.125f);
            ItemStackRenderState itemToRender = upgradeItem.isEmpty() ? EMPTY_UPGRADE_STACK : upgradeItem;
            itemToRender.submit(poseStack, submitNodeCollector, storageRenderState.lightCoords, packedOverlay, 0);
            if (storageRenderState.showsDisabledUpgradeDisplay) {
                poseStack.pushPose();
                poseStack.translate(0.0f, 0.0f, -0.001f);
                INACCESSIBLE_SLOT_STACK.submit(poseStack, submitNodeCollector, storageRenderState.lightCoords, packedOverlay, 0);
                poseStack.popPose();
            }
            poseStack.popPose();
            ++i;
        }
        poseStack.popPose();
    }

    private void submitSingleDisplayItem(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, int packedLight, int packedOverlay, StorageRenderState.DisplayItemInfo displayItemInfo, int displayItemCount) {
        this.submitSingleItem(submitNodeCollector, poseStack, packedLight, packedOverlay, displayItemCount, displayItemInfo.item(), displayItemInfo.index(), displayItemInfo.itemOffset(), displayItemInfo.rotation(), displayItemInfo.isBlockItem());
    }

    private void submitSingleItem(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, int packedLight, int packedOverlay, int displayItemCount, ItemStackRenderState item, int displayItemIndex) {
        this.submitSingleItem(submitNodeCollector, poseStack, packedLight, packedOverlay, displayItemCount, item, displayItemIndex, 0.0f, 0, false);
    }

    private void submitSingleItem(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, int packedLight, int packedOverlay, int displayItemCount, ItemStackRenderState item, int displayItemIndex, float itemOffset, int rotation, boolean isBlockItem) {
        if (item.layers.length < 1) {
            return;
        }
        poseStack.pushPose();
        Vector3f frontOffset = DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount, (float)this.yCenterTranslation);
        poseStack.translate(frontOffset.x(), frontOffset.y(), -itemOffset);
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)rotation));
        float itemScale = displayItemCount == 1 ? (isBlockItem && DisplayItemRenderer.isGui3d(item) ? 1.0f : 0.5f) : (isBlockItem && DisplayItemRenderer.isGui3d(item) ? 0.5f : 0.25f);
        poseStack.scale(itemScale, itemScale, itemScale);
        item.submit(poseStack, submitNodeCollector, packedLight, packedOverlay, 0);
        poseStack.popPose();
    }

    public static double getDisplayItemOffset(ItemStack item, ItemStackRenderState itemStackRenderState, boolean isGui3d, float additionalScale) {
        ItemStackRenderState.LayerRenderState layer = itemStackRenderState.layers[0];
        ItemTransform transform = layer.transform;
        List quads = layer.prepareQuadList();
        int hash = ItemStack.hashItemAndComponents((ItemStack)item) * 31 + Float.hashCode(additionalScale);
        Double offset = (Double)ITEM_HASHCODE_OFFSETS.getIfPresent((Object)hash);
        if (offset != null) {
            return offset;
        }
        offset = DisplayItemRenderer.calculateDisplayItemOffset(item, itemStackRenderState, transform, quads, isGui3d, additionalScale);
        ITEM_HASHCODE_OFFSETS.put((Object)hash, (Object)offset);
        return offset;
    }

    private static double calculateDisplayItemOffset(ItemStack item, ItemStackRenderState itemStackRenderState, ItemTransform transform, List<BakedQuad> quads, boolean isGui3d, float additionalScale) {
        Item item2;
        double itemOffset = 0.0;
        if (isGui3d && (item2 = item.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item2;
            Block block = blockItem.getBlock();
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                itemOffset = DisplayItemRenderer.calculateOffsetFromModelOrShape(itemStackRenderState, transform, quads, block, level, additionalScale);
            }
        }
        return itemOffset;
    }

    private static double calculateOffsetFromModelOrShape(ItemStackRenderState itemStackRenderState, ItemTransform transform, List<BakedQuad> quads, Block block, ClientLevel level, float additionalScale) {
        if (RenderHelper.isSpecialRenderer(itemStackRenderState)) {
            return DisplayItemRenderer.transformBoundsCornersAndCalculateOffset(transform, DisplayItemRenderer.getBoundsCornersFromShape(block, level), additionalScale);
        }
        return DisplayItemRenderer.transformBoundsCornersAndCalculateOffset(transform, DisplayItemRenderer.getBoundsCornersFromModel(quads), additionalScale);
    }

    private static double transformBoundsCornersAndCalculateOffset(ItemTransform transform, Set<Vector3f> points, float additionalScale) {
        points = DisplayItemRenderer.scalePoints(points, transform.scale());
        points = DisplayItemRenderer.rotatePoints(points, transform.rotation());
        points = DisplayItemRenderer.translatePoints(points, transform.translation());
        float zScale = transform.scale().z();
        return ((double)zScale * 0.12539184952978058 - DisplayItemRenderer.getMaxZ(points)) * (double)additionalScale;
    }

    private static Set<Vector3f> getBoundsCornersFromShape(Block block, ClientLevel level) {
        VoxelShape shape = block.defaultBlockState().getShape((BlockGetter)level, BlockPos.ZERO, CollisionContext.empty());
        return DisplayItemRenderer.getCornerPointsRelativeToCenter(shape.bounds());
    }

    private static Set<Vector3f> getBoundsCornersFromModel(List<BakedQuad> quads) {
        float minX = 2.0f;
        float minY = 2.0f;
        float minZ = 2.0f;
        float maxX = -2.0f;
        float maxY = -2.0f;
        float maxZ = -2.0f;
        for (BakedQuad quad : quads) {
            for (int v = 0; v < 4; ++v) {
                Vector3fc pos = quad.position(v);
                float x = pos.x();
                float y = pos.y();
                float z = pos.z();
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                minZ = Math.min(minZ, z);
                maxZ = Math.max(maxZ, z);
            }
        }
        return DisplayItemRenderer.getCornerPointsRelativeToCenter(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static double getMaxZ(Set<Vector3f> points) {
        float maxZ = Float.MIN_VALUE;
        for (Vector3f point : points) {
            if (!(point.z() > maxZ)) continue;
            maxZ = point.z();
        }
        return maxZ;
    }

    private static Set<Vector3f> translatePoints(Set<Vector3f> points, Vector3fc translation) {
        return DisplayItemRenderer.transformPoints(points, point -> {
            point.sub(translation);
            return point;
        });
    }

    private static Set<Vector3f> rotatePoints(Set<Vector3f> points, Vector3fc rotation) {
        Quaternionf rot = TransformationHelper.quatFromXYZ((float)rotation.x(), (float)rotation.y(), (float)rotation.z(), (boolean)true);
        return DisplayItemRenderer.transformPoints(points, point -> {
            point.rotate((Quaternionfc)rot);
            return point;
        });
    }

    private static Set<Vector3f> scalePoints(Set<Vector3f> points, Vector3fc scale) {
        return DisplayItemRenderer.transformPoints(points, point -> new Vector3f(point.x() * scale.x(), point.y() * scale.y(), point.z() * scale.z()));
    }

    private static Set<Vector3f> transformPoints(Set<Vector3f> points, UnaryOperator<Vector3f> transform) {
        HashSet<Vector3f> ret = new HashSet<Vector3f>();
        for (Vector3f point : points) {
            ret.add((Vector3f)transform.apply(point));
        }
        return ret;
    }

    private static Set<Vector3f> getCornerPointsRelativeToCenter(AABB aabb) {
        return DisplayItemRenderer.getCornerPointsRelativeToCenter((float)aabb.minX, (float)aabb.minY, (float)aabb.minZ, (float)aabb.maxX, (float)aabb.maxY, (float)aabb.maxZ);
    }

    private static Set<Vector3f> getCornerPointsRelativeToCenter(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        HashSet<Vector3f> ret = new HashSet<Vector3f>();
        ret.add(new Vector3f(0.5f - minX, 0.5f - minY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - minY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - maxY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - minX, 0.5f - maxY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - minY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - minY, 0.5f - maxZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - maxY, 0.5f - minZ));
        ret.add(new Vector3f(0.5f - maxX, 0.5f - maxY, 0.5f - maxZ));
        return ret;
    }

    public static Vector3f getDisplayItemIndexFrontOffset(int displayItemIndex, int displayItemCount) {
        return DisplayItemRenderer.getDisplayItemIndexFrontOffset(displayItemIndex, displayItemCount, 0.5f);
    }

    public static Vector3f getDisplayItemIndexFrontOffset(int displayItemIndex, int displayItemCount, float centerYOffset) {
        Vector3f frontOffset;
        if (displayItemCount <= 0 || displayItemCount > 4) {
            frontOffset = new Vector3f(0.0f, 0.0f, 0.5f);
        } else if (displayItemCount == 1) {
            frontOffset = new Vector3f(0.5f, centerYOffset, 0.5f);
        } else if (displayItemCount == 2) {
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(0.5f, displayItemIndex == 0 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        } else if (displayItemCount == 3) {
            float xOffset = 0.5f;
            if (displayItemIndex > 0) {
                xOffset = 0.75f - (float)(displayItemIndex - 1) * 0.5f;
            }
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(xOffset, displayItemIndex == 0 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        } else {
            float halfCenterYOffset = centerYOffset / 2.0f;
            frontOffset = new Vector3f(displayItemIndex == 0 || displayItemIndex == 2 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, displayItemIndex == 0 || displayItemIndex == 1 ? centerYOffset + halfCenterYOffset : halfCenterYOffset, 0.5f);
        }
        return frontOffset;
    }

    public static Quaternionf getNorthBasedRotation(Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> Axis.XP.rotationDegrees(-90.0f);
            case Direction.UP -> Axis.XP.rotationDegrees(90.0f);
            case Direction.NORTH -> new Quaternionf();
            case Direction.SOUTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(90.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(-90.0f);
        };
    }
}

