/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.render.ShulkerBoxRenderer;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class ShulkerBoxItemRenderer
implements SpecialModelRenderer<ShulkerBoxAttributes> {
    private final LoadingCache<BlockItem, ShulkerBoxBlockEntity> shulkerBoxBlockEntities = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<BlockItem, ShulkerBoxBlockEntity>(this){

        public ShulkerBoxBlockEntity load(BlockItem blockItem) {
            return new ShulkerBoxBlockEntity(BlockPos.ZERO, (BlockState)blockItem.getBlock().defaultBlockState().setValue(ShulkerBoxBlock.FACING, (Comparable)Direction.SOUTH));
        }
    });

    public @Nullable ShulkerBoxAttributes extractArgument(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem blockItem = (BlockItem)item;
        int mainColor = -1;
        int accentColor = -1;
        Item item2 = stack.getItem();
        if (item2 instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item2;
            mainColor = tintableBlockItem.getMainColor(stack).orElse(-1);
            accentColor = tintableBlockItem.getAccentColor(stack).orElse(-1);
        }
        boolean showsTier = StorageBlockItem.showsTier(stack);
        return new ShulkerBoxAttributes(blockItem, mainColor, accentColor, showsTier);
    }

    public void submit(@Nullable ShulkerBoxAttributes shulkerBoxAttributes, ItemDisplayContext itemDisplayContext, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int i, int i1, boolean b, int i2) {
        BlockEntityRenderDispatcher blockEntityRenderDispatcher;
        BlockEntityRenderer blockentityrenderer;
        if (shulkerBoxAttributes == null) {
            return;
        }
        ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)this.shulkerBoxBlockEntities.getUnchecked((Object)shulkerBoxAttributes.blockItem());
        shulkerBoxBlockEntity.getStorageWrapper().setColors(shulkerBoxAttributes.mainColor(), shulkerBoxAttributes.accentColor());
        if (shulkerBoxAttributes.showsTier() != shulkerBoxBlockEntity.shouldShowTier()) {
            shulkerBoxBlockEntity.toggleTierVisiblity();
        }
        if ((blockentityrenderer = (blockEntityRenderDispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher()).getRenderer((BlockEntity)shulkerBoxBlockEntity)) != null) {
            BlockEntityRenderState renderState = blockentityrenderer.createRenderState();
            blockentityrenderer.extractRenderState((BlockEntity)shulkerBoxBlockEntity, renderState, 0.0f, Vec3.ZERO, null);
            blockentityrenderer.submit(renderState, poseStack, submitNodeCollector, RenderHelper.ZERO_POS_CAMERA_RENDER_STATE);
        }
    }

    public void getExtents(Consumer<Vector3fc> consumer) {
        PoseStack posestack = new PoseStack();
        ShulkerBoxBlockEntity shulkerBoxItem = (ShulkerBoxBlockEntity)this.shulkerBoxBlockEntities.getUnchecked((Object)((BlockItem)ModBlocks.SHULKER_BOX_ITEM.get()));
        BlockEntityRenderer blockentityrenderer = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer((BlockEntity)shulkerBoxItem);
        if (blockentityrenderer instanceof ShulkerBoxRenderer) {
            ShulkerBoxRenderer shulkerBoxRenderer = (ShulkerBoxRenderer)blockentityrenderer;
            shulkerBoxRenderer.rootModelPart().getExtentsForGui(posestack, consumer);
        }
    }

    public record ShulkerBoxAttributes(BlockItem blockItem, int mainColor, int accentColor, boolean showsTier) {
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)new Unbaked());

        public @Nullable SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext bakingContext) {
            return new ShulkerBoxItemRenderer();
        }

        public MapCodec<? extends Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

