/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStashStorageItem;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageContentsTooltip;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageItemClient;

public class ShulkerBoxItem
extends StorageBlockItem
implements IStashStorageItem {
    public ShulkerBoxItem(Block block, Item.Properties properties) {
        super(block, properties.stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag tooltipFlag) {
        HolderLookup.Provider registries;
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, tooltipFlag);
        if (tooltipFlag.isAdvanced() && (registries = context.registries()) != null) {
            StackStorageWrapper.fromStack(registries, stack).getContentsUuid().ifPresent(uuid -> tooltipAdder.accept((Component)Component.literal((String)("UUID: " + String.valueOf(uuid))).withStyle(ChatFormatting.DARK_GRAY)));
        }
        if (!Minecraft.getInstance().hasShiftDown()) {
            tooltipAdder.accept((Component)Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (FMLEnvironment.getDist().isClient()) {
            return Optional.ofNullable(StorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void onDestroyed(ItemEntity itemEntity) {
        Level level = itemEntity.level();
        if (level.isClientSide()) {
            return;
        }
        ItemStack stack = itemEntity.getItem();
        StackStorageWrapper storageWrapper = StackStorageWrapper.fromStack((HolderLookup.Provider)level.registryAccess(), stack);
        InventoryHelper.dropItems((ResourceHandler)storageWrapper.getInventoryHandler(), (Level)level, (double)itemEntity.getX(), (double)itemEntity.getY(), (double)itemEntity.getZ());
        InventoryHelper.dropItems((ResourceHandler)storageWrapper.getUpgradeHandler(), (Level)level, (double)itemEntity.getX(), (double)itemEntity.getY(), (double)itemEntity.getZ());
    }

    public Optional<TooltipComponent> getInventoryTooltip(ItemStack stack) {
        return Optional.of(new StorageContentsTooltip(stack));
    }

    public int stash(HolderLookup.Provider registries, ItemStack storageStack, ItemResource resource, int amount, TransactionContext tx) {
        StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, storageStack);
        if (wrapper.getContentsUuid().isEmpty()) {
            wrapper.setContentsUuid(UUID.randomUUID());
        }
        return wrapper.getInventoryForUpgradeProcessing().insert((Resource)resource, amount, tx);
    }

    public IStashStorageItem.StashResult getItemStashable(HolderLookup.Provider registries, ItemStack storageStack, ItemStack stack) {
        StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, storageStack);
        try (Transaction tx = Transaction.openRoot();){
            if (wrapper.getInventoryForUpgradeProcessing().insert((Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)tx) == 0) {
                IStashStorageItem.StashResult stashResult = IStashStorageItem.StashResult.NO_SPACE;
                return stashResult;
            }
        }
        if (wrapper.getInventoryHandler().getSlotTracker().getItems().contains(stack.getItem()) || ((MemorySettingsCategory)wrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).matchesFilter(stack)) {
            return IStashStorageItem.StashResult.MATCH_AND_SPACE;
        }
        return IStashStorageItem.StashResult.SPACE;
    }

    public int getNumberOfInventorySlots(HolderLookup.Provider registries, ItemStack shulkerBoxStack) {
        int defaultNumberOfInventorySlots = StackStorageWrapper.fromStack(registries, shulkerBoxStack).getDefaultNumberOfInventorySlots();
        return Math.max((Integer)shulkerBoxStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)defaultNumberOfInventorySlots), defaultNumberOfInventorySlots);
    }

    public int getNumberOfUpgradeSlots(HolderLookup.Provider registries, ItemStack shulkerBoxStack) {
        int defaultNumberOfUpgradeSlots = StackStorageWrapper.fromStack(registries, shulkerBoxStack).getDefaultNumberOfUpgradeSlots();
        return Math.max((Integer)shulkerBoxStack.getOrDefault(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)defaultNumberOfUpgradeSlots), defaultNumberOfUpgradeSlots);
    }

    public boolean overrideStackedOnOther(ItemStack storageStack, Slot slot, ClickAction action, Player player) {
        if (this.hasCreativeScreenContainerOpen(player) || storageStack.getCount() > 1 || !slot.mayPickup(player) || slot.getItem().isEmpty() || action != ClickAction.SECONDARY) {
            return super.overrideStackedOnOther(storageStack, slot, action, player);
        }
        ItemStack stackToStash = slot.getItem();
        try (Transaction tx = Transaction.openRoot();){
            int stashed = this.stash((HolderLookup.Provider)player.level().registryAccess(), storageStack, ItemResource.of((ItemStack)stackToStash), stackToStash.getCount(), (TransactionContext)tx);
            if (stashed > 0) {
                tx.commit();
                slot.safeTake(stashed, stashed, player);
                boolean bl = true;
                return bl;
            }
        }
        return super.overrideStackedOnOther(storageStack, slot, action, player);
    }

    public boolean overrideOtherStackedOnMe(ItemStack storageStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess carriedAccess) {
        if (this.hasCreativeScreenContainerOpen(player) || storageStack.getCount() > 1 || !slot.mayPlace(storageStack) || action != ClickAction.SECONDARY) {
            return super.overrideOtherStackedOnMe(storageStack, otherStack, slot, action, player, carriedAccess);
        }
        try (Transaction tx = Transaction.openRoot();){
            int stashed = this.stash((HolderLookup.Provider)player.level().registryAccess(), storageStack, ItemResource.of((ItemStack)otherStack), otherStack.getCount(), (TransactionContext)tx);
            if (stashed > 0) {
                tx.commit();
                carriedAccess.set(otherStack.copyWithCount(otherStack.getCount() - stashed));
                slot.set(storageStack);
                boolean bl = true;
                return bl;
            }
        }
        return super.overrideOtherStackedOnMe(storageStack, otherStack, slot, action, player, carriedAccess);
    }

    private boolean hasCreativeScreenContainerOpen(Player player) {
        return player.level().isClientSide() && player.containerMenu instanceof CreativeModeInventoryScreen.ItemPickerMenu;
    }
}

