/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class StorageConnectorBlockItem
extends BlockItemBase {
    public static final String REGISTRY_NAME_WITHOUT_WOOD_TYPE = "storage_connector";
    public static final String BLOCK_TRANSLATION_KEY = Util.makeDescriptionId((String)"block", (Identifier)SophisticatedStorage.getIdentifier("storage_connector"));
    public static final String TOOLTIP_TRANSLATION_KEY = BLOCK_TRANSLATION_KEY + ".tooltip";

    public StorageConnectorBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        StorageTranslationHelper.INSTANCE.getTranslatedLines(TOOLTIP_TRANSLATION_KEY, null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}).forEach(tooltipAdder);
    }

    public Component getName(ItemStack stack) {
        return WoodStorageBlockItem.getDisplayName(BLOCK_TRANSLATION_KEY, this.getWoodType(BuiltInRegistries.ITEM.getKey((Object)this).getPath()));
    }

    private WoodType getWoodType(String registryName) {
        if (registryName.length() <= REGISTRY_NAME_WITHOUT_WOOD_TYPE.length() + 1) {
            return WoodType.ACACIA;
        }
        String woodName = registryName.substring(0, registryName.length() - (REGISTRY_NAME_WITHOUT_WOOD_TYPE.length() + 1));
        return WoodType.values().filter(wt -> wt.name().equals(woodName)).findFirst().orElse(WoodType.ACACIA);
    }
}

