/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.compression;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.transfer.IndexModifier;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IResourceExtractor;
import net.p3pp3rf1y.sophisticatedcore.inventory.IResourceInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.MathHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import org.jspecify.annotations.Nullable;

public class CompressionInventoryPart
implements IInventoryPartHandler {
    public static final String NAME = "compression";
    public static final Identifier EMPTY_COMPRESSION_SLOT = SophisticatedStorage.getIdentifier("container/slot/compression");
    private final InventoryHandler parent;
    private final SlotRange slotRange;
    private final Supplier<MemorySettingsCategory> getMemorySettings;
    private final Runnable recipeChangeListener = () -> this.calculateStacks(false);
    private Map<Integer, SlotDefinition> slotDefinitions = new HashMap<Integer, SlotDefinition>();
    private Map<Integer, ItemStack> calculatedStacks = new HashMap<Integer, ItemStack>();
    private final Map<Integer, Integer> lastCalculatedCounts = new HashMap<Integer, Integer>();
    private final CompressionJournal journal = new CompressionJournal();

    public CompressionInventoryPart(InventoryHandler parent, SlotRange slotRange, Supplier<MemorySettingsCategory> getMemorySettings) {
        this.parent = parent;
        this.slotRange = slotRange;
        this.getMemorySettings = getMemorySettings;
        RecipeHelper.addRecipeChangeListener((Runnable)this.recipeChangeListener);
    }

    public void onInit() {
        this.calculateStacks(true);
    }

    private void calculateStacks(boolean initial) {
        this.clearCollections();
        Map<Integer, ItemStack> existingStacks = this.getExistingStacks();
        if (existingStacks.isEmpty()) {
            return;
        }
        int lastNonEmptySlot = this.getLastNonEmptySlot(existingStacks);
        this.setSlotDefinitions(this.getSlotDefinitions(existingStacks.get(lastNonEmptySlot), lastNonEmptySlot, existingStacks), initial);
        this.compactInternalSlots();
        this.updateCalculatedStacks();
        this.slotDefinitions.forEach((slot, definition) -> this.parent.triggerOnChangeListeners(slot.intValue()));
    }

    private void setSlotDefinitions(Map<Integer, SlotDefinition> definitions, boolean initial) {
        this.slotDefinitions = definitions;
        if (initial) {
            this.parent.initFilterItems();
        } else {
            this.parent.onFilterItemsChanged();
        }
    }

    private Integer getLastNonEmptySlot(Map<Integer, ItemStack> existingStacks) {
        for (int slot = this.slotRange.firstSlot() + this.slotRange.size() - 1; slot >= this.slotRange.firstSlot(); --slot) {
            if (!existingStacks.containsKey(slot)) continue;
            return slot;
        }
        return -1;
    }

    private Map<Integer, SlotDefinition> getSlotDefinitions(ItemStack firstItem, int lastSlot, Map<Integer, ItemStack> existingStacks) {
        HashMap<Integer, SlotDefinition> ret = new HashMap<Integer, SlotDefinition>();
        this.addPreviousItems(ret, lastSlot, firstItem);
        ItemStack prevItem = firstItem;
        for (int slot = lastSlot; slot >= this.slotRange.firstSlot(); --slot) {
            if (existingStacks.containsKey(slot) && !ItemStack.isSameItemSameComponents((ItemStack)existingStacks.get(slot), (ItemStack)prevItem)) {
                ret.clear();
                break;
            }
            Optional<RecipeHelper.CompactingShape> compressionShape = this.getCompressionShape(prevItem);
            if (!compressionShape.isPresent()) {
                ret.put(slot, new SlotDefinition(prevItem, 1, true));
                break;
            }
            RecipeHelper.CompactingShape shape = compressionShape.get();
            ret.put(slot, new SlotDefinition(prevItem, shape.getNumberOfIngredients(), true));
            prevItem = RecipeHelper.getCompactingResult((ItemStack)prevItem, (RecipeHelper.CompactingShape)shape).getResult();
        }
        this.updateSlotLimits(ret);
        this.updateInaccessibleAndCompressible(ret, existingStacks);
        return ret;
    }

    private void updateSlotLimits(Map<Integer, SlotDefinition> definitions) {
        int totalLimit = 0;
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
            if (!definitions.containsKey(slot) || !definitions.get(slot).isAccessible()) continue;
            totalLimit = MathHelper.intMaxCappedAddition((int)this.parent.getBaseCapacity(definitions.get((Object)Integer.valueOf((int)slot)).itemResource), (int)MathHelper.intMaxCappedMultiply((int)definitions.get((Object)Integer.valueOf((int)slot)).prevSlotMultiplier, (int)totalLimit));
            definitions.get(slot).setSlotLimit(totalLimit);
        }
    }

    private void updateCalculatedStacks() {
        int totalCalculated = 0;
        boolean prevFull = false;
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            if (!slotDefinition.isAccessible()) continue;
            if (!slotDefinition.isCompressible()) {
                this.setCalculatedStack(slot, this.parent.getInternalStack(slot).copy());
                continue;
            }
            int internalCount = this.parent.getInternalStack(slot).getCount();
            totalCalculated = Integer.MAX_VALUE / slotDefinition.prevSlotMultiplier() < totalCalculated ? Integer.MAX_VALUE : totalCalculated * slotDefinition.prevSlotMultiplier();
            totalCalculated = Integer.MAX_VALUE - internalCount < totalCalculated ? Integer.MAX_VALUE : totalCalculated + internalCount;
            ItemStack calculatedStack = slotDefinition.itemResource().toStack(totalCalculated);
            int internalLimit = this.parent.getBaseCapacity(slotDefinition.itemResource());
            int maxStackSize = slotDefinition.itemResource.getMaxStackSize();
            if (Integer.MAX_VALUE - totalCalculated < maxStackSize) {
                calculatedStack.setCount(Integer.MAX_VALUE - (prevFull ? Math.min(maxStackSize, internalLimit - internalCount) : maxStackSize));
            }
            this.setCalculatedStack(slot, calculatedStack);
            prevFull = internalLimit <= internalCount;
        }
    }

    private void setCalculatedStack(int slot, ItemStack stack) {
        this.calculatedStacks.put(slot, stack);
        this.lastCalculatedCounts.put(slot, stack.getCount());
    }

    private void compactInternalSlots() {
        HashMap<Integer, Integer> toUpdate = new HashMap<Integer, Integer>();
        for (int slot = this.slotRange.firstSlot() + 1; slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
            int prevStackCount;
            ItemStack slotStack = this.parent.getInternalStack(slot);
            int multiplier = this.getPrevSlotMultiplier(slot);
            if (slotStack.isEmpty() || multiplier < 2) continue;
            int prevSlot = slot - 1;
            ItemStack prevStack = this.parent.getInternalStack(prevSlot);
            int stackLimit = this.parent.getBaseCapacity(this.parent.getResource(prevSlot));
            int availableSpace = stackLimit - (prevStackCount = toUpdate.containsKey(prevSlot) ? ((Integer)toUpdate.get(prevSlot)).intValue() : prevStack.getCount());
            int countToInsert = Math.min(availableSpace, slotStack.getCount() / multiplier);
            if (countToInsert <= 0) continue;
            toUpdate.put(prevSlot, prevStackCount + countToInsert);
            toUpdate.put(slot, slotStack.getCount() - countToInsert * multiplier);
        }
        this.updateInternalStacksWithCounts(toUpdate);
    }

    private void updateInaccessibleAndCompressible(Map<Integer, SlotDefinition> definitions, Map<Integer, ItemStack> existingStacks) {
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
            definitions.computeIfAbsent(slot, s -> {
                if (existingStacks.containsKey(s)) {
                    return new SlotDefinition((ItemStack)existingStacks.get(s), 1, true);
                }
                return SlotDefinition.inaccesible();
            });
            if (!definitions.get(slot).isAccessible()) continue;
            boolean uncompressibledFromNext = definitions.containsKey(slot - 1) && definitions.get(slot - 1).isAccessible() && definitions.get(slot).prevSlotMultiplier() > 1;
            boolean compressibleFromPrevious = definitions.containsKey(slot + 1) && definitions.get(slot + 1).isAccessible() && definitions.get(slot + 1).prevSlotMultiplier() > 1;
            definitions.get(slot).setCompressible(uncompressibledFromNext || compressibleFromPrevious);
        }
    }

    private void clearCollections() {
        this.slotDefinitions.clear();
        this.calculatedStacks.clear();
        this.lastCalculatedCounts.clear();
        this.parent.onFilterItemsChanged();
    }

    private Optional<RecipeHelper.CompactingShape> getCompressionShape(ItemStack stack) {
        Set compactingShapes = RecipeHelper.getItemCompactingShapes((ItemStack)stack);
        if (compactingShapes.contains(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE)) {
            return Optional.of(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE)) {
            return Optional.of(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.THREE_BY_THREE)) {
            Item compressedItem = RecipeHelper.getCompactingResult((ItemStack)stack, (RecipeHelper.CompactingShape)RecipeHelper.CompactingShape.THREE_BY_THREE).getResult().getItem();
            return this.getDecompressionResultFromConfig(compressedItem).isPresent() ? Optional.of(RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) : Optional.empty();
        }
        if (compactingShapes.contains(RecipeHelper.CompactingShape.TWO_BY_TWO)) {
            Item compressedItem = RecipeHelper.getCompactingResult((ItemStack)stack, (RecipeHelper.CompactingShape)RecipeHelper.CompactingShape.TWO_BY_TWO).getResult().getItem();
            return this.getDecompressionResultFromConfig(compressedItem).isPresent() ? Optional.of(RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE) : Optional.empty();
        }
        return Optional.empty();
    }

    private void addPreviousItems(Map<Integer, SlotDefinition> slotDefinitions, int firstFilledSlot, ItemStack firstFilledItem) {
        ItemStack currentItem = firstFilledItem;
        for (int slot = firstFilledSlot + 1; slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
            RecipeHelper.UncompactingResult uncompactingResult = RecipeHelper.getUncompactingResult((ItemStack)currentItem);
            if (uncompactingResult.getCompactUsingShape() == RecipeHelper.CompactingShape.NONE) {
                Optional<RecipeHelper.UncompactingResult> decompressionResult = this.getDecompressionResultFromConfig(currentItem.getItem());
                if (decompressionResult.isEmpty()) break;
                uncompactingResult = decompressionResult.get();
            }
            slotDefinitions.put(slot, new SlotDefinition(uncompactingResult.getResult(), uncompactingResult.getCompactUsingShape() == RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE ? 4 : 9, true));
            currentItem = uncompactingResult.getResult();
        }
    }

    Optional<RecipeHelper.UncompactingResult> getDecompressionResultFromConfig(Item currentItem) {
        return Config.SERVER.compressionUpgrade.getDecompressionResult(currentItem);
    }

    private Map<Integer, ItemStack> getExistingStacks() {
        LinkedHashMap<Integer, ItemStack> existingStacks = new LinkedHashMap<Integer, ItemStack>();
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
            ItemStack slotStack = this.parent.getInternalStack(slot);
            if (slotStack.isEmpty()) continue;
            existingStacks.put(slot, slotStack);
        }
        if (existingStacks.isEmpty()) {
            MemorySettingsCategory memorySettings = this.getMemorySettings.get();
            for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
                int finalSlot = slot;
                memorySettings.getSlotFilterStack(slot, true).ifPresent(stack -> existingStacks.put(finalSlot, (ItemStack)stack));
            }
        }
        return existingStacks;
    }

    public int getSlotLimit(int slot) {
        return this.slotDefinitions.containsKey(slot) ? this.slotDefinitions.get(slot).slotLimit() : this.parent.getBaseSlotLimit();
    }

    public int getCapacity(int slot, ItemResource resource) {
        if (!this.slotDefinitions.containsKey(slot)) {
            return this.parent.getBaseCapacity(resource);
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return this.getStackLimit(slotDefinition);
    }

    private int getStackLimit(SlotDefinition slotDefinition) {
        if (!slotDefinition.isAccessible()) {
            return 0;
        }
        return slotDefinition.slotLimit();
    }

    public int extract(int slot, ItemResource resource, int amount, TransactionContext tx, IResourceExtractor extractSuper) {
        return this.extractItem(slot, resource, amount, tx, s -> s.isEmpty() ? 64 : s.getMaxStackSize());
    }

    private int extractItem(int slot, ItemResource resource, int amount, TransactionContext tx, ToIntFunction<ItemStack> getLimit) {
        if (!(this.slotDefinitions.containsKey(slot) && this.slotDefinitions.get((Object)Integer.valueOf((int)slot)).itemResource.equals((Object)resource) && this.slotDefinitions.get(slot).isAccessible() && this.calculatedStacks.containsKey(slot))) {
            return 0;
        }
        int extracted = Math.min(this.calculatedStacks.get(slot).getCount(), amount);
        if (extracted > 0) {
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            ItemStack slotStack = this.parent.getInternalStack(slot);
            extracted = Math.min(extracted, getLimit.applyAsInt(slotStack));
            this.journal.updateSnapshots(tx);
            if (slotDefinition.isCompressible()) {
                this.extractFromCalculated(slot, extracted);
                this.extractFromInternal(slot, extracted);
            } else {
                slotStack.shrink(extracted);
                this.setCalculatedStack(slot, slotStack.copy());
                this.parent.setStackInSlotInternal(slot, slotStack);
            }
            this.removeDefinitionsIfEmpty(slot);
            return extracted;
        }
        return 0;
    }

    private void removeDefinitionsIfEmpty(int slotTriggeringChange) {
        for (int slot = this.slotRange.firstSlot(); slot < this.slotRange.firstSlot() + this.slotRange.size(); ++slot) {
            if (this.parent.getInternalStack(slot).isEmpty() && !this.getMemorySettings.get().getSlotFilterStack(slot, false).isPresent()) continue;
            return;
        }
        this.clearCollections();
        this.parent.triggerOnChangeListeners(slotTriggeringChange);
    }

    private void extractFromInternal(int slotToStartFrom, int amountToExtract) {
        HashMap<Integer, Integer> toUpdate = new HashMap<Integer, Integer>();
        int decompressedAmountToInsert = 0;
        int totalMultiplier = 1;
        while (amountToExtract > 0) {
            ItemStack slotStack = this.parent.getInternalStack(slotToStartFrom);
            if (totalMultiplier == 1) {
                int toRemove = Math.min(amountToExtract, slotStack.getCount());
                toUpdate.put(slotToStartFrom, slotStack.getCount() - toRemove);
                amountToExtract -= toRemove;
            } else {
                int ceiledAmount = (int)Math.ceil((double)amountToExtract / (double)totalMultiplier);
                int toRemove = Math.min(ceiledAmount, slotStack.getCount());
                toUpdate.put(slotToStartFrom, slotStack.getCount() - toRemove);
                int totalToRemove = toRemove * totalMultiplier;
                if (totalToRemove > amountToExtract) {
                    decompressedAmountToInsert = totalToRemove - amountToExtract;
                    break;
                }
                amountToExtract -= totalToRemove;
            }
            totalMultiplier *= this.getPrevSlotMultiplier(slotToStartFrom);
            --slotToStartFrom;
        }
        while (decompressedAmountToInsert > 0) {
            int toInsert;
            if ((toInsert = decompressedAmountToInsert / (totalMultiplier /= this.getPrevSlotMultiplier(++slotToStartFrom))) <= 0) continue;
            toUpdate.put(slotToStartFrom, toUpdate.getOrDefault(slotToStartFrom, 0) + toInsert);
            decompressedAmountToInsert -= toInsert * totalMultiplier;
        }
        this.updateInternalStacksWithCounts(toUpdate);
    }

    private int getPrevSlotMultiplier(int slot) {
        return this.slotDefinitions.get((Object)Integer.valueOf((int)slot)).prevSlotMultiplier;
    }

    private void updateInternalStacksWithCounts(Map<Integer, Integer> toUpdate) {
        toUpdate.forEach((s, count) -> {
            ItemStack slotStack = this.parent.getInternalStack(s.intValue());
            if (slotStack.getCount() != count.intValue()) {
                if (count == 0) {
                    this.parent.setStackInSlotInternal(s.intValue(), ItemStack.EMPTY);
                } else if (slotStack.isEmpty()) {
                    this.parent.setStackInSlotInternal(s.intValue(), this.slotDefinitions.get(s).itemResource().toStack(count.intValue()));
                } else {
                    slotStack.setCount(count.intValue());
                    this.parent.setStackInSlotInternal(s.intValue(), slotStack);
                }
            }
        });
    }

    private void extractFromCalculated(int slot, int extractCount) {
        this.extractFromCalculatedThisAndPreviousStacks(extractCount, slot);
        this.extractFromCalculatedThisAndStacksAfter(extractCount, slot + 1);
    }

    private void extractFromCalculatedThisAndPreviousStacks(int extractCount, int slotCalculated) {
        int countBeforeChange = -1;
        int multiplier = 1;
        while (extractCount != 0 && this.calculatedStacks.containsKey(slotCalculated)) {
            ItemStack calculatedStack = this.calculatedStacks.get(slotCalculated);
            if (countBeforeChange > 0 && countBeforeChange / multiplier > calculatedStack.getCount() && (extractCount = calculatedStack.getCount() - (countBeforeChange - extractCount * multiplier) / multiplier) <= 0) break;
            countBeforeChange = calculatedStack.getCount();
            int toSet = this.getCountChangeLeavingSpaceBeforeMaxInt(countBeforeChange - extractCount, slotCalculated, calculatedStack);
            calculatedStack.setCount(toSet);
            this.setCalculatedStack(slotCalculated, calculatedStack);
            multiplier = this.getPrevSlotMultiplier(slotCalculated);
            extractCount = countBeforeChange / multiplier - calculatedStack.getCount() / multiplier;
            --slotCalculated;
        }
    }

    private int getCountChangeLeavingSpaceBeforeMaxInt(int countCalculated, int slotCalculated, ItemStack calculatedStack) {
        boolean hasPrevious;
        int toSet = countCalculated;
        int prevSlot = slotCalculated - 1;
        SlotDefinition prevSlotDefinition = this.slotDefinitions.get(prevSlot);
        boolean bl = hasPrevious = prevSlotDefinition != null && prevSlotDefinition.isAccessible();
        if (countCalculated > 0 && Integer.MAX_VALUE - countCalculated < calculatedStack.getMaxStackSize() && hasPrevious) {
            boolean prevSlotFull = this.calculatedStacks.containsKey(prevSlot) && this.getSlotLimit(prevSlot) == this.calculatedStacks.get(prevSlot).getCount();
            ItemResource itemResource = this.slotDefinitions.get((Object)Integer.valueOf((int)slotCalculated)).itemResource;
            int buffer = prevSlotFull ? this.getCapacity(slotCalculated, itemResource) - countCalculated : calculatedStack.getMaxStackSize();
            toSet = Integer.MAX_VALUE - buffer;
        }
        return toSet;
    }

    private void extractFromCalculatedThisAndStacksAfter(int extractCount, int slot) {
        while (slot < this.slotRange.firstSlot() + this.slotRange.size() && this.slotDefinitions.get(slot).isAccessible() && this.calculatedStacks.containsKey(slot)) {
            ItemStack calculatedStack = this.calculatedStacks.get(slot);
            int multiplier = this.getPrevSlotMultiplier(slot);
            int countSet = calculatedStack.getCount() - (extractCount *= multiplier);
            countSet = this.getCountChangeLeavingSpaceBeforeMaxInt(countSet, slot, calculatedStack);
            calculatedStack.setCount(countSet);
            this.setCalculatedStack(slot, calculatedStack);
            ++slot;
        }
    }

    public int insert(int slot, ItemResource resource, int amount, TransactionContext tx, IResourceInserter insertSuper) {
        return this.insertItem(slot, resource, amount, tx);
    }

    private int insertItem(int slot, ItemResource resource, int amount, TransactionContext tx) {
        if (this.canNotBeInserted(slot, resource)) {
            return 0;
        }
        Map<Integer, SlotDefinition> definitions = this.slotDefinitions;
        if (definitions.isEmpty()) {
            definitions = this.getSlotDefinitions(resource.toStack(amount), slot, Map.of());
        }
        SlotDefinition slotDefinition = definitions.get(slot);
        int limit = this.getStackLimit(slotDefinition);
        int currentCalculatedCount = this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot).getCount() : 0;
        int inserted = Math.min(Math.max(this.parent.getBaseCapacity(slotDefinition.itemResource()) - this.parent.getInternalStack(slot).getCount(), limit - currentCalculatedCount), amount);
        if (inserted == 0) {
            return 0;
        }
        this.journal.updateSnapshots(tx);
        if (!this.slotDefinitions.containsKey(slot)) {
            this.setSlotDefinitions(definitions, false);
            this.compactInternalSlots();
            this.updateCalculatedStacks();
            this.slotDefinitions.forEach((s, definition) -> this.parent.triggerOnChangeListeners(s.intValue()));
            slotDefinition = this.slotDefinitions.get(slot);
        }
        if (this.slotDefinitions.get(slot).isCompressible()) {
            this.insertIntoInternalAndCalculated(slot, inserted);
        } else if (inserted > 0) {
            ItemStack newCalculatedStack;
            if (this.calculatedStacks.containsKey(slot) && !this.calculatedStacks.get(slot).isEmpty()) {
                newCalculatedStack = this.calculatedStacks.get(slot);
                newCalculatedStack.grow(inserted);
            } else {
                newCalculatedStack = resource.toStack(inserted);
            }
            this.setCalculatedStack(slot, newCalculatedStack);
            ItemStack slotStack = this.parent.getInternalStack(slot);
            if (slotStack.isEmpty()) {
                ItemStack copy = slotDefinition.itemResource().toStack(inserted);
                this.parent.setStackInSlotInternal(slot, copy);
            } else {
                slotStack.grow(inserted);
                this.parent.setStackInSlotInternal(slot, slotStack);
            }
        }
        return inserted;
    }

    private boolean canNotBeInserted(int slot, ItemResource resource) {
        if (resource.isEmpty()) {
            return true;
        }
        if (!this.slotDefinitions.containsKey(slot)) {
            return false;
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return !slotDefinition.isAccessible() || !slotDefinition.itemResource().equals((Object)resource);
    }

    private void insertIntoInternalAndCalculated(int slotToStartFrom, long amountToInsert) {
        LinkedHashMap<Integer, Integer> toUpdate = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> calculatedAdditions = new LinkedHashMap<Integer, Integer>();
        int totalMultiplier = 1;
        int slot = slotToStartFrom;
        long amountToSet = amountToInsert + (long)this.parent.getInternalStack(slot).getCount();
        while (amountToSet / ((long)totalMultiplier * (long)this.getPrevSlotMultiplier(slot)) > 0L && this.slotDefinitions.containsKey(slot - 1) && this.slotDefinitions.get(slot - 1).isAccessible()) {
            amountToSet += (long)this.parent.getInternalStack(--slot).getCount() * (long)(totalMultiplier *= this.getPrevSlotMultiplier(slot));
        }
        long calculatedAddition = 0L;
        while (slot <= slotToStartFrom) {
            calculatedAddition *= (long)this.getPrevSlotMultiplier(slot);
            ItemResource slotResource = this.parent.getResource(slot);
            int toSet = (int)Math.min(amountToSet / (long)totalMultiplier, (long)this.parent.getBaseCapacity(slotResource));
            calculatedAdditions.put(slot, (int)Math.min(calculatedAddition += (long)(toSet - this.parent.getInternalStack(slot).getCount()), Integer.MAX_VALUE));
            if (toSet > 0) {
                toUpdate.put(slot, toSet);
                amountToSet -= (long)toSet * (long)totalMultiplier;
            } else {
                toUpdate.put(slot, 0);
            }
            if (amountToSet != 0L) {
                if (!this.slotDefinitions.containsKey(slot + 1) || !this.slotDefinitions.get(slot + 1).isAccessible()) {
                    SophisticatedStorage.LOGGER.error("Compression inventory is in an invalid state. Slot {} has a prevSlotMultiplier of 0 (likely because it's inaccessible), but there's remaining count of {} to insert.\nSlot Definitions\n{}", (Object)(slot + 1), (Object)amountToSet, this.slotDefinitions);
                    break;
                }
                totalMultiplier /= this.getPrevSlotMultiplier(slot + 1);
            }
            ++slot;
        }
        while (slot < this.slotRange.firstSlot() + this.slotRange.size() && this.slotDefinitions.containsKey(slot)) {
            calculatedAdditions.put(slot, (int)Math.min(calculatedAddition *= (long)this.getPrevSlotMultiplier(slot), Integer.MAX_VALUE));
            ++slot;
        }
        this.updateInternalStacksWithCounts(toUpdate);
        calculatedAdditions.forEach(this::addToCalculatedStack);
        toUpdate.keySet().forEach(arg_0 -> ((InventoryHandler)this.parent).triggerOnChangeListeners(arg_0));
    }

    private void addToCalculatedStack(int slot, int countToAdd) {
        if (!this.calculatedStacks.containsKey(slot) || this.calculatedStacks.get(slot).isEmpty()) {
            SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
            this.setCalculatedStack(slot, slotDefinition.itemResource().toStack(countToAdd));
            return;
        }
        ItemStack currentCalculated = this.calculatedStacks.get(slot);
        int totalCalculated = Integer.MAX_VALUE - countToAdd < currentCalculated.getCount() ? Integer.MAX_VALUE : currentCalculated.getCount() + countToAdd;
        int previousSlot = slot - 1;
        if (totalCalculated != Integer.MAX_VALUE || !this.slotDefinitions.containsKey(previousSlot)) {
            currentCalculated.setCount(totalCalculated);
            this.setCalculatedStack(slot, currentCalculated);
            return;
        }
        ItemStack previousInternalStack = this.parent.getInternalStack(previousSlot);
        boolean isPreviousFull = previousInternalStack.getCount() >= this.parent.getBaseCapacity(this.slotDefinitions.get(previousSlot).itemResource());
        int internalLimit = this.parent.getBaseCapacity(this.slotDefinitions.get(slot).itemResource());
        int internalCount = this.parent.getInternalStack(slot).getCount();
        int maxStackSize = previousInternalStack.getMaxStackSize();
        int spaceBeforeMaxInt = isPreviousFull ? Math.min(maxStackSize, internalLimit - internalCount) : maxStackSize;
        currentCalculated.setCount(Integer.MAX_VALUE - spaceBeforeMaxInt);
    }

    public void set(int slot, ItemResource resource, int amount, IndexModifier<ItemResource> setSuper) {
        if (!resource.isEmpty() && this.canNotBeInserted(slot, resource)) {
            return;
        }
        int currentCount = this.lastCalculatedCounts.getOrDefault(slot, 0);
        if (currentCount != (this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot).getCount() : 0)) {
            this.setCalculatedStack(slot, this.slotDefinitions.get(slot).itemResource().toStack(currentCount));
        }
        try (Transaction tx = Transaction.openRoot();){
            if (currentCount < amount) {
                this.insertItem(slot, resource, amount - currentCount, (TransactionContext)tx);
            } else if (currentCount > amount) {
                this.extractItem(slot, this.slotDefinitions.get((Object)Integer.valueOf((int)slot)).itemResource, currentCount - amount, (TransactionContext)tx, s -> Integer.MAX_VALUE);
            }
            tx.commit();
        }
    }

    public void setStackInSlot(int slot, ItemStack stack, BiConsumer<Integer, ItemStack> setStackInSlotInternal) {
        this.set(slot, ItemResource.of((ItemStack)stack), stack.getCount(), (IndexModifier<ItemResource>)((IndexModifier)(s, resource, amount) -> {}));
    }

    public boolean isValid(int slot, ItemResource resource, @Nullable Player player, BiPredicate<Integer, ItemResource> isValidSuper) {
        if (!this.slotDefinitions.containsKey(slot)) {
            return true;
        }
        SlotDefinition slotDefinition = this.slotDefinitions.get(slot);
        return slotDefinition.isAccessible() && slotDefinition.itemResource().equals((Object)resource);
    }

    public ItemStack getStackInSlot(int slot, IntFunction<ItemStack> getStackInSlotSuper) {
        return this.getCalculatedStackInSlot(slot);
    }

    private ItemStack getCalculatedStackInSlot(int slot) {
        return this.slotDefinitions.containsKey(slot) && this.slotDefinitions.get(slot).isAccessible() && this.calculatedStacks.containsKey(slot) ? this.calculatedStacks.get(slot) : ItemStack.EMPTY;
    }

    public ItemResource getResource(int index, IntFunction<ItemResource> getResourceSuper) {
        return ItemResource.of((ItemStack)this.getCalculatedStackInSlot(index));
    }

    public long getAmountAsLong(int index, IntFunction<Long> amountAsLongSuper) {
        return this.getCalculatedStackInSlot(index).getCount();
    }

    public boolean isSlotAccessible(int slot) {
        return !this.slotDefinitions.containsKey(slot) || this.slotDefinitions.get(slot).isAccessible();
    }

    public int size() {
        return this.slotRange.size();
    }

    public String getName() {
        return NAME;
    }

    public @Nullable Identifier getNoItemIcon(int slot) {
        return EMPTY_COMPRESSION_SLOT;
    }

    public Item getFilterItem(int slot) {
        return this.slotDefinitions.containsKey(slot) ? this.slotDefinitions.get(slot).itemResource().getItem() : Items.AIR;
    }

    public void onSlotLimitChange() {
        this.updateSlotLimits(this.slotDefinitions);
    }

    public Set<Integer> getNoSortSlots() {
        return IntStream.rangeClosed(this.slotRange.firstSlot(), this.slotRange.firstSlot() + this.slotRange.size() - 1).boxed().collect(Collectors.toSet());
    }

    public void onSlotFilterChanged(int slot) {
        this.calculateStacks(false);
    }

    public boolean isFilterItem(Item item) {
        for (SlotDefinition slotDefinition : this.slotDefinitions.values()) {
            if (slotDefinition.itemResource().getItem() != item) continue;
            return true;
        }
        return false;
    }

    public Map<Item, Set<Integer>> getFilterItems() {
        HashMap<Item, Set<Integer>> filterItems = new HashMap<Item, Set<Integer>>();
        for (Map.Entry<Integer, SlotDefinition> entry : this.slotDefinitions.entrySet()) {
            SlotDefinition slotDefinition = entry.getValue();
            if (!slotDefinition.isAccessible()) continue;
            filterItems.computeIfAbsent(slotDefinition.itemResource().getItem(), k -> new HashSet()).add(entry.getKey());
        }
        return filterItems;
    }

    private class CompressionJournal
    extends SnapshotJournal<CompressionSnapshot> {
        private CompressionJournal() {
        }

        protected CompressionSnapshot createSnapshot() {
            HashMap<Integer, ItemStack> internalStacks = new HashMap<Integer, ItemStack>();
            for (int slot2 = CompressionInventoryPart.this.slotRange.firstSlot(); slot2 < CompressionInventoryPart.this.slotRange.firstSlot() + CompressionInventoryPart.this.slotRange.size(); ++slot2) {
                internalStacks.put(slot2, CompressionInventoryPart.this.parent.getInternalStack(slot2).copy());
            }
            HashMap<Integer, ItemStack> calculatedStacksCopy = new HashMap<Integer, ItemStack>();
            CompressionInventoryPart.this.calculatedStacks.forEach((slot, stack) -> calculatedStacksCopy.put((Integer)slot, stack.copy()));
            return new CompressionSnapshot(new HashMap<Integer, SlotDefinition>(CompressionInventoryPart.this.slotDefinitions), calculatedStacksCopy, internalStacks);
        }

        protected void revertToSnapshot(CompressionSnapshot compressionSnapshot) {
            CompressionInventoryPart.this.slotDefinitions = compressionSnapshot.slotDefinitions;
            compressionSnapshot.calculatedStacks.forEach(CompressionInventoryPart.this::setCalculatedStack);
            compressionSnapshot.internalStacks.forEach((slot, stack) -> CompressionInventoryPart.this.parent.setStackInSlotInternal(slot.intValue(), stack.copy()));
        }
    }

    private static final class SlotDefinition {
        private final ItemResource itemResource;
        private final int prevSlotMultiplier;
        private int slotLimit;
        private final boolean isAccessible;
        private boolean isCompressible = false;

        private SlotDefinition(ItemResource itemResource, int prevSlotMultiplier, int slotLimit, boolean isAccessible) {
            this.itemResource = itemResource;
            this.prevSlotMultiplier = prevSlotMultiplier;
            this.slotLimit = slotLimit;
            this.isAccessible = isAccessible;
        }

        public static SlotDefinition inaccesible() {
            return new SlotDefinition(ItemResource.EMPTY, 0, 0, false);
        }

        public SlotDefinition(ItemStack stack, int prevSlotMultiplier, boolean isAccessible) {
            this(ItemResource.of((ItemStack)stack), prevSlotMultiplier, -1, isAccessible);
        }

        public void setSlotLimit(int slotLimit) {
            this.slotLimit = slotLimit;
        }

        public void setCompressible(boolean compressible) {
            this.isCompressible = compressible;
        }

        public ItemResource itemResource() {
            return this.itemResource;
        }

        public int prevSlotMultiplier() {
            return this.prevSlotMultiplier;
        }

        public int slotLimit() {
            return this.slotLimit;
        }

        public boolean isAccessible() {
            return this.isAccessible;
        }

        public boolean isCompressible() {
            return this.isCompressible;
        }

        public String toString() {
            return "SlotDefinition{itemReosurce=" + String.valueOf(this.itemResource) + ", prevSlotMultiplier=" + this.prevSlotMultiplier + ", slotLimit=" + this.slotLimit + ", isAccessible=" + this.isAccessible + ", isCompressible=" + this.isCompressible + "}";
        }
    }

    private record CompressionSnapshot(Map<Integer, SlotDefinition> slotDefinitions, Map<Integer, ItemStack> calculatedStacks, Map<Integer, ItemStack> internalStacks) {
    }
}

