/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import org.jspecify.annotations.Nullable;

public class DecorationHelper {
    public static final int BLOCK_TOTAL_PARTS = 24;
    private static final int MAIN_COLOR_PARTS = 18;
    private static final int ACCENT_COLOR_PARTS = 6;
    private static final Map<BarrelMaterial, Integer> DECORATIVE_SLOT_PARTS_NEEDED = Map.of(BarrelMaterial.TOP_INNER_TRIM, 1, BarrelMaterial.TOP_TRIM, 1, BarrelMaterial.SIDE_TRIM, 4, BarrelMaterial.BOTTOM_TRIM, 1, BarrelMaterial.TOP, 3, BarrelMaterial.SIDE, 12, BarrelMaterial.BOTTOM, 3);

    private DecorationHelper() {
    }

    public static Optional<Identifier> getMaterialLocation(Item item) {
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return Optional.of(BuiltInRegistries.BLOCK.getKey((Object)blockItem.getBlock()));
        }
        return Optional.empty();
    }

    public static boolean consumeDyes(int mainColorBeingSet, int accentColorBeingSet, Map<Identifier, Integer> remainingParts, SnapshotJournal<Map<Identifier, Integer>> remainingPartsJournal, List<ResourceHandler<ItemResource>> dyes, Integer storageMainColor, Integer storageAccentColor, TransactionContext tx) {
        Map<TagKey<Item>, Integer> partsNeeded = DecorationHelper.getDyePartsNeeded(mainColorBeingSet, accentColorBeingSet, storageMainColor, storageAccentColor);
        if (partsNeeded.isEmpty()) {
            return true;
        }
        return DecorationHelper.consumeDyePartsNeeded(partsNeeded, dyes, remainingParts, remainingPartsJournal, tx).hasEnough();
    }

    public static Map<TagKey<Item>, Integer> getDyePartsNeeded(int mainColorBeingSet, int accentColorBeingSet, int storageMainColor, int storageAccentColor) {
        return DecorationHelper.getDyePartsNeeded(mainColorBeingSet, accentColorBeingSet, storageMainColor, storageAccentColor, 18, 6);
    }

    public static Map<TagKey<Item>, Integer> getDyePartsNeeded(int mainColorBeingSet, int accentColorBeingSet, int storageMainColor, int storageAccentColor, int mainColorParts, int accentColorParts) {
        int[] rgbPartsNeeded;
        HashMap<TagKey<Item>, Integer> partsNeeded = new HashMap<TagKey<Item>, Integer>();
        if (mainColorBeingSet != -1 && mainColorBeingSet != storageMainColor) {
            rgbPartsNeeded = DecorationHelper.calculateRGBPartsNeeded(mainColorBeingSet, mainColorParts);
            DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded, partsNeeded);
        }
        if (accentColorBeingSet != -1 && accentColorBeingSet != storageAccentColor) {
            rgbPartsNeeded = DecorationHelper.calculateRGBPartsNeeded(accentColorBeingSet, accentColorParts);
            DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded, partsNeeded);
        }
        return partsNeeded;
    }

    private static void addPartsNeededIfAny(int[] rgbPartsNeeded, Map<TagKey<Item>, Integer> partsNeeded) {
        DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded[0], partsNeeded, (TagKey<Item>)Tags.Items.DYES_RED);
        DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded[1], partsNeeded, (TagKey<Item>)Tags.Items.DYES_GREEN);
        DecorationHelper.addPartsNeededIfAny(rgbPartsNeeded[2], partsNeeded, (TagKey<Item>)Tags.Items.DYES_BLUE);
    }

    private static void addPartsNeededIfAny(int parts, Map<TagKey<Item>, Integer> partsNeeded, TagKey<Item> dyeName) {
        if (parts != 0) {
            partsNeeded.compute(dyeName, (location, partsTotal) -> partsTotal == null ? parts : partsTotal + parts);
        }
    }

    private static int[] calculateRGBPartsNeeded(int color, int totalParts) {
        int i2;
        float[] ratios = new float[]{(float)ARGB.red((int)color) / 255.0f, (float)ARGB.green((int)color) / 255.0f, (float)ARGB.blue((int)color) / 255.0f};
        float totalRaios = ratios[0] + ratios[1] + ratios[2];
        ratios[0] = ratios[0] / totalRaios;
        ratios[1] = ratios[1] / totalRaios;
        ratios[2] = ratios[2] / totalRaios;
        int n = ratios.length;
        int[] result = new int[n];
        double[] remainders = new double[n];
        double[] scaled = new double[n];
        for (int i3 = 0; i3 < n; ++i3) {
            scaled[i3] = ratios[i3] * (float)totalParts;
            result[i3] = (int)scaled[i3];
            remainders[i3] = scaled[i3] - (double)result[i3];
        }
        int remaining = totalParts - Arrays.stream(result).sum();
        Integer[] indices = new Integer[n];
        for (i2 = 0; i2 < n; ++i2) {
            indices[i2] = i2;
        }
        Arrays.sort(indices, Comparator.comparingDouble(i -> -remainders[i]));
        for (i2 = 0; i2 < remaining; ++i2) {
            int n2 = indices[i2 % n];
            result[n2] = result[n2] + 1;
        }
        return result;
    }

    public static boolean consumeMaterials(Map<Identifier, Integer> remainingParts, SnapshotJournal<Map<Identifier, Integer>> remainingPartsJournal, List<ResourceHandler<ItemResource>> decorativeBlocks, Map<BarrelMaterial, Identifier> originalMaterials, Map<BarrelMaterial, Identifier> materials, TransactionContext tx) {
        Map<Identifier, Integer> partsNeeded = DecorationHelper.getMaterialPartsNeeded(originalMaterials, materials);
        return DecorationHelper.consumeMaterialPartsNeeded(partsNeeded, remainingParts, remainingPartsJournal, decorativeBlocks, tx).hasEnough();
    }

    public static ConsumptionResult consumeMaterialPartsNeeded(Map<Identifier, Integer> partsNeeded, Map<Identifier, Integer> remainingParts, SnapshotJournal<Map<Identifier, Integer>> remainingPartsJournal, List<ResourceHandler<ItemResource>> decorativeBlocks, TransactionContext tx) {
        return DecorationHelper.consumePartsNeeded(partsNeeded, decorativeBlocks, location -> location, (materialLocation, stack) -> DecorationHelper.getMaterialLocation(stack.getItem()).map(ml -> ml.equals(materialLocation)).orElse(false), remainingParts, remainingPartsJournal, tx);
    }

    public static Map<Identifier, Integer> getMaterialPartsNeeded(Map<BarrelMaterial, Identifier> originalMaterials, Map<BarrelMaterial, Identifier> materialsToApply) {
        HashMap<Identifier, Integer> partsNeeded = new HashMap<Identifier, Integer>();
        BarrelBlockItem.uncompactMaterials(materialsToApply);
        Identifier topInnerTrimMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.TOP_INNER_TRIM, null, partsNeeded, originalMaterials);
        Identifier topTrimMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.TOP_TRIM, topInnerTrimMaterialLocation, partsNeeded, originalMaterials);
        Identifier sideTrimMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.SIDE_TRIM, topTrimMaterialLocation, partsNeeded, originalMaterials);
        DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.BOTTOM_TRIM, sideTrimMaterialLocation, partsNeeded, originalMaterials);
        Identifier topMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.TOP, topTrimMaterialLocation, partsNeeded, originalMaterials);
        Identifier sideMaterialLocation = DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.SIDE, topMaterialLocation, partsNeeded, originalMaterials);
        DecorationHelper.addMaterialCostForSlotAndGetMaterial(materialsToApply, BarrelMaterial.BOTTOM, sideMaterialLocation, partsNeeded, originalMaterials);
        return partsNeeded;
    }

    private static @Nullable Identifier addMaterialCostForSlotAndGetMaterial(Map<BarrelMaterial, Identifier> materials, BarrelMaterial barrelMaterial, @Nullable Identifier defaultMaterialLocation, Map<Identifier, Integer> partsNeeded, Map<BarrelMaterial, Identifier> originalMaterials) {
        boolean materialIsTheSame = Objects.deepEquals(originalMaterials.get((Object)barrelMaterial), materials.get((Object)barrelMaterial));
        boolean newHasNoMaterial = !materials.containsKey((Object)barrelMaterial);
        boolean hasNoCost = barrelMaterial == BarrelMaterial.TOP_TRIM && defaultMaterialLocation != null || materialIsTheSame || newHasNoMaterial;
        Identifier materialLocation = materials.getOrDefault((Object)barrelMaterial, defaultMaterialLocation);
        if (hasNoCost) {
            return materialLocation;
        }
        if (materialLocation != null) {
            int parts = DECORATIVE_SLOT_PARTS_NEEDED.get((Object)barrelMaterial);
            partsNeeded.compute(materialLocation, (key, value) -> value == null ? parts : value + parts);
        }
        return materialLocation;
    }

    public static ConsumptionResult consumeDyePartsNeeded(Map<TagKey<Item>, Integer> partsNeeded, List<ResourceHandler<ItemResource>> resourceHandlers, Map<Identifier, Integer> remainingParts, SnapshotJournal<Map<Identifier, Integer>> remainingPartsJournal, TransactionContext tx) {
        return DecorationHelper.consumePartsNeeded(partsNeeded, resourceHandlers, TagKey::location, (dyeName, resource) -> resource.is(dyeName), remainingParts, remainingPartsJournal, tx);
    }

    private static <T> ConsumptionResult consumePartsNeeded(Map<T, Integer> partsNeeded, List<ResourceHandler<ItemResource>> resourceHandlers, Function<T, Identifier> locationGetter, BiPredicate<T, ItemResource> resourceMatcher, Map<Identifier, Integer> remainingParts, SnapshotJournal<Map<Identifier, Integer>> remainingPartsJournal, TransactionContext tx) {
        HashMap<Identifier, Integer> missingParts = new HashMap<Identifier, Integer>();
        for (Map.Entry<T, Integer> entry : partsNeeded.entrySet()) {
            SingleItemConsumptionResult singleItemConsumptionResult;
            T material = entry.getKey();
            Integer parts = entry.getValue();
            Identifier materialLocation = locationGetter.apply(material);
            int remainingPartCount = remainingParts.getOrDefault(materialLocation, 0);
            if (remainingPartCount > parts) {
                remainingPartsJournal.updateSnapshots(tx);
                remainingParts.put(materialLocation, remainingPartCount - parts);
                continue;
            }
            remainingPartsJournal.updateSnapshots(tx);
            remainingParts.remove(materialLocation);
            if (remainingPartCount == parts || (singleItemConsumptionResult = DecorationHelper.consumeFromHandlers(resourceHandlers, resourceMatcher, remainingParts, remainingPartsJournal, tx, material, parts = Integer.valueOf(parts - remainingPartCount), materialLocation)).hasEnough()) continue;
            missingParts.put(materialLocation, singleItemConsumptionResult.countMissing());
        }
        return new ConsumptionResult(missingParts.isEmpty(), missingParts);
    }

    private static <T> SingleItemConsumptionResult consumeFromHandlers(List<ResourceHandler<ItemResource>> resourceHandlers, BiPredicate<T, ItemResource> resourceMatcher, Map<Identifier, Integer> remainingParts, SnapshotJournal<Map<Identifier, Integer>> remainingPartsJournal, TransactionContext tx, T material, Integer parts, Identifier materialLocation) {
        for (ResourceHandler<ItemResource> resources : resourceHandlers) {
            for (int slot = 0; slot < resources.size(); ++slot) {
                ItemResource resource = (ItemResource)resources.getResource(slot);
                if (!resourceMatcher.test(material, resource)) continue;
                int toRemove = Math.ceilDiv(parts, 24);
                int removed = resources.extract(slot, (Resource)resource, toRemove, tx);
                int partsRemoved = removed * 24;
                if (partsRemoved >= parts) {
                    if (partsRemoved > parts) {
                        remainingPartsJournal.updateSnapshots(tx);
                        remainingParts.put(materialLocation, partsRemoved - parts);
                    }
                    return new SingleItemConsumptionResult(true, 0);
                }
                parts = parts - partsRemoved;
            }
        }
        return new SingleItemConsumptionResult(false, parts);
    }

    public record ConsumptionResult(boolean hasEnough, Map<Identifier, Integer> missingParts) {
    }

    private record SingleItemConsumptionResult(boolean hasEnough, int countMissing) {
    }
}

