/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.render.gui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import team.creative.creativecore.client.render.gui.ColorRect;
import team.creative.creativecore.client.render.gui.ColorRectF;
import team.creative.creativecore.client.render.gui.HorizontalGradientRect;
import team.creative.creativecore.client.render.gui.HorizontalGradientRectF;
import team.creative.creativecore.client.render.gui.VerticalGradientRect;
import team.creative.creativecore.client.render.gui.VerticalGradientRectF;

@Environment(value=EnvType.CLIENT)
public interface CreativeGuiGraphics {
    public static CreativeGuiGraphics as(GuiGraphics graphics) {
        return (CreativeGuiGraphics)graphics;
    }

    default public void drawStringCentered(String text, float width, float height, int color, boolean shadow) {
        int dotWith;
        Minecraft minecraft = this.minecraft();
        int textWidth = minecraft.font.width((String)text);
        if ((float)textWidth > width && textWidth > (dotWith = minecraft.font.width("..."))) {
            int charWidth;
            StringBuilder builder = new StringBuilder();
            textWidth = 0;
            for (int i = 0; i < ((String)text).length() && (float)((charWidth = minecraft.font.width("" + ((String)text).charAt(i))) + textWidth + dotWith) < width; ++i) {
                builder.append(((String)text).charAt(i));
                textWidth += charWidth;
            }
            text = String.valueOf(builder) + "...";
        }
        GuiGraphics guiGraphics = this.as();
        Font font = minecraft.font;
        int n = (int)(width / 2.0f - (float)(minecraft.font.width((String)text) / 2));
        float f = height / 2.0f;
        Objects.requireNonNull(minecraft.font);
        guiGraphics.drawString(font, (String)text, n, (int)(f - (float)(9 / 2)), -1, shadow);
    }

    default public void drawString(FormattedCharSequence text, int x, int y, int color, int shadowColor, boolean shadow) {
        if (ARGB.alpha((int)color) != 0) {
            this.guiRenderState().submitText(new GuiTextRenderState(this.font(), text, (Matrix3x2fc)new Matrix3x2f((Matrix3x2fc)this.pose()), x, y, color, shadowColor, shadow, true, this.peekScissor()));
        }
    }

    default public void horizontalGradientRect(int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        this.guiRenderState().submitGuiElement((GuiElementRenderState)new HorizontalGradientRect(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void horizontalGradientRect(float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        this.guiRenderState().submitGuiElement((GuiElementRenderState)new HorizontalGradientRectF(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void verticalGradientRect(int x, int y, int x2, int y2, int colorFrom, int colorTo) {
        this.guiRenderState().submitGuiElement((GuiElementRenderState)new VerticalGradientRect(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void verticalGradientRect(float x, float y, float x2, float y2, int colorFrom, int colorTo) {
        this.guiRenderState().submitGuiElement((GuiElementRenderState)new VerticalGradientRectF(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)this.pose(), x, y, x2, y2, colorFrom, colorTo, this.peekScissor()));
    }

    default public void horizontalGradientMaskRect(int x, int y, int x2, int y2, int color, int mask) {
        this.horizontalGradientRect(x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    default public void horizontalGradientMaskRect(float x, float y, float x2, float y2, int color, int mask) {
        this.horizontalGradientRect(x, y, x2, y2, color & ~mask | 0xFF000000, color | 0xFF000000 | mask);
    }

    default public void colorRect(int x, int y, int width, int height, int color) {
        this.guiRenderState().submitGuiElement((GuiElementRenderState)new ColorRect(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)this.pose(), x, y, x + width, y + height, color, this.peekScissor()));
    }

    default public void colorRect(float x, float y, float width, float height, int color) {
        this.guiRenderState().submitGuiElement((GuiElementRenderState)new ColorRectF(RenderPipelines.GUI, TextureSetup.noTexture(), (Matrix3x2f)this.pose(), x, y, x + width, y + height, color, this.peekScissor()));
    }

    default public void textureRect(Identifier location, int x, int y, int width, int height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(RenderPipelines.GUI_TEXTURED, location, x, x + width, y, y + height, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight, -1);
    }

    default public void textureRect(Identifier location, float x, float y, float width, float height, float u, float v) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(RenderPipelines.GUI_TEXTURED, location, (int)x, (int)(x + width), (int)y, (int)(y + height), u / (float)textureWidth, (u + width) / (float)textureWidth, v / (float)textureHeight, (v + height) / (float)textureHeight, -1);
    }

    default public void textureRect(Identifier location, int x, int y, int width, int height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(RenderPipelines.GUI_TEXTURED, location, x, x + width, y, y + height, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight, -1);
    }

    default public void textureRect(Identifier location, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(RenderPipelines.GUI_TEXTURED, location, (int)x, (int)(x + width), (int)y, (int)(y + height), u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight, -1);
    }

    default public void textureRectColor(Identifier location, int x, int y, int width, int height, float u, float v, float u2, float v2, int color) {
        int textureWidth = 256;
        int textureHeight = 256;
        this.blit(RenderPipelines.GUI_TEXTURED, location, x, x + width, y, y + height, u / (float)textureWidth, u2 / (float)textureWidth, v / (float)textureHeight, v2 / (float)textureHeight, color);
    }

    default public void textureRectStrechted(Identifier location, int x, int y, int width, int height) {
        this.blit(RenderPipelines.GUI_TEXTURED, location, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, -1);
    }

    default public void textureRectColorStretched(Identifier location, int x, int y, int width, int height, int color) {
        this.blit(RenderPipelines.GUI_TEXTURED, location, x, x + width, y, y + height, 0.0f, 1.0f, 0.0f, 1.0f, color);
    }

    default public void renderItemDecorations(ItemStack stack, int x, int y) {
        this.as().renderItemDecorations(this.font(), stack, x, y);
    }

    default public void renderItemDecorations(ItemStack stack, int x, int y, @Nullable String text) {
        this.as().renderItemDecorations(this.font(), stack, x, y, text);
    }

    public void blit(RenderPipeline var1, Identifier var2, int var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10, int var11);

    public GuiGraphics as();

    public Minecraft minecraft();

    public Matrix3x2fStack pose();

    public Font font();

    public GuiRenderState guiRenderState();

    public ScreenRectangle peekScissor();

    public void setOverrideScissor(@Nullable ScreenRectangle var1);

    public void clearOverrideScissor();
}

