/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.Identifier;

public class LocatedHandlerRegistry<T> {
    private final HashMap<Identifier, T> handlers = new LinkedHashMap<Identifier, T>();
    private final HashMap<T, Identifier> handlersInv = new LinkedHashMap<T, Identifier>();
    private T defaultHandler;
    private boolean allowOverwrite = false;

    public LocatedHandlerRegistry(T handler) {
        this.defaultHandler = handler;
    }

    public LocatedHandlerRegistry<T> allowOverwrite() {
        this.allowOverwrite = true;
        return this;
    }

    public T getDefault() {
        return this.defaultHandler;
    }

    public void register(Identifier id, T handler) {
        if (!this.allowOverwrite && this.handlers.containsKey(id)) {
            throw new IllegalArgumentException("'" + String.valueOf(id) + "' already exists");
        }
        this.handlers.put(id, handler);
        this.handlersInv.put(handler, id);
    }

    public void registerDefault(Identifier id, T handler) {
        this.defaultHandler = handler;
        this.register(id, handler);
    }

    public Identifier getLocation(T type) {
        return this.handlersInv.get(type);
    }

    public T get(Identifier id) {
        return this.handlers.getOrDefault(id, this.defaultHandler);
    }

    public T getOrThrow(Identifier id) {
        T handler = this.handlers.get(id);
        if (handler == null) {
            throw new IllegalArgumentException("'" + String.valueOf(id) + "' does not exist");
        }
        return handler;
    }

    public boolean contains(Identifier id) {
        return this.handlers.containsKey(id);
    }

    public Collection<Identifier> keys() {
        return this.handlers.keySet();
    }

    public Set<Map.Entry<Identifier, T>> entrySet() {
        return this.handlers.entrySet();
    }

    public Collection<T> values() {
        return this.handlers.values();
    }
}

