/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.surface;

import com.google.common.collect.Sets;
import com.terraformersmc.biolith.impl.Biolith;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.Nullable;

public class SurfaceRuleCollector {
    public static final SurfaceRuleCollector END = new SurfaceRuleCollector();
    public static final SurfaceRuleCollector NETHER = new SurfaceRuleCollector();
    public static final SurfaceRuleCollector OVERWORLD = new SurfaceRuleCollector();
    private final HashMap<Identifier, List<SurfaceRules.RuleSource>> MATERIAL_RULES_DATA = new HashMap(16);
    private final HashMap<Identifier, List<SurfaceRules.RuleSource>> MATERIAL_RULES_MODS = new HashMap(16);

    public void addFromData(Identifier ruleOwner, SurfaceRules.RuleSource ... materialRules) {
        if (materialRules.length > 0) {
            this.MATERIAL_RULES_DATA.computeIfAbsent(ruleOwner, ignored -> new ArrayList(4)).addAll(Arrays.stream(materialRules).toList());
        } else {
            Biolith.LOGGER.warn("Request to add empty surface rule set with ID of '{}'", (Object)ruleOwner);
        }
    }

    public void addFromMods(Identifier ruleOwner, SurfaceRules.RuleSource ... materialRules) {
        if (materialRules.length > 0) {
            this.MATERIAL_RULES_MODS.computeIfAbsent(ruleOwner, ignored -> new ArrayList(4)).addAll(Arrays.stream(materialRules).toList());
        } else {
            Biolith.LOGGER.warn("Request to add empty surface rule set with ID of '{}'", (Object)ruleOwner);
        }
    }

    public void clearFromData() {
        this.MATERIAL_RULES_DATA.clear();
    }

    public void clearFromMods() {
        this.MATERIAL_RULES_MODS.clear();
    }

    @Nullable
    public SurfaceRules.RuleSource get(Identifier ruleOwner) {
        if (this.MATERIAL_RULES_DATA.containsKey(ruleOwner)) {
            if (this.MATERIAL_RULES_DATA.get(ruleOwner).size() > 1) {
                SurfaceRules.RuleSource[] rules = new SurfaceRules.RuleSource[]{};
                return SurfaceRules.sequence((SurfaceRules.RuleSource[])this.MATERIAL_RULES_DATA.get(ruleOwner).toArray(rules));
            }
            return this.MATERIAL_RULES_DATA.get(ruleOwner).get(0);
        }
        if (this.MATERIAL_RULES_MODS.containsKey(ruleOwner)) {
            if (this.MATERIAL_RULES_MODS.get(ruleOwner).size() > 1) {
                SurfaceRules.RuleSource[] rules = new SurfaceRules.RuleSource[]{};
                return SurfaceRules.sequence((SurfaceRules.RuleSource[])this.MATERIAL_RULES_MODS.get(ruleOwner).toArray(rules));
            }
            return this.MATERIAL_RULES_MODS.get(ruleOwner).get(0);
        }
        return null;
    }

    private SurfaceRules.RuleSource getFromData(Identifier ruleOwner) {
        if (this.MATERIAL_RULES_DATA.get(ruleOwner).size() > 1) {
            SurfaceRules.RuleSource[] rules = new SurfaceRules.RuleSource[]{};
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])this.MATERIAL_RULES_DATA.get(ruleOwner).toArray(rules));
        }
        return this.MATERIAL_RULES_DATA.get(ruleOwner).get(0);
    }

    private SurfaceRules.RuleSource getFromMods(Identifier ruleOwner) {
        if (this.MATERIAL_RULES_MODS.get(ruleOwner).size() > 1) {
            SurfaceRules.RuleSource[] rules = new SurfaceRules.RuleSource[]{};
            return SurfaceRules.sequence((SurfaceRules.RuleSource[])this.MATERIAL_RULES_MODS.get(ruleOwner).toArray(rules));
        }
        return this.MATERIAL_RULES_MODS.get(ruleOwner).get(0);
    }

    public SurfaceRules.RuleSource[] getAll() {
        SurfaceRules.RuleSource[] rulesType = new SurfaceRules.RuleSource[]{};
        return this.getRuleOwners().stream().map(key -> this.MATERIAL_RULES_DATA.containsKey(key) ? this.getFromData((Identifier)key) : this.getFromMods((Identifier)key)).toList().toArray(rulesType);
    }

    public Set<Identifier> getRuleOwners() {
        return Sets.union(this.MATERIAL_RULES_DATA.keySet(), this.MATERIAL_RULES_MODS.keySet());
    }

    public int getRuleCount() {
        return this.getRuleOwners().size();
    }
}

