/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.unlocked_typing.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractSignEditScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractSignEditScreen.class})
public abstract class AbstractSignEditScreenMixin {
    @Unique
    private static final int UNLOCKED_TYPING$OFFSET = 100;
    @Unique
    private static FormattedCharSequence unlocked_typing$preformattedTextTitle;
    @Unique
    private static String unlocked_typing$preformattedTextTitleString;
    @Shadow
    @Final
    protected SignBlockEntity sign;
    @Shadow
    @Final
    private String[] messages;
    @Unique
    private Font unlocked_typing$font;

    @Shadow
    protected abstract Vector3f getSignTextScale();

    @Inject(at={@At(value="TAIL")}, method={"renderSignText"})
    private void unlocked_typing$renderSignText$renderPreformattedText(GuiGraphics guiGraphics, CallbackInfo ci) {
        if (this.unlocked_typing$font == null) {
            this.unlocked_typing$font = Minecraft.getInstance().font;
        }
        if (unlocked_typing$preformattedTextTitle == null && unlocked_typing$preformattedTextTitleString == null) {
            unlocked_typing$preformattedTextTitleString = Component.translatable((String)"unlocked_typing.preformattedTextTitle").getString();
            unlocked_typing$preformattedTextTitle = FormattedCharSequence.forward((String)unlocked_typing$preformattedTextTitleString, (Style)Style.EMPTY.withUnderlined(Boolean.valueOf(true)));
        }
        guiGraphics.pose().translate(0.0f, 4.0f);
        Vector3f scale = this.getSignTextScale();
        guiGraphics.pose().scale(scale.x, scale.y);
        int textColor = DyeColor.LIGHT_GRAY.getTextColor();
        int yOffset = 4 * this.sign.getTextLineHeight() / 2;
        int inverseHalfTitleWidth = -this.unlocked_typing$font.width(unlocked_typing$preformattedTextTitleString) / 2;
        guiGraphics.drawString(this.unlocked_typing$font, unlocked_typing$preformattedTextTitle, inverseHalfTitleWidth + 100, yOffset - 51, textColor, false);
        for (int messageIndex = 0; messageIndex < this.messages.length; ++messageIndex) {
            String message = this.messages[messageIndex];
            if (message == null) continue;
            if (this.unlocked_typing$font.isBidirectional()) {
                message = this.unlocked_typing$font.bidirectionalShaping(message);
            }
            int inverseHalfMessageWidth = -this.unlocked_typing$font.width(message) / 2;
            FormattedCharSequence charSequence = FormattedCharSequence.forward((String)message, (Style)Style.EMPTY);
            guiGraphics.drawString(this.unlocked_typing$font, charSequence, inverseHalfMessageWidth + 100, messageIndex * this.sign.getTextLineHeight() - yOffset, textColor, false);
        }
    }
}

